/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util.tools;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.aurora.util.tools.Options;
import oracle.aurora.util.tools.ToolException;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;

public class JdbcOptions
extends Options {
    private static final int THIN = 0;
    private static final int OCI = 1;
    private static final int KPRB = 2;
    private int driver;
    private String user;
    private String password;
    private String database;
    private String db;
    private boolean isDefault;
    private Connection conn;
    private static final String[] oneList = new String[]{"-thin", "-oci", "-kprb", "-log", "-debug", null};
    private static final String[] twoList = new String[]{"-user", "-database", "-password", null};
    private static String[] substList = new String[]{"-u", "-user", "-d", "-database", "-t", "-thin", "-o", "-oci", "-oci8", "-oci", "-p", "-password", null};
    private static final Object[] expandList = new Object[]{null};

    public JdbcOptions(Options defaultOpt) {
        super(oneList, twoList, substList, expandList, defaultOpt);
    }

    public JdbcOptions() {
        this(null);
    }

    void init() throws ToolException {
        if (this.getBoolean("-thin")) {
            this.driver = 0;
            this.isDefault = false;
        } else if (this.getBoolean("-oci")) {
            this.driver = 1;
            this.isDefault = false;
        } else if (this.getBoolean("-kprb")) {
            this.driver = 2;
            this.isDefault = false;
        } else if (System.getProperty("oracle.jserver.version") != null) {
            this.driver = 2;
            this.isDefault = true;
        } else {
            this.driver = 1;
            this.isDefault = true;
        }
        this.user = this.getString("-user");
        if (this.user != null) {
            this.tryFullDBString(this.user);
        }
        if (this.password == null) {
            this.password = this.getString("-password");
        }
        if (this.database == null) {
            this.database = this.getString("-database");
        }
        boolean bl = this.isDefault = this.isDefault && this.user == null && this.password == null && this.database == null;
        if (this.user != null && this.password == null) {
            if (System.getProperty("oracle.jserver.version") == null) {
                this.promptForPassword();
            } else {
                this.password = "";
            }
        }
        if (this.getBoolean("-debug") | this.getBoolean("-log")) {
            OracleLog.setTrace((boolean)true);
            Logger.getLogger("global").setLevel(Level.FINEST);
            Logger.getLogger("oracle.jdbc").setLevel(Level.FINEST);
            Logger.getLogger("oracle.jdbc.driver").setLevel(Level.FINEST);
        }
    }

    public Connection getConnection() throws SQLException, ToolException {
        if (this.conn == null) {
            try {
                DriverManager.registerDriver((Driver)new OracleDriver());
                this.init();
                switch (this.driver) {
                    default: {
                        String oci8DB = this.database == null ? "@" : "@" + this.database;
                        this.db = "jdbc:oracle:oci8:" + oci8DB;
                        break;
                    }
                    case 2: {
                        this.db = "jdbc:oracle:kprb:@";
                        break;
                    }
                    case 0: {
                        String thinDB = this.database == null ? "" : "@" + this.database;
                        this.db = "jdbc:oracle:thin:" + thinDB;
                    }
                }
                this.conn = this.getConnection(this.db, this.user, this.password);
                this.conn.setAutoCommit(false);
            }
            catch (SQLException sqlex) {
                throw sqlex;
            }
            catch (ToolException toolex) {
                throw toolex;
            }
            catch (RuntimeException ex) {
                throw new ToolException(ex + " while opening JDBC Connection", ex);
            }
        }
        return this.conn;
    }

    private Connection getConnection(String db, String user, String password) throws SQLException {
        Properties up = new Properties();
        up.put("user", user);
        up.put("password", password);
        if (user.toUpperCase().equals("SYS") || user.toUpperCase().equals("INTERNAL")) {
            up.put("internal_logon", "sysdba");
        }
        return DriverManager.getConnection(db, up);
    }

    public Connection getNewConnection() throws SQLException, ToolException {
        if (this.conn == null) {
            return this.getConnection();
        }
        Connection newconn = this.getConnection(this.db, this.user, this.password);
        newconn.setAutoCommit(false);
        return newconn;
    }

    public boolean optionsSupplied() {
        return !this.isDefault;
    }

    void tryFullDBString(String dbString) throws ToolException {
        int user_start = 0;
        int user_end = 0;
        int password_start = 0;
        int password_end = 0;
        int database_start = 0;
        int database_end = 0;
        int slash_index = dbString.indexOf("/");
        int at_index = dbString.indexOf("@");
        if (slash_index != -1 && at_index != -1 && slash_index > at_index) {
            throw new ToolException("@ comes after / in database option");
        }
        user_start = 0;
        user_end = slash_index != -1 ? slash_index : (at_index != -1 ? at_index : dbString.length());
        if (slash_index != -1) {
            password_start = slash_index + 1;
            password_end = at_index == -1 ? dbString.length() : at_index;
        }
        if (at_index != -1) {
            database_start = at_index + 1;
            database_end = dbString.length();
        }
        this.user = dbString.substring(user_start, user_end);
        if (slash_index != -1) {
            this.password = dbString.substring(password_start, password_end);
        }
        if (at_index != -1) {
            this.database = dbString.substring(database_start, database_end);
        }
    }

    public String toString() {
        String driverName;
        switch (this.driver) {
            case 1: {
                driverName = "oci";
                break;
            }
            case 0: {
                driverName = "thin";
                break;
            }
            case 2: {
                driverName = "kprb";
                break;
            }
            default: {
                driverName = "";
            }
        }
        return "{driver=" + driverName + ", user=" + this.user + ", database=" + this.database + "}";
    }

    void promptForPassword() {
        HidePasswordFromCommandLine hideThread = new HidePasswordFromCommandLine();
        hideThread.start();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("\nPassword:");
        System.out.print(" ");
        hideThread.hideInput = true;
        try {
            this.password = in.readLine();
            hideThread.stopThread = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.print("\b \b");
    }

    class HidePasswordFromCommandLine
    extends Thread {
        boolean stopThread = false;
        boolean hideInput = false;
        boolean shortMomentGone = false;

        HidePasswordFromCommandLine() {
        }

        public void run() {
            try {
                HidePasswordFromCommandLine.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.shortMomentGone = true;
            while (!this.stopThread) {
                if (this.hideInput) {
                    System.out.print("\b*");
                }
                try {
                    HidePasswordFromCommandLine.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

