/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.aurora.util.Tracer;
import oracle.aurora.util.TypeUtil;

public class TracerManager {
    private static Hashtable tracerTable = new Hashtable();
    private static boolean traceAll = false;

    public static void addTracer(Tracer t) {
        Vector<Tracer> v = (Vector<Tracer>)tracerTable.get(t.getName());
        if (traceAll) {
            t.setTracing(true);
        } else if (v == null) {
            t.setTracing(false);
        } else if (v.size() == 0) {
            t.setTracing(true);
        } else {
            t.setTracing(((Tracer)v.elementAt(0)).isTracing());
        }
        if (v == null) {
            v = new Vector<Tracer>(1);
            tracerTable.put(t.getName(), v);
        }
        if (!v.contains(t)) {
            v.addElement(t);
        }
    }

    public static boolean isTracing(String name) {
        Vector v = (Vector)tracerTable.get(name);
        if (v == null || v.size() == 0) {
            return false;
        }
        return ((Tracer)v.elementAt(0)).isTracing();
    }

    public static Enumeration listTracers() {
        return tracerTable.keys();
    }

    public static void removeTracer(Tracer t) {
        Vector v = (Vector)tracerTable.get(t.getName());
        if (v == null) {
            v = new Vector(1);
        }
        v.removeElement(t);
    }

    public static void setTracing(String nameList, boolean flag) {
        if (nameList == null) {
            return;
        }
        if (nameList.equals("*")) {
            traceAll = flag;
            Enumeration keys = tracerTable.keys();
            while (keys.hasMoreElements()) {
                Vector v = (Vector)tracerTable.get(keys.nextElement());
                for (int i = 0; i < v.size(); ++i) {
                    ((Tracer)v.elementAt(i)).setTracing(flag);
                }
            }
        } else {
            String[] names = TypeUtil.stringToArray(nameList, " ");
            for (int i = 0; i < names.length; ++i) {
                Vector v = (Vector)tracerTable.get(names[i]);
                if (v == null) {
                    v = new Vector();
                    tracerTable.put(names[i], v);
                    continue;
                }
                for (int j = 0; j < v.size(); ++j) {
                    Tracer t = (Tracer)v.elementAt(j);
                    t.setTracing(flag);
                }
            }
        }
    }
}

