/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;

class SLexer {
    static final int maxBufSize = 512;
    static char[] lineTerminator = System.getProperties().getProperty("line.separator").toCharArray();
    PushbackReader reader;
    char[] buf;
    int bufSize;
    static final int tt_eof = 0;
    static final int tt_leftParen = 1;
    static final int tt_ident = 2;
    static final int tt_rightParen = 3;

    SLexer(Reader r) {
        this.reader = new PushbackReader(r, 512);
        this.buf = new char[512];
        this.bufSize = 0;
    }

    String ident() {
        return new String(this.buf, 0, this.bufSize);
    }

    int lexan() throws IOException {
        while (true) {
            int t;
            if ((t = this.reader.read()) == -1) {
                return 0;
            }
            if (t == 59) {
                this.skipThroughComment();
                continue;
            }
            if (t == 34) {
                this.scanString();
                return 2;
            }
            if (SLexer.isIdent((char)t)) {
                this.scanIdent((char)t);
                return 2;
            }
            if (t == 40) {
                return 1;
            }
            if (t == 41) break;
        }
        return 3;
    }

    void skipThroughComment() throws IOException {
        while (true) {
            for (int i = 0; i < lineTerminator.length; ++i) {
                this.buf[i] = (char)this.reader.read();
                if (this.buf[i] == '\uffff') {
                    return;
                }
                if (this.buf[i] == lineTerminator[i]) continue;
                this.reader.unread(this.buf, 1, i);
            }
            break;
        }
    }

    private static boolean isIdent(char t) {
        return t >= 'a' && t <= 'z' || t >= 'A' && t <= 'Z' || t >= '0' && t <= '9' || t == '_' || t == '$' || t == '-' || t == '.' || t == '*' || t == '/' || t == '+' || t == '%' || t == '#' || t == '[' || t == ']' || t == ';';
    }

    void scanIdent(char first) throws IOException {
        this.bufSize = 1;
        this.buf[0] = first;
        int t = 0;
        while (SLexer.isIdent((char)(t = this.reader.read()))) {
            this.buf[this.bufSize++] = (char)t;
        }
        this.reader.unread(t);
    }

    void scanString() throws IOException {
        int t;
        this.bufSize = 0;
        while ((t = this.reader.read()) != 34) {
            this.buf[this.bufSize++] = (char)t;
        }
    }
}

