/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.PrintWriter;
import oracle.aurora.util.Assertion;
import oracle.aurora.util.BTProbe;
import oracle.aurora.util.BTree;
import oracle.aurora.util.BTreeINode;
import oracle.aurora.util.BTreeLNode;

abstract class BTreeNode {
    static final int BSEARCH_CUTOFF = 9;
    static final int INDENT_SIZE = 2;
    protected BTree tree;
    protected BTreeINode parent;
    protected Object[] slots;
    protected short size;

    BTreeNode(BTree tree, BTreeINode parent) {
        this.tree = tree;
        this.parent = parent;
    }

    void printOn(PrintWriter out) {
        this.printOn(out, false, 0);
    }

    void printOn(PrintWriter out, boolean recurse) {
        this.printOn(out, recurse, 0);
    }

    void printOn(PrintWriter out, boolean recurse, int level) {
        out.print("tree: " + this.tree.hashCode() + ", parent: ");
        if (this.parent != null) {
            out.print(this.parent.hashCode());
        } else {
            out.print("<none>");
        }
        out.println(", size: " + this.size);
    }

    static void printOn(PrintWriter out, BTreeNode node, boolean recurse, int level) {
        if (recurse) {
            if (node != null) {
                node.printOn(out, recurse, level);
            } else {
                BTreeNode.indentOn(out, level);
                out.println("<Null Node>");
            }
        } else if (node != null) {
            out.println("node: " + node.hashCode());
        } else {
            BTreeNode.indentOn(out, level);
            out.println("<Null Node>");
        }
    }

    void printElementOn(PrintWriter out, int idx, int level) {
        out.println();
        BTreeNode.indentOn(out, level + 1);
        out.print("Element[" + idx + "]: ");
        Object elm = this.getElement(idx);
        if (elm != null) {
            this.tree.printer.printOn(out, this.getElement(idx));
        } else {
            out.print("<Null Element>");
        }
        out.println();
    }

    static void indentOn(PrintWriter out, int level) {
        for (int i = 0; i < level * 2; ++i) {
            out.print(" ");
        }
    }

    int inodeOrder() {
        return this.tree.inodeOrder;
    }

    int lnodeOrder() {
        return this.tree.lnodeOrder;
    }

    abstract int order();

    abstract int totalSize();

    abstract int totalCapacity();

    void checkIntegrity(BTreeINode par) {
        Assertion.oassert(par == this.parent);
        for (int i = 1; i < this.size; ++i) {
            int comparison = this.tree.comparator.compare(this.getElement(i - 1), this.getElement(i));
            Assertion.oassert(comparison <= 0);
        }
    }

    abstract Object getElement(int var1);

    abstract void setElement(int var1, Object var2);

    abstract boolean probe(Object var1, BTProbe var2);

    abstract Object insert(Object var1, BTProbe var2);

    abstract void removeElement(int var1);

    abstract boolean findNext(BTProbe var1);

    abstract boolean findPrev(BTProbe var1);

    abstract BTreeLNode firstLeaf();

    abstract BTreeLNode lastLeaf();

    boolean isINode() {
        return false;
    }

    boolean isLNode() {
        return !this.isINode();
    }

    abstract void pushLeft(int var1, BTreeNode var2, int var3);

    abstract void pushRight(int var1, BTreeNode var2, int var3);

    abstract void split();

    abstract void splitWithRight(BTreeNode var1, int var2);

    abstract void mergeWithRight(BTreeNode var1, int var2);

    void balanceWithRight(BTreeNode rsib, int index) {
        int newSz;
        short rsSz;
        short sz;
        if (BTree.oassert.on()) {
            Assertion.oassert(this.isINode() == rsib.isINode() && this.parent.getLeftSubTree(index) == this && this.parent.getRightSubTree(index) == rsib);
        }
        if ((sz = this.size) == (rsSz = rsib.size)) {
            return;
        }
        int n = newSz = sz < rsSz ? (sz + rsSz) / 2 : (sz + rsSz + 1) / 2;
        if (newSz == sz) {
            return;
        }
        if (newSz < sz) {
            this.pushRight(sz - newSz, rsib, index);
        } else {
            rsib.pushLeft(newSz - sz, this, index);
        }
    }

    void setParent(BTreeINode p) {
        this.parent = p;
    }

    boolean isFull() {
        return this.size == this.order();
    }

    boolean isLow() {
        return this.size < (this.order() - 1) / 2;
    }

    void checkIfFull() {
        if (this.isFull()) {
            this.nodeFull();
        }
    }

    void checkIfLow() {
        if (this.isLow()) {
            this.nodeLow();
        }
    }

    void nodeFull() {
        if (this.parent != null) {
            this.parent.subTreeFull(this);
        } else {
            this.rootFull();
        }
    }

    void rootFull() {
        if (BTree.oassert.on()) {
            Assertion.oassert(this.tree.root == this);
        }
        BTreeINode newRoot = new BTreeINode(this.tree, null, this);
        this.tree.setRoot(newRoot);
        this.parent = newRoot;
        this.split();
    }

    void nodeLow() {
        if (this.parent != null) {
            this.parent.subTreeLow(this);
        } else {
            this.rootLow();
        }
    }

    void rootLow() {
    }
}

