/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.shell;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.aurora.util.tools.JdbcOptions;
import oracle.aurora.util.tools.ToolException;
import oracle.sql.BLOB;

public class JDBCShellConnection {
    Connection conn;
    CallableStatement send_command_statement;
    CallableStatement get_reply_statement;
    Statement utility_statement;
    CallableStatement runjava_call_statement;
    BackChannel runjava_channel;
    String runjava_sessid;
    boolean runjava_use_server_files;
    Connection runjava_conn;
    String jdwpHost = "localhost";
    int jdwpPort = -1;
    JdbcOptions ops;
    static int bcres = -2;
    static String bcpath;
    static boolean bcexecPending;

    public JDBCShellConnection(JdbcOptions ops) throws ToolException {
        try {
            this.ops = ops;
            this.conn = ops.getConnection();
            this.runjava_conn = ops.getNewConnection();
            this.initStatements();
        }
        catch (SQLException e) {
            throw new ToolException(e.toString(), e);
        }
    }

    public void reconnect() throws ToolException {
        this.close();
        try {
            this.conn = this.ops.getNewConnection();
            this.runjava_conn = this.ops.getNewConnection();
            this.initStatements();
            System.out.println("reconnected to " + this.ops);
        }
        catch (SQLException e) {
            throw new ToolException(e.toString(), e);
        }
    }

    public boolean isClosed() {
        boolean result = true;
        try {
            result = this.conn == null || this.conn.isClosed();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return result;
    }

    private void initStatements() throws SQLException {
        this.send_command_statement = this.conn.prepareCall("begin dbms_java.send_command(:1); end;");
        this.get_reply_statement = this.conn.prepareCall("begin :1 := dbms_java.get_reply; end;");
        this.get_reply_statement.registerOutParameter(1, -4);
        this.utility_statement = this.conn.createStatement();
        this.runjava_call_statement = null;
    }

    public void close() throws ToolException {
        try {
            if (this.runjava_channel != null) {
                this.close_runjava_channel();
            }
            this.runjava_conn.close();
            this.conn.close();
            this.send_command_statement = null;
            this.get_reply_statement = null;
            this.utility_statement = null;
            this.runjava_call_statement = null;
        }
        catch (SQLException e) {
            throw new ToolException(e.toString());
        }
    }

    byte[] getChunks(CallableStatement call) throws SQLException, IOException {
        byte[] bytes;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        do {
            call.execute();
            bytes = call.getBytes(1);
            if (bytes == null) break;
            baos.write(bytes);
        } while (bytes.length == 4000);
        return baos.toByteArray();
    }

    public boolean invoke_command(String[] argv, boolean print_result) throws ToolException {
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            DataOutputStream request = new DataOutputStream(bytesOut);
            request.writeShort(argv.length);
            for (int i = 0; i < argv.length; ++i) {
                request.writeUTF(argv[i]);
            }
            this.passChunks(this.send_command_statement, bytesOut.toByteArray());
            byte[] reply = this.getChunks(this.get_reply_statement);
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(reply));
            if (print_result) {
                while (true) {
                    System.out.print(in.readUTF());
                }
            }
        }
        catch (EOFException eof) {
        }
        catch (IOException e) {
            throw new ToolException(e.toString());
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new ToolException(e.toString());
        }
        return false;
    }

    void passChunks(CallableStatement call, byte[] data) throws SQLException, IOException {
        int chunk_size = 4000;
        for (int i = 0; i < data.length; i += chunk_size) {
            byte[] chunk = new byte[Math.min(chunk_size, data.length - i)];
            System.arraycopy(data, i, chunk, 0, chunk.length);
            call.setBytes(1, chunk);
            call.execute();
        }
    }

    int jdwpConnect(int port, String host) {
        block6: {
            try {
                if (port == this.jdwpPort && host.equals(this.jdwpHost)) break block6;
                if (this.jdwpPort != -1) {
                    try {
                        this.utility_statement.execute("begin dbms_debug_jdwp.disconnect; end;");
                    }
                    catch (Exception e) {
                        System.out.println(e + "\noccurred while attempting to stop listening with previous jdwp settings");
                        System.out.println("port: " + this.jdwpPort + ", host: " + this.jdwpHost);
                    }
                }
                this.jdwpPort = port;
                this.jdwpHost = host;
                if (this.jdwpPort != -1) {
                    this.utility_statement.execute("begin dbms_debug_jdwp.connect_tcp('" + host + "', " + port + "); end;");
                }
            }
            catch (Exception e) {
                System.out.println(e + "\noccurred while attempting to start listening with jdwp settings");
                System.out.println("port: " + this.jdwpPort + ", host: " + this.jdwpHost);
                System.out.println("Turning jdwp mode off");
                this.jdwpPort = -1;
            }
        }
        return this.jdwpPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close_runjava_channel() throws ToolException {
        block8: {
            try {
                if (this.runjava_channel == null) break block8;
                BackChannel channel = this.runjava_channel;
                this.runjava_channel = null;
                try {
                    this.utility_statement.execute("begin dbms_java.rjbc_done;end;");
                }
                catch (Exception e) {
                    Connection conn2 = this.ops.getNewConnection();
                    try {
                        conn2.createStatement().execute("begin dbms_java.rjbc_done('" + this.runjava_sessid + "');end;");
                    }
                    finally {
                        conn2.close();
                    }
                }
                if (channel.isAlive()) {
                    channel.join(5000L);
                    channel.stop();
                }
                JDBCShellConnection.bcreinit();
            }
            catch (Exception e) {
                throw new ToolException(e.toString());
            }
        }
    }

    public boolean invoke_runjava(String[] argv, boolean use_server_files) throws ToolException {
        block16: {
            try {
                String result;
                block15: {
                    if (this.runjava_call_statement == null) {
                        this.runjava_call_statement = this.conn.prepareCall("begin ? := DBMS_JAVA.RUNJAVA(?);end;");
                        this.runjava_call_statement.registerOutParameter(1, 1);
                    }
                    if (this.runjava_channel != null && !this.runjava_channel.isAlive()) {
                        this.runjava_channel = null;
                    }
                    if (this.runjava_channel != null && this.runjava_use_server_files != use_server_files) {
                        this.close_runjava_channel();
                    }
                    this.runjava_use_server_files = use_server_files;
                    if (this.runjava_channel == null && this.runjava_conn.isClosed()) {
                        this.runjava_conn = this.ops.getNewConnection();
                    }
                    if (this.runjava_channel == null) {
                        CallableStatement s = this.conn.prepareCall("begin ?:=dbms_java.rjbc_init(" + (this.runjava_use_server_files ? 1 : 0) + ");end;");
                        s.registerOutParameter(1, 1);
                        s.execute();
                        this.runjava_sessid = s.getString(1);
                        s.close();
                        this.runjava_channel = new BackChannel();
                        this.runjava_channel.start();
                    }
                    StringBuilder stmt = new StringBuilder(200);
                    if (argv.length > 1) {
                        stmt.append(argv[1]);
                    }
                    for (int i = 2; i < argv.length; ++i) {
                        stmt.append(" ");
                        stmt.append(argv[i]);
                    }
                    this.runjava_call_statement.setString(2, stmt.toString());
                    result = "???";
                    try {
                        this.runjava_call_statement.execute();
                        result = this.runjava_call_statement.getString(1);
                    }
                    catch (SQLException e) {
                        result = e.getMessage();
                        int end = result.lastIndexOf("ORA-06512: at \"SYS.DBMS_JAVA_TEST\", line 2");
                        if (end <= 0) break block15;
                        result = result.substring(0, end);
                    }
                }
                if (result == null || result.length() == 0) {
                    System.out.println("\nrunjava call succeeded");
                    break block16;
                }
                System.out.println("\nrunjava call returned:\n  " + result);
                try {
                    if (!this.conn.isClosed()) {
                        this.utility_statement.execute("begin null;end;");
                    }
                }
                catch (Exception ee) {}
            }
            catch (SQLException e) {
                System.out.println("\nrunjava call aborted by:\n  ");
                throw new ToolException(e.toString());
            }
        }
        return false;
    }

    static void bcreinit() {
        bcres = -2;
        bcexecPending = true;
    }

    static {
        bcexecPending = true;
    }

    private class BackChannel
    extends Thread {
        BLOB lob;

        private BackChannel() {
        }

        public void run() {
            try {
                this.lob = BLOB.createTemporary((Connection)JDBCShellConnection.this.runjava_conn, (boolean)true, (int)10);
                CallableStatement s = JDBCShellConnection.this.runjava_conn.prepareCall("begin ?:=dbms_java.rjbc_respond('" + JDBCShellConnection.this.runjava_sessid + "', ?, ?, ?);end;");
                s.registerOutParameter(1, 2);
                s.registerOutParameter(3, 12);
                if (bcexecPending) {
                    s.setInt(2, -1);
                }
                s.setObject(4, (Object)this.lob);
                while (true) {
                    if (bcexecPending) {
                        s.execute();
                        bcres = s.getInt(1);
                        bcpath = s.getString(3);
                        bcexecPending = false;
                    }
                    if (bcres < 0 || bcres > 3) break;
                    boolean found = false;
                    switch (bcres) {
                        case 0: {
                            if (this.lob == null) {
                                this.lob = BLOB.createTemporary((Connection)JDBCShellConnection.this.runjava_conn, (boolean)true, (int)10);
                            }
                            this.lob.truncate(0L);
                            try {
                                int len;
                                FileInputStream is = new FileInputStream(bcpath);
                                OutputStream os = this.lob.setBinaryStream(1L);
                                byte[] buf = new byte[10000];
                                int tlen = 0;
                                while ((len = is.read(buf, 0, 10000)) > 0) {
                                    os.write(buf, 0, len);
                                    tlen += len;
                                }
                                os.close();
                                found = true;
                                is.close();
                                s.setBlob(4, (Blob)this.lob);
                            }
                            catch (FileNotFoundException fn) {}
                            break;
                        }
                        case 1: {
                            File f = new File(bcpath);
                            if (f.exists()) {
                                found = f.isDirectory();
                                bcpath = f.getAbsolutePath();
                                if (found && !bcpath.endsWith("/")) {
                                    bcpath = bcpath + "/";
                                }
                            } else {
                                found = true;
                                bcpath = "/dev/null/";
                            }
                            s.setString(3, bcpath);
                            break;
                        }
                        case 2: {
                            System.out.println(bcpath);
                            break;
                        }
                        case 3: {
                            System.out.print(bcpath);
                            break;
                        }
                        default: {
                            System.out.println("*** Unknown action " + bcres + " received by BackChannel");
                        }
                    }
                    s.setInt(2, found ? 0 : 1);
                    bcexecPending = true;
                }
                s.close();
            }
            catch (Exception e) {
                bcexecPending = false;
                System.out.println("runjava backchannel session ended unexpectedly due to\n  " + e);
            }
        }
    }
}

