/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms.url.jserver;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import oracle.aurora.rdbms.ClassHandle;
import oracle.aurora.rdbms.DbmsJava;
import oracle.aurora.rdbms.Handle;
import oracle.aurora.rdbms.InvalidResolverPatternException;
import oracle.aurora.rdbms.ObjectTypeChangedException;
import oracle.aurora.rdbms.Resolver;
import oracle.aurora.rdbms.ResolverTerm;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.SchemaNotFoundException;
import oracle.aurora.rdbms.url.jserver.JserverURLHandle;

public class JserverURLConnection
extends URLConnection {
    String name;
    JserverURLHandle handle;
    Schema schema;
    Resolver resolver;
    int kind;
    boolean connected;
    boolean classPathURL;
    boolean loadPrivate;
    static Resolver publicResolver_;
    private static final Class stopClass;
    private static final int LOCATION = 52;
    private static final int RJBC = 666;

    JserverURLConnection(URL u) {
        super(u);
    }

    public String getName() {
        return this.name;
    }

    public int getKind() {
        return this.kind;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public boolean classPathURL() {
        return this.classPathURL;
    }

    public boolean loadPrivate() {
        return this.loadPrivate;
    }

    public boolean rjbc() {
        return this.kind == 666;
    }

    public boolean isBootstrap() {
        try {
            Handle h;
            this.connect();
            if ((this.kind == 29 || this.kind == 30 || this.kind == 56) && (h = (Handle)this.getHandle()) != null && h.classesBinP()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void connect() throws IOException {
        if (!this.connected) {
            this.parsePath(this.getURL().getFile());
            this.handle = this.getHandle();
            this.connected = true;
        }
    }

    public Permission getPermission() {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        this.connect();
        if (this.handle == null) {
            throw this.exception("lookup failed for " + this.name);
        }
        return this.handle.inputStream();
    }

    public String getContentType() {
        String type = null;
        int k = this.kind;
        InputStream s = null;
        try {
            s = this.getInputStream();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.handle != null) {
            k = this.handle.type();
        }
        switch (k) {
            case 29: {
                type = "application/java-vm";
                break;
            }
            case 28: {
                type = "text/plain";
                break;
            }
            case 31: {
                type = "x-java/jar";
                break;
            }
            default: {
                if (s != null) {
                    try {
                        type = JserverURLConnection.guessContentTypeFromStream(s);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (type != null) break;
                type = this.name != null ? JserverURLConnection.guessContentTypeFromName(this.name) : "content/unknown";
            }
        }
        return type;
    }

    public String jarName() {
        try {
            this.connect();
            return this.handle.jarName();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private JserverURLHandle getHandle(String name, int kind) throws IOException {
        JserverURLHandle h = null;
        if (kind == 666) {
            try {
                InputStream s = DbmsJava.getRJBCStream(name);
                h = new RJBCHandle(s);
            }
            catch (SQLException e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        } else if (kind == 31) {
            if (this.schema != null) {
                try {
                    InputStream s = DbmsJava.getJarStream(name, this.schema);
                    h = new JarHandle(s, this.schema.toString() + ':' + name);
                }
                catch (SQLException e) {
                    IOException ioe = new IOException();
                    ioe.initCause(e);
                    throw ioe;
                }
            }
        } else if (this.schema != null) {
            h = Handle.lookup(name, this.schema, kind);
        } else if (this.resolver != null) {
            h = Handle.lookup(name, this.resolver, kind);
        }
        return h;
    }

    private JserverURLHandle getHandle() throws IOException {
        String classname;
        JserverURLHandle h = null;
        h = this.getHandle(this.name, this.kind);
        if (h == null && this.kind == 30 && this.name.endsWith(".class")) {
            classname = this.name.substring(0, this.name.length() - 6);
            h = this.getHandle(classname, 29);
        }
        if (h == null && this.kind == 30 && this.name.endsWith(".java")) {
            classname = this.name.substring(0, this.name.length() - 5);
            h = this.getHandle(classname, 28);
        }
        if (h == null && this.kind == 30 && this.name.endsWith(".sqlj")) {
            classname = this.name.substring(0, this.name.length() - 5);
            h = this.getHandle(classname, 28);
        }
        return h;
    }

    private void parsePath(String path) throws IOException {
        char c;
        Parser parser = new Parser(path);
        String token = parser.getNext();
        this.classPathURL = false;
        int delim = 47;
        if (!(token.length() <= 1 || (c = token.charAt(0)) != 'C' && c != 'c' || (c = token.charAt(1)) != 'P' && c != 'p')) {
            this.classPathURL = true;
            if (token.length() > 2) {
                char c2 = token.charAt(2);
                delim = c2;
                parser.resetDelimiter(c2);
            }
            if ((token = parser.getNext()).equals("RJBC")) {
                this.kind = 666;
                this.loadPrivate = true;
                this.name = path.substring(parser.endPos() + 1);
                return;
            }
        }
        boolean schemaSeen = false;
        if (!this.classPathURL && token.equals("class")) {
            this.kind = 29;
        } else if (!this.classPathURL && token.equals("source")) {
            this.kind = 28;
        } else if (this.classPathURL && token.equalsIgnoreCase("schema")) {
            this.kind = 52;
            schemaSeen = true;
            if (delim != 47) {
                parser.noteSlashDelimiter();
            }
            this.schema = this.schemaFor(parser.getNext());
        } else if (this.classPathURL && token.equalsIgnoreCase("private")) {
            this.kind = 52;
            this.loadPrivate = true;
            if (delim != 47) {
                parser.noteSlashDelimiter();
            }
        } else if (token.equalsIgnoreCase("resource")) {
            this.kind = 30;
        } else if (token.equalsIgnoreCase("shared_data")) {
            this.kind = 56;
        } else if (token.equalsIgnoreCase("jar")) {
            this.kind = 31;
        } else {
            throw this.exception(token + " not a recognized kind");
        }
        if (!schemaSeen) {
            token = parser.getNext();
            if (this.classPathURL && !this.loadPrivate && token.equalsIgnoreCase("private")) {
                this.loadPrivate = true;
                token = parser.getNext();
            }
            if (this.classPathURL ? token.equalsIgnoreCase("schema") : token.equals("schema")) {
                this.schema = this.schemaFor(parser.getNext());
            } else {
                if (this.classPathURL) {
                    throw this.exception(token + " appears where \"schema\" expected");
                }
                if (this.kind == 31) {
                    throw this.exception(token + " is not a recognized location for a jar");
                }
                if (token.equals("resolver")) {
                    this.resolver = this.resolverFor(parser.getNext());
                } else if (token.equals("dynamic")) {
                    this.resolver = this.dynamicResolver();
                } else {
                    throw this.exception(token + " is not a recognized location");
                }
            }
        }
        if (this.kind != 52 || parser.more()) {
            parser.next();
            this.name = parser.remaining();
        } else {
            this.name = null;
        }
        if (this.kind == 52 && this.name != null) {
            if (this.name.endsWith(".class")) {
                this.kind = 29;
                this.name = this.name.substring(0, this.name.length() - 6);
            } else {
                this.kind = 30;
            }
        }
    }

    Schema schemaFor(String schemaName) {
        Schema s = schemaName.equalsIgnoreCase("sys") ? Schema.systemSchema : (schemaName.equalsIgnoreCase("public") ? Schema.publicSchema : Schema.lookup(schemaName));
        return s;
    }

    Resolver resolverFor(String resolverSpec) throws IOException {
        Resolver resolver;
        try {
            resolver = new Resolver(resolverSpec);
        }
        catch (SchemaNotFoundException ex) {
            throw this.exception(ex, "creating resolver");
        }
        catch (InvalidResolverPatternException ex) {
            throw this.exception(ex, "creating resolver");
        }
        return resolver;
    }

    Resolver dynamicResolver() throws IOException {
        Resolver r;
        ResolverTerm[] terms = new ResolverTerm[1];
        try {
            terms[0] = new ResolverTerm("*", Schema.dynamicSchema);
            r = new Resolver(terms);
        }
        catch (SchemaNotFoundException ex) {
            throw this.exception(ex, "creating resolver");
        }
        catch (InvalidResolverPatternException ex) {
            throw this.exception(ex, "creating resolver");
        }
        return r;
    }

    Resolver systemResourceResolver() throws IOException {
        Resolver r;
        int x;
        Class[] stack = this.getStack();
        for (x = 0; x < stack.length && stack[x] != stopClass; ++x) {
        }
        while (x < stack.length && stack[x].isInstance(stopClass)) {
            ++x;
        }
        if (++x >= stack.length) {
            throw this.exception("ClassLoader not in caller stack");
        }
        Class caller = stack[x];
        ClassHandle callerHandle = ClassHandle.lookup(caller);
        if (callerHandle == null) {
            r = this.publicResolver();
        } else {
            try {
                r = this.makeConcrete(callerHandle.resolver(), callerHandle);
            }
            catch (ObjectTypeChangedException ex) {
                throw new IOException("exception " + ex.toString());
            }
        }
        return r;
    }

    Resolver makeConcrete(Resolver r, Handle h) {
        Resolver result = r;
        if (r == null) {
            result = this.publicResolver();
        } else if (r == Resolver.defaultResolver()) {
            try {
                ResolverTerm[] terms = new ResolverTerm[]{new ResolverTerm("*", h.schema()), new ResolverTerm("*", Schema.publicSchema)};
                result = new Resolver(terms);
            }
            catch (SchemaNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (InvalidResolverPatternException ex) {
                ex.printStackTrace();
            }
        }
        return r;
    }

    Resolver publicResolver() {
        if (publicResolver_ == null) {
            try {
                ResolverTerm[] terms = new ResolverTerm[]{new ResolverTerm("*", Schema.publicSchema)};
                publicResolver_ = new Resolver(terms);
            }
            catch (InvalidResolverPatternException ex) {
                ex.printStackTrace();
            }
            catch (SchemaNotFoundException ex) {
                ex.printStackTrace();
            }
        }
        return publicResolver_;
    }

    Class[] getStack() {
        class MySecurityManager
        extends SecurityManager {
            MySecurityManager() {
            }

            Class[] getStack() {
                return this.getClassContext();
            }
        }
        MySecurityManager m = (MySecurityManager)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new MySecurityManager();
            }
        });
        Class[] stack = m.getStack();
        return stack;
    }

    IOException exception(String msg) {
        return new MalformedURLException(msg + " (" + this.getURL() + ")");
    }

    IOException exception(Exception ex, String when) {
        return new MalformedURLException("exception " + ex.toString() + " while " + when);
    }

    static {
        stopClass = ClassLoader.class;
    }

    private class RJBCHandle
    implements JserverURLHandle {
        InputStream stream;

        private RJBCHandle(InputStream s) {
            this.stream = s;
        }

        public int type() {
            return 666;
        }

        public InputStream inputStream() {
            return this.stream;
        }

        public String jarName() {
            return null;
        }
    }

    private class JarHandle
    implements JserverURLHandle {
        InputStream stream;
        String jname;

        private JarHandle(InputStream s, String jarname) {
            this.stream = s;
            JserverURLConnection.this.name = jarname;
        }

        public int type() {
            return 31;
        }

        public InputStream inputStream() {
            return this.stream;
        }

        public String jarName() {
            return this.jname;
        }
    }

    class Parser {
        String path;
        int plen;
        String part;
        int xBegin = -1;
        int xEnd = -1;
        int slashDelimiterPos;
        char delim = (char)47;

        Parser(String path) {
            this.path = path;
            this.slashDelimiterPos = this.plen = path.length();
        }

        void next() throws IOException {
            this.xBegin = this.xEnd + 1;
            if (this.xBegin >= this.plen) {
                throw JserverURLConnection.this.exception("not enough components in path");
            }
            while ((this.path.charAt(this.xBegin) == this.delim || this.xBegin == this.slashDelimiterPos) && this.xBegin < this.plen) {
                ++this.xBegin;
            }
            this.xEnd = this.path.indexOf(this.delim, this.xBegin);
            if (this.xEnd < 0) {
                this.xEnd = this.plen;
            }
            if (this.xEnd > this.slashDelimiterPos && this.xBegin < this.slashDelimiterPos) {
                this.xEnd = this.slashDelimiterPos;
            }
            this.part = null;
        }

        boolean more() {
            return this.xEnd + 1 < this.plen;
        }

        String get() {
            if (this.part == null) {
                this.part = this.path.substring(this.xBegin, this.xEnd);
            }
            return this.part;
        }

        String getNext() throws IOException {
            this.next();
            return this.get();
        }

        void resetDelimiter(char c) throws IOException {
            this.xEnd = this.xBegin - 1;
            this.delim = c;
            this.next();
        }

        void noteSlashDelimiter() {
            this.slashDelimiterPos = this.path.lastIndexOf("/");
            if (this.slashDelimiterPos == -1) {
                this.slashDelimiterPos = this.plen;
            }
        }

        int startPos() {
            return this.xBegin;
        }

        int endPos() {
            return this.xEnd;
        }

        String remaining() {
            String r = this.path.substring(this.xBegin);
            this.xBegin = this.plen;
            this.xEnd = this.plen;
            return r;
        }
    }
}

