/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms.security;

import java.security.Permission;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.aurora.rdbms.security.PolicyTable;
import oracle.aurora.rdbms.security.RowData;
import oracle.aurora.rdbms.security.TypeDescriptor;
import oracle.aurora.vm.IdNotFoundException;

class PolicyTableRow
extends RowData {
    private Permission instantiation;
    PolicyTable table;

    PolicyTableRow(PolicyTable table, ResultSet resultSet) {
        super(null);
        this.table = table;
        try {
            this.kind = resultSet.getInt(1);
            this.schema = resultSet.getLong(2);
            this.type_schema = resultSet.getLong(3);
            this.type_name = resultSet.getString(4);
            this.name = resultSet.getString(5);
            this.action = resultSet.getString(6);
            this.status = resultSet.getInt(7);
            this.key = resultSet.getLong(8);
        }
        catch (SQLException ex) {
            table.noteError(ex);
            this.status = 3;
        }
    }

    PolicyTableRow(PolicyTable table, int kind, long schema, long type_schema, String type_name, String name, String action, int status, long key) {
        super(kind, schema, type_schema, type_name, name, action, status, key);
        this.table = table;
    }

    PolicyTableRow(PolicyTable table, RowData rhs) {
        super(rhs);
        this.table = table;
    }

    private TypeDescriptor getTypeDescriptor() throws IdNotFoundException {
        return new TypeDescriptor(this.table, this.type_schema, this.type_name);
    }

    Permission instantiate() throws InstantiationException {
        if (this.instantiation == null) {
            try {
                this.instantiation = this.instantiate(this.permissionClass());
            }
            catch (IdNotFoundException ex) {
                throw new InstantiationException(ex.toString());
            }
            catch (ClassNotFoundException ex) {
                throw new InstantiationException(ex.toString());
            }
        }
        return this.instantiation;
    }

    Class permissionClass() throws IdNotFoundException, ClassNotFoundException {
        return this.getTypeDescriptor().classForName();
    }
}

