/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.io.IOException;
import java.io.InputStream;
import oracle.aurora.rdbms.HandleHolder;
import oracle.aurora.rdbms.KGEException;
import oracle.aurora.rdbms.ModifyPermissionException;
import oracle.aurora.rdbms.NameInUseException;
import oracle.aurora.rdbms.NoSchema;
import oracle.aurora.rdbms.ReferencingHandle;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.WouldReplaceException;
import oracle.sql.CHAR;

public final class SharedDataHandle
extends ReferencingHandle {
    private static final int REPLACE = 1;
    private static final int FIXED_IN_SESSION = 2;
    private static final int REPLACABLE = 4;

    SharedDataHandle(String name, Schema schema, long index, byte[] timestamp) {
        super(name, schema, index, timestamp);
    }

    public int type() {
        return 56;
    }

    private static native void create(String var0, CHAR var1, Object var2, int var3, HandleHolder var4, String var5) throws NameInUseException, WouldReplaceException, ModifyPermissionException;

    private native Object access(int var1) throws ClassNotFoundException;

    public static SharedDataHandle create(String name, Schema schema, Object root, boolean replace, boolean fixed, boolean replacable) throws NameInUseException, WouldReplaceException, ModifyPermissionException {
        if (schema == null) {
            schema = Schema.currentSchema();
        }
        if (name == null) {
            throw new IllegalArgumentException("Null name supplied");
        }
        if (name.length() == 0 || name.charAt(0) == '/') {
            throw new IllegalArgumentException("Illegal name supplied");
        }
        if (schema instanceof NoSchema) {
            throw new IllegalArgumentException("Schema instanceof NoSchema");
        }
        if (root == null) {
            throw new IllegalArgumentException("Null root supplied");
        }
        CHAR schemaName = schema.name();
        HandleHolder holder = new HandleHolder();
        int flags = (replace ? 1 : 0) | (fixed ? 2 : 0) | (replacable ? 4 : 0);
        try {
            SharedDataHandle.create(name, schemaName, root, flags, holder, null);
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow("SharedDataHandle.create for " + schema.toString() + "." + name);
        }
        SharedDataHandle h = (SharedDataHandle)holder.handle;
        if (h == null) {
            h = new SharedDataHandle(holder.name, schema, holder.index, holder.timestamp);
        }
        return h;
    }

    public static SharedDataHandle create(String name, Schema schema, Object root, boolean replace) throws NameInUseException, WouldReplaceException, ModifyPermissionException {
        return SharedDataHandle.create(name, schema, root, replace, false, false);
    }

    public static SharedDataHandle create(String name, Schema schema, Object root, boolean replace, boolean fixed) throws NameInUseException, WouldReplaceException, ModifyPermissionException {
        return SharedDataHandle.create(name, schema, root, replace, fixed, false);
    }

    public static SharedDataHandle createReplacable(String name, Schema schema, Object root, boolean replace, boolean fixed) throws NameInUseException, WouldReplaceException, ModifyPermissionException {
        return SharedDataHandle.create(name, schema, root, replace, fixed, true);
    }

    public Object access() throws ClassNotFoundException {
        return this.access(0);
    }

    String sharedPrivateClassName() {
        String result = null;
        if (this.name.startsWith("prv//////")) {
            try {
                InputStream s = this.inputStream();
                int available = s.available();
                if (available > 12) {
                    int pos = 0;
                    s.skip(8L);
                    pos = (s.read() << 24) + (s.read() << 16) + (s.read() << 8) + s.read();
                    if (available >= pos + 2) {
                        byte[] b;
                        s.skip(pos);
                        int len = (s.read() << 8) + s.read();
                        if (len > 0 && available >= pos + 2 + len && s.read(b = new byte[len]) == len) {
                            String tmp;
                            result = tmp = new String(b, "UTF8");
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }
}

