/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import oracle.aurora.rdbms.DbmsJava;
import oracle.aurora.rdbms.InvalidResolverPatternException;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.SchemaNotFoundException;
import oracle.sql.CHAR;

public final class ResolverTerm {
    private String pattern;
    private Schema schema;

    public ResolverTerm(String pattern, Schema schema) throws SchemaNotFoundException, InvalidResolverPatternException {
        if (pattern == null) {
            throw new InvalidResolverPatternException();
        }
        if (schema == null) {
            throw new SchemaNotFoundException();
        }
        this.pattern = pattern;
        this.schema = schema.baseSchema();
    }

    public ResolverTerm(String pattern, CHAR schemaName) throws SchemaNotFoundException, InvalidResolverPatternException {
        this(pattern, Schema.lookup(schemaName));
    }

    public ResolverTerm(String pattern, String schemaName) throws SchemaNotFoundException, InvalidResolverPatternException {
        this(pattern, Schema.lookup(schemaName));
    }

    public String pattern() {
        return this.pattern;
    }

    public Schema schema() {
        return this.schema;
    }

    public String schemaName() {
        return this.schema.toString();
    }

    public String toString() {
        return "ResolverTerm(" + this.pattern + " " + this.schema + ")";
    }

    public int hashCode() {
        return this.pattern.hashCode() ^ this.schema.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ResolverTerm && this.pattern.equals(((ResolverTerm)obj).pattern()) && this.schema.equals(((ResolverTerm)obj).schema());
    }

    public Class lookup(String classname) throws ClassNotFoundException {
        Class theClass = null;
        if (this.match(classname)) {
            theClass = DbmsJava.classForNameAndSchema(classname, this.schema);
        }
        if (theClass == null) {
            throw new ClassNotFoundException(classname + " not found in " + this.schema);
        }
        return theClass;
    }

    public boolean match(String target) {
        return this.pattern.endsWith("*") ? this.pattern.length() == 1 || target.startsWith(this.pattern.substring(0, this.pattern.length() - 1)) : target.equals(this.pattern);
    }
}

