/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import oracle.aurora.rdbms.ClassHandle;
import oracle.aurora.rdbms.EnvironmentSpecificImpl;
import oracle.aurora.rdbms.Handle;
import oracle.aurora.rdbms.ObjectTypeChangedException;
import oracle.aurora.rdbms.Resolver;
import oracle.aurora.rdbms.ResolverWalker;
import oracle.aurora.rdbms.ResourceHandle;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.vm.IUClassLoader;
import oracle.aurora.vm.IUHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OracleClassLoader
extends IUClassLoader {
    private static Hashtable loadersByResolverAndSchema = new Hashtable();
    private Resolver resolver;
    private Hashtable referencedClasses;
    private Schema schema;
    private final URL[] urlHolder = new URL[1];

    static ClassLoader assignClassLoader(Class c) {
        return OracleClassLoader.assignClassLoader(c, null, false);
    }

    public static native ClassLoader assignedLoader(Class var0);

    private static ClassLoader assignClassLoader(Class c, Resolver useres, boolean fresh) {
        ClassHandle h;
        Vector bucket;
        OracleClassLoader result = null;
        ClassHandle handle = ClassHandle.lookup(c);
        Schema schema = handle.schema();
        Resolver res = useres;
        ClassHandle[] refs = null;
        try {
            if (res == null) {
                res = handle.resolver();
            }
            refs = handle.referencedClassHandles();
        }
        catch (ObjectTypeChangedException e) {
            String msg = "Unexpected " + e + " in OracleClassLoader.assignClassLoader(" + c + ", " + useres + ", " + fresh + ")";
            System.err.println(msg);
            e.printStackTrace();
            InternalError err = new InternalError(msg);
            err.initCause(e);
            throw err;
        }
        int refs_length = refs.length;
        Pair pair = new Pair(res, schema);
        if (!fresh && (bucket = (Vector)loadersByResolverAndSchema.get(pair)) != null) {
            int bucket_size = bucket.size();
            for (int i = 0; i < bucket_size; ++i) {
                String name;
                ClassHandle already;
                OracleClassLoader candidate = (OracleClassLoader)bucket.elementAt(i);
                if (candidate.referencedClasses == null) continue;
                h = handle;
                int j = 0;
                while (!((already = ClassHandle.lookup(candidate.findLoadedClass(name = h.name()))) != null && already != h || (already = (ClassHandle)candidate.referencedClasses.get(name)) != null && already != h || (h = j < refs_length ? refs[j++] : null) == null)) {
                }
                if (h != null) continue;
                result = candidate;
                break;
            }
        }
        if (result == null) {
            result = OracleClassLoader.mk(pair);
        }
        result.referencedClasses.put(handle.name(), handle);
        for (int i = 0; i < refs_length; ++i) {
            h = refs[i];
            result.referencedClasses.put(h.name(), h);
        }
        return result;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public static OracleClassLoader get(Resolver res, Schema schema, boolean fresh, boolean empty, Class c) {
        ClassLoader result = null;
        if (c == null) {
            Vector bucket;
            if (schema == null) {
                schema = Schema.noSchema;
            }
            Pair pair = new Pair(res, schema);
            if (!fresh && (bucket = (Vector)loadersByResolverAndSchema.get(pair)) != null) {
                int bucket_size = bucket.size();
                for (int i = 0; i < bucket_size; ++i) {
                    OracleClassLoader candidate = (OracleClassLoader)bucket.elementAt(i);
                    if (candidate.referencedClasses == null != empty) continue;
                    result = candidate;
                    break;
                }
            }
            if (result == null) {
                result = OracleClassLoader.mk(pair, empty);
            }
        } else if (OracleClassLoader.assignedLoader(c) == null) {
            result = OracleClassLoader.assignClassLoader(c, res, fresh);
        }
        return (OracleClassLoader)result;
    }

    private static OracleClassLoader mk(final Pair pair, final boolean empty) {
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                return new OracleClassLoader(pair, empty);
            }
        };
        return (OracleClassLoader)AccessController.doPrivileged(action);
    }

    private static OracleClassLoader mk(Pair pair) {
        return OracleClassLoader.mk(pair, false);
    }

    private OracleClassLoader(Pair pair, boolean empty) {
        super(null);
        this.resolver = pair.resolver;
        this.schema = pair.schema;
        this.referencedClasses = empty ? null : new Hashtable();
        Vector<OracleClassLoader> bucket = (Vector<OracleClassLoader>)loadersByResolverAndSchema.get(pair);
        if (bucket == null) {
            bucket = new Vector<OracleClassLoader>();
            loadersByResolverAndSchema.put(pair, bucket);
        }
        bucket.addElement(this);
    }

    private final native Class findLoadedClassnormalizeform(String var1);

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        String normalized_name = name.replace('.', '/');
        Class c = this.findLoadedClassnormalizeform(normalized_name);
        if (c == null) {
            c = this.findClass(normalized_name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public IUHandle findClassHandle(String name) {
        ClassHandle ref = (ClassHandle)this.referencedClasses.get(name);
        if (ref == null) {
            ref = Handle.lookupClass(name, this.resolver, false);
        }
        return ref;
    }

    protected final native void noteLoadedClass(Class var1);

    protected Class findClass(String name) throws ClassNotFoundException {
        String normalized_name = name.replace('.', '/');
        ClassHandle ref = (ClassHandle)this.findClassHandle(normalized_name);
        try {
            if (ref != null) {
                if (this.schema != Schema.noSchema && !ref.hasExecutePrivilege(this.schema)) {
                    String msg = name + " has not granted execute privilege to " + this.schema;
                    throw new ClassNotFoundException(msg);
                }
                Class result = ref.loadClass();
                if (result == null) {
                    throw new ClassNotFoundException(name + " (no associated class)");
                }
                this.noteLoadedClass(result);
                return result;
            }
        }
        catch (ObjectTypeChangedException e) {
            throw new ClassNotFoundException(name + " (class changed)");
        }
        throw new ClassNotFoundException(name);
    }

    private URL resourceHandleToUrl(ResourceHandle res, String name) {
        URL url;
        block5: {
            url = null;
            try {
                if (res == null || this.schema != Schema.noSchema && !res.hasExecutePrivilege(this.schema)) break block5;
                Schema s = res.schema();
                try {
                    url = new URL("jserver", null, "/resource/schema/" + s.name() + "/" + name);
                    if (res.jarName() != null) {
                        url = EnvironmentSpecificImpl.perhapsTransformURL(url, false);
                    }
                }
                catch (MalformedURLException mue) {
                    String msg = "Malformed URL from  OracleClassLoader.resourceHandleToUrl(" + url + ")";
                    System.err.println(msg);
                    mue.printStackTrace();
                    InternalError err = new InternalError(msg);
                    err.initCause(mue);
                    throw err;
                }
            }
            catch (ObjectTypeChangedException e) {
                // empty catch block
            }
        }
        return url;
    }

    private URL[] findOneOrMoreResources(String name, URL[] urls) {
        Schema s;
        boolean all;
        ResolverWalker walker = new ResolverWalker(this.resolver, name);
        int urlCount = 0;
        boolean bl = all = urls == null;
        if (all) {
            urls = new URL[this.resolver.length()];
        }
        while ((s = walker.next()) != null) {
            String jarPrefix = walker.jarPrefix();
            String lookupName = jarPrefix == null ? name : jarPrefix + name;
            URL url = this.resourceHandleToUrl(Handle.lookupResource(lookupName, s), name);
            if (url == null) continue;
            urls[urlCount++] = url;
            if (all) continue;
            break;
        }
        if (all) {
            URL[] turls = urls;
            urls = new URL[urlCount];
            System.arraycopy(turls, 0, urls, 0, urlCount);
        }
        return urls;
    }

    @Override
    protected URL findResource(String name) {
        this.urlHolder[0] = null;
        this.findOneOrMoreResources(name, this.urlHolder);
        return this.urlHolder[0];
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        final URL[] urls = this.findOneOrMoreResources(name, null);
        return new Enumeration(){
            private int i = 0;
            private final int l = urls.length;

            public Object nextElement() {
                if (this.i < this.l) {
                    return urls[this.i++];
                }
                throw new NoSuchElementException();
            }

            public boolean hasMoreElements() {
                return this.i < this.l;
            }
        };
    }

    static native ClassLoader getSystemClassLoader(ClassLoader var0, ClassLoader var1);

    public String toString() {
        return "OracleClassLoader: [" + this.resolver + ", " + this.schema + "]";
    }

    private static class Pair {
        Resolver resolver;
        Schema schema;

        Pair(Resolver resolver, Schema schema) {
            this.resolver = resolver;
            this.schema = schema;
        }

        public int hashCode() {
            return this.resolver.hashCode() + this.schema.hashCode();
        }

        public boolean equals(Object rhs) {
            boolean result = false;
            if (rhs instanceof Pair) {
                Pair rhsPair = (Pair)rhs;
                result = this.resolver.equals(rhsPair.resolver) && this.schema.equals(rhsPair.schema);
            }
            return result;
        }

        public String toString() {
            return "Pair(" + this.resolver + ", " + this.schema + ")";
        }
    }
}

