/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Member;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import oracle.aurora.rdbms.ClassHandle;
import oracle.aurora.rdbms.DbmsJava;
import oracle.aurora.rdbms.EnvironmentSpecificImplReadOnly;
import oracle.aurora.rdbms.ExecutePermissionException;
import oracle.aurora.rdbms.Handle;
import oracle.aurora.rdbms.HandleInput;
import oracle.aurora.rdbms.ObjectTypeChangedException;
import oracle.aurora.rdbms.OracleClassLoader;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.SecurityManagerImpl;
import oracle.aurora.rdbms.SharedDataHandle;
import oracle.aurora.rdbms.SourceHandle;
import oracle.aurora.rdbms.security.PolicyTable;
import oracle.aurora.rdbms.security.SchemaProtectionDomain;
import oracle.aurora.rdbms.url.jserver.Handler;
import oracle.aurora.rdbms.url.jserver.JserverURLConnection;
import oracle.aurora.util.SeekableBufferedInputStream;
import oracle.aurora.vm.CachedLocaleData;
import oracle.aurora.vm.CachedLocales;
import oracle.aurora.vm.ClassNotResolvedException;
import oracle.aurora.vm.EnvironmentSpecific;
import oracle.aurora.vm.HotLoader;
import oracle.aurora.vm.IUHandle;
import oracle.gss.util.NLSLocale;
import oracle.i18n.text.OraMapTable;
import oracle.jdbc.driver.OracleDriver;
import oracle.sql.CHAR;
import sun.misc.Resource;
import sun.security.provider.PolicyFile;

public class EnvironmentSpecificImpl
extends EnvironmentSpecific {
    private static final String[] bootstrapResourceClassPath = new String[]{"jserver:/resource/schema/SYS/"};
    private static final OraMapTable dummyOraMapTable = EnvironmentSpecificImplReadOnly.dummyOraMapTable;
    private static NLSLocale nlslocale = NLSLocale.getInstance();
    private static Locale defaultLocale = null;
    private static boolean settingDefaultLocale = false;

    private static void install() {
        EnvironmentSpecific.impl = new EnvironmentSpecificImpl();
    }

    private static native String getDefaultFileEncoding();

    protected String normalizeFileEncodingImpl(String unnormalized) {
        String enc = nlslocale.getJavaCharset(unnormalized);
        if (enc == null || enc == "") {
            enc = EnvironmentSpecificImpl.getDefaultFileEncoding();
        }
        return enc;
    }

    protected IUHandle lookupIUHandleImpl(String name, int type, Class forClass, Object extraInfo) {
        Handle rh;
        ClassHandle h;
        int ourType = 0;
        switch (type) {
            case 1: {
                ourType = 28;
                break;
            }
            case 2: {
                ourType = 29;
                break;
            }
            case 3: {
                ourType = 30;
                break;
            }
            default: {
                return null;
            }
        }
        if (forClass != null && (h = ClassHandle.lookup(forClass)) != null && (rh = Handle.lookup(name, h.schema(), ourType)) != null) {
            return rh;
        }
        return extraInfo == null ? Handle.lookup(name, ourType) : (extraInfo instanceof String ? Handle.lookup(name, Schema.lookup((String)extraInfo), ourType) : (extraInfo instanceof CHAR ? Handle.lookup(name, Schema.lookup((CHAR)extraInfo), ourType) : Handle.lookup(name, ourType)));
    }

    protected int lookupIUHandleForCompilerImpl(String fullName, boolean derivedp, boolean sourcep, IUHandle refFromHandle, IUHandle[] foundHandle) {
        return Handle.lookupHandleForCompiler(fullName, derivedp, sourcep, (Handle)refFromHandle, foundHandle);
    }

    protected SecurityManager securityManagerImpl() {
        return new SecurityManagerImpl();
    }

    protected Policy getPolicyTableImpl(Policy p) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && sm instanceof SecurityManagerImpl) {
            p = ((SecurityManagerImpl)sm).getPolicyTable();
        }
        return p;
    }

    protected void setStaticPermissionFlagImpl(Policy p) {
        ProtectionDomain.setStaticPermissionsFlag((p != null && p instanceof PolicyFile && ((PolicyFile)p).isBoot() || p instanceof PolicyTable ? 1 : 0) != 0);
    }

    private void setLocaleProperties(Locale locale) {
        Properties p = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperties();
            }
        });
        p.put("user.language", locale.getLanguage());
        p.put("user.region", locale.getCountry());
        defaultLocale = locale;
    }

    protected void checkCanDebugImpl() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && sm instanceof SecurityManagerImpl) {
            ((SecurityManagerImpl)sm).checkCanDebug();
        }
    }

    protected InputStream sourceInputStreamImpl(Class cl) throws IOException {
        ClassHandle classHandle;
        InputStream input = null;
        if (cl != null && (classHandle = ClassHandle.lookup(cl)) != null) {
            try {
                SourceHandle sourceHandle = classHandle.derivedFrom();
                if (sourceHandle != null) {
                    input = sourceHandle.inputStream();
                }
            }
            catch (ObjectTypeChangedException e) {
                // empty catch block
            }
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Locale getDefaultLocaleImpl() {
        if (defaultLocale == null) {
            if (nlslocale == null || settingDefaultLocale) {
                return Locale.US;
            }
            try {
                settingDefaultLocale = true;
                String[] LangAndTerr = new String[2];
                DbmsJava.getLangAndTerr(LangAndTerr);
                defaultLocale = nlslocale.getJavaLocale(LangAndTerr[0], LangAndTerr[1]);
                this.setLocaleProperties(defaultLocale);
            }
            finally {
                settingDefaultLocale = false;
            }
        }
        return defaultLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDefaultLocaleImpl(Locale locale) {
        Connection connection = null;
        Statement stmt = null;
        try {
            try {
                String terr;
                connection = new OracleDriver().defaultConnection();
                stmt = connection.createStatement();
                String lang = nlslocale.getNLSLanguage(locale);
                if (lang != null) {
                    lang = "ALTER SESSION SET NLS_LANGUAGE = '" + lang + "'";
                    stmt.execute(lang);
                }
                if ((terr = nlslocale.getNLSTerritory(locale)) != null) {
                    terr = "ALTER SESSION SET NLS_TERRITORY = '" + terr + "'";
                    stmt.execute(terr);
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException ex) {
            String msg = "Unexpected exception " + ex + "in EnvironmentSpecificImpl.setDefaultLocaleImpl(" + locale + ")";
            System.err.println(msg);
            ex.printStackTrace();
            InternalError err = new InternalError(msg);
            err.initCause(ex);
            throw err;
        }
        this.setLocaleProperties(locale);
    }

    protected String[] bootstrapResourceClassPathImpl() {
        return bootstrapResourceClassPath;
    }

    protected Class classFromURLResourceImpl(Resource res) throws ClassNotFoundException {
        Class c = null;
        URL resu = res.getURL();
        String protocol = resu.getProtocol();
        if (protocol.equals("jar")) {
            URL csu = res.getCodeSourceURL();
            if (csu.getProtocol().equals("jserver")) {
                try {
                    JserverURLConnection conn = (JserverURLConnection)csu.openConnection();
                    conn.connect();
                    if (conn.getKind() == 31 && conn.classPathURL() && !conn.loadPrivate()) {
                        String entryName = ((JarURLConnection)resu.openConnection()).getEntryName();
                        if (entryName.endsWith(".class")) {
                            entryName = entryName.substring(0, entryName.length() - 6);
                        }
                        c = Handle.lookupClass(entryName, conn.getSchema()).loadClass();
                    }
                }
                catch (Exception foo) {}
            }
        } else if (protocol.equals("jserver")) {
            try {
                JserverURLConnection conn = (JserverURLConnection)resu.openConnection();
                conn.connect();
                if (!conn.rjbc()) {
                    c = ((HandleInput)((SeekableBufferedInputStream)res.getInputStream()).getInternalStream()).getHandle().loadClass();
                }
            }
            catch (IOException ioe) {
                throw new ClassNotFoundException(res.getURL().toString(), ioe);
            }
            catch (ObjectTypeChangedException otce) {
                throw new ClassNotFoundException(res.getURL().toString(), otce);
            }
        }
        return c;
    }

    protected ClassLoader assignClassLoaderImpl(Class c) {
        return OracleClassLoader.assignClassLoader(c);
    }

    protected ClassLoader getSystemClassLoaderImpl(ClassLoader scl, ClassLoader pscl) {
        return OracleClassLoader.getSystemClassLoader(scl, pscl);
    }

    protected Class ownerProtectionDomainImpl() {
        return SchemaProtectionDomain.theClass;
    }

    protected Class fabricateProtectionDomainImpl() {
        return SchemaProtectionDomain.theClass;
    }

    protected String instructionsForImpl(ProtectionDomain pd, Permission perm) {
        String addendum = null;
        if (pd instanceof SchemaProtectionDomain) {
            SchemaProtectionDomain d = (SchemaProtectionDomain)pd;
            StringBuffer gMessage = new StringBuffer();
            gMessage.append("The PL/SQL to grant this is dbms_java.grant_permission( ");
            gMessage.append("'").append(d.getSchema()).append("', ");
            Class<?> pClass = perm.getClass();
            Schema pSchema = ClassHandle.lookup(perm.getClass()).schema();
            gMessage.append("'").append(pSchema).append(":");
            gMessage.append(pClass.getName()).append("', ");
            String target = perm.getName();
            if (target == null) {
                gMessage.append("null, ");
            } else {
                gMessage.append("'").append(target).append("', ");
            }
            String action = perm.getActions();
            if (action == null) {
                gMessage.append("null ");
            } else {
                gMessage.append("'").append(action).append("' ");
            }
            gMessage.append(")");
            addendum = gMessage.toString();
        }
        return addendum;
    }

    protected Class classForNameAndSchemaImpl(String className, String schemaName) throws ClassNotFoundException {
        return DbmsJava.classForNameAndSchema(className, schemaName);
    }

    protected Class classForNameAndSchemaImpl(String className, int schemaIndicator) throws ClassNotFoundException {
        return DbmsJava.classForNameAndSchema(className, Schema.lookup(schemaIndicator));
    }

    protected Class classForNameAndSchemaImpl(String className, int schemaIndicator, int alternateSchemaIndicator) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = this.classForNameAndSchemaImpl(className, schemaIndicator);
        }
        catch (ExecutePermissionException e) {
            throw (ExecutePermissionException)e.fillInStackTrace();
        }
        catch (ClassNotResolvedException e) {
            throw (ClassNotResolvedException)e.fillInStackTrace();
        }
        catch (ClassNotFoundException e) {
            cl = this.classForNameAndSchemaImpl(className, alternateSchemaIndicator);
        }
        return cl;
    }

    protected int ownerIDImpl(Class cl) {
        return DbmsJava.ownerID(cl);
    }

    protected Hashtable CLDKeyGetRootImpl(String name, int ownerID) {
        Hashtable hash = null;
        Schema schema = Schema.lookup(ownerID);
        SharedDataHandle sdh = Handle.lookupSharedData(name, schema);
        if (sdh != null) {
            try {
                hash = (Hashtable)sdh.access();
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return hash;
    }

    protected boolean CLDKeySaveImpl(String name, int ownerID, Hashtable hash) {
        boolean success = false;
        Schema schema = Schema.lookup(ownerID);
        try {
            SharedDataHandle.create(name, schema, hash, HotLoader.isIniting(), true);
            success = true;
        }
        catch (Exception e) {
            String msg = "Unexpected exception " + e + "in EnvironmentSpecificImpl.CLDKeySaveImpl(" + name + ", " + ownerID + ", " + hash + ")";
            System.err.println(msg);
            e.printStackTrace();
            InternalError err = new InternalError(msg);
            err.initCause(e);
            throw err;
        }
        return success;
    }

    protected boolean CLDKeyRemoveImpl(String name, int ownerID) {
        boolean success = false;
        Schema schema = Schema.lookup(ownerID);
        SharedDataHandle sdh = Handle.lookupSharedData(name, schema);
        if (sdh != null) {
            try {
                sdh.drop();
                success = true;
            }
            catch (Exception e) {
                String msg = "Unexpected exception " + e + "in EnvironmentSpecificImpl.CLDKeyRemoveImpl(" + name + ", " + ownerID + ")";
                System.err.println(msg);
                e.printStackTrace();
                InternalError err = new InternalError(msg);
                err.initCause(e);
                throw err;
            }
        }
        return success;
    }

    protected IUHandle getMethodToJitImpl(int methodNumber, int[] methodIndices, Member[] methodObjects) {
        return Handle.getMethodToJit(methodNumber, methodIndices, methodObjects);
    }

    protected void populateURLHandlersImpl(Hashtable handlers) {
        handlers.put("jserver", new Handler());
        handlers.put("file", new sun.net.www.protocol.file.Handler());
    }

    protected void initForHotLoadingImpl() {
        PolicyTable.initForHotLoading();
    }

    protected void initializeOracleDriverImpl() {
        OracleDriver.getCompileTime();
    }

    protected String rjbcNormalizeImpl(String p) {
        return DbmsJava.rjbcNormalize(p);
    }

    protected boolean initSecurityFromResourceImpl() {
        return true;
    }

    public CachedLocales cachedLocalesData() {
        return new CachedLocaleData();
    }

    public CachedLocales cachedLocalesData(String name) {
        return new CachedLocaleData(name);
    }

    public CachedLocales cachedLocalesData(String prefix, String name) {
        return new CachedLocaleData(prefix, name);
    }

    protected URL getPerhapsTransformedURLImpl(Resource res, boolean mustBeBootstrap) {
        URL resurl = null;
        if (res != null) {
            resurl = EnvironmentSpecificImpl.perhapsTransformURL(res.getURL(), mustBeBootstrap);
        }
        return resurl;
    }

    static URL perhapsTransformURL(URL url, boolean mustBeBootstrap) {
        if (url != null) {
            try {
                JserverURLConnection js = (JserverURLConnection)url.openConnection();
                if (mustBeBootstrap && !js.isBootstrap()) {
                    return null;
                }
                String jarname = js.jarName();
                if (jarname != null) {
                    String name = js.getName();
                    String schema = js.getSchema().toString();
                    url = new URL("jar:jserver:/jar/schema/" + schema + "/" + jarname + "!/" + name);
                }
            }
            catch (MalformedURLException mue) {
                String msg = "Malformed URL from perhapsTransformURL(" + url + ")";
                System.err.println(msg);
                mue.printStackTrace();
                InternalError err = new InternalError(msg);
                err.initCause(mue);
                throw err;
            }
            catch (IOException ioe) {
                String msg = "Unexpected IOException " + ioe + " from perhapsTransformURL(" + url + ")";
                System.err.println(msg);
                ioe.printStackTrace();
                InternalError err = new InternalError(msg);
                err.initCause(ioe);
                throw err;
            }
        }
        return url;
    }
}

