/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging.handler;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.SimpleFormatter;
import oracle.adf.share.logging.handler.LoggingConfigObj;
import oracle.core.ojdl.logging.HandlerFactoryException;

public class InternalADFHandler
extends FileHandler {
    private static final String LOG_FILE_SUFFIX = ".log";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public String mPath;
    public String mPattern;
    public int mLimit;
    public int mCount;
    public boolean mAppend;
    public int mBufSize;

    private InternalADFHandler(String path, String pattern, int limit, int count, boolean append, int bufSize) throws IOException, SecurityException {
        super(pattern, limit, count, append);
        this.mPath = path;
        this.mPattern = pattern;
        this.mLimit = limit;
        this.mCount = count;
        this.mAppend = append;
        this.mBufSize = bufSize;
    }

    static Handler create(Properties properties, String logFilePrefix) throws HandlerFactoryException {
        LoggingConfigObj configObj = new LoggingConfigObj();
        configObj.getLoggingConfigParameters(properties);
        InternalADFHandler handler = null;
        try {
            StringBuffer logFile;
            InternalADFHandler.createLogDir(configObj.mPath);
            int count = 0;
            while (true) {
                logFile = new StringBuffer();
                logFile.append(configObj.mPath).append(FILE_SEPARATOR).append(logFilePrefix).append(count).append(LOG_FILE_SUFFIX);
                File f = new File(logFile.toString());
                if (!f.exists()) break;
                f.delete();
                ++count;
            }
            logFile = new StringBuffer();
            logFile.append(configObj.mPath).append(FILE_SEPARATOR).append(logFilePrefix).append("%g").append(LOG_FILE_SUFFIX);
            count = (int)(configObj.mMaxLogSize / configObj.mMaxFileSize);
            handler = new InternalADFHandler(configObj.mPath, logFile.toString(), (int)configObj.mMaxFileSize, count, false, configObj.mBufSize);
            handler.setFormatter(new SimpleFormatter());
        }
        catch (Exception e) {
            throw new HandlerFactoryException("Failed to create ADF Handler", (Throwable)e);
        }
        return handler;
    }

    private static void createLogDir(String name) throws Exception {
        File bsDir = new File(name);
        try {
            if (bsDir.exists()) {
                if (!bsDir.isDirectory()) {
                    throw new Exception(name + " is not a directory");
                }
            } else if (!bsDir.mkdirs()) {
                throw new Exception("cannot create directory " + name);
            }
            if (!bsDir.canWrite()) {
                throw new Exception("cannot write to directory " + name);
            }
        }
        catch (SecurityException e) {
            throw new Exception("access to log directory " + name + " is denied");
        }
    }
}

