/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideri.navigator;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.ide.Context;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory3;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DockingParam;
import oracle.ide.layout.ViewId;
import oracle.ide.navigator.HostedView;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.Assert;
import oracle.ideimpl.docking.HostedDockableHook;
import oracle.ideri.navigator.DefaultNavigatorWindow;

public class NavigatorDockableFactory
implements DockableFactory3 {
    private final NavigatorManager _navMgr;
    private final boolean _useDrawer;
    private AtomicBoolean _listenerAttached = new AtomicBoolean(false);

    public NavigatorDockableFactory(NavigatorManager navMgr) {
        this(navMgr, false);
    }

    public NavigatorDockableFactory(NavigatorManager navMgr, boolean useDrawer) {
        if (navMgr == null) {
            throw new IllegalArgumentException();
        }
        this._navMgr = navMgr;
        this._useDrawer = useDrawer;
    }

    private void createDrawers(DefaultNavigatorWindow nav) {
        List hostedViews = this._navMgr.getHostedViews();
        nav.aboutToAddHostedWindows();
        for (int i = 0; i < hostedViews.size(); ++i) {
            HostedView view = (HostedView)hostedViews.get(i);
            this.createDrawer(nav, view);
        }
        nav.finishedAddingHostedWindows();
    }

    private void createDrawer(DefaultNavigatorWindow nav, HostedView view) {
        ViewId viewId = view.viewId();
        Dockable hostedDockable = DockStation.getDockStation().findDockable(viewId);
        if (hostedDockable instanceof DockableWindow) {
            DockableWindow toHost = (DockableWindow)hostedDockable;
            nav.addHostedWindow(toHost, view.weight());
        }
    }

    public void install() {
        NavigatorWindow dockable = this._navMgr.getNavigatorWindow();
        if (dockable == null) {
            return;
        }
        if (dockable.isUsingDrawer() && dockable instanceof DefaultNavigatorWindow) {
            DefaultNavigatorWindow nav = (DefaultNavigatorWindow)dockable;
            DockStation.getDockStation().dock((Dockable)nav, this.createDockingParam());
            this.createDrawers(nav);
            this._ensureHookListenerAttached();
        } else {
            DockingParam dockingParam = this.createDockingParam();
            DockStation.getDockStation().dock((Dockable)dockable, dockingParam);
        }
    }

    public boolean canReinstall() {
        return true;
    }

    public void notifyAfterStartupLayoutRestored() {
        this._ensureHookListenerAttached();
    }

    public Dockable getDockable(ViewId viewId) {
        return this.createView(viewId);
    }

    protected DockingParam createDockingParam() {
        return new DockingParam();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dockable createView(ViewId viewId) {
        NavigatorWindow navigator = null;
        if (this._navMgr.isSystemNavigator(viewId)) {
            navigator = this._navMgr.getNavigatorWindow();
        } else {
            String idStr = viewId.getId();
            Context context = DefaultNavigatorWindow.loadContext(idStr);
            try {
                navigator = this._navMgr.getNewView(context, viewId);
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
            finally {
                DefaultNavigatorWindow.clearContext(idStr);
            }
        }
        return navigator;
    }

    private void _ensureHookListenerAttached() {
        boolean previouslyAttached = this._listenerAttached.getAndSet(true);
        if (!previouslyAttached) {
            ProxyAwareHostedDockableListener hookListener = new ProxyAwareHostedDockableListener();
            HostedDockableHook.get().addHostedDockableRegistrationListener((HostedDockableHook.HostedDockableRegistrationListener)hookListener);
        }
    }

    private class ProxyAwareHostedDockableListener
    implements HostedDockableHook.HostedDockableRegistrationListener {
        private ProxyAwareHostedDockableListener() {
        }

        public void hostedDockableRegistered(ViewId hostId, HostedView hostedView) {
            NavigatorWindow dockable = NavigatorDockableFactory.this._navMgr.getNavigatorWindow();
            if (dockable == null) {
                return;
            }
            if (!dockable.getId().equals(hostId.getId())) {
                return;
            }
            if (dockable.isUsingDrawer() && dockable instanceof DefaultNavigatorWindow) {
                DefaultNavigatorWindow nav = (DefaultNavigatorWindow)dockable;
                boolean hasExistingDockableWithId = false;
                String hostedViewId = hostedView.viewId().getId();
                List existingDockables = nav.getHostedDockables();
                for (DockableWindow window : existingDockables) {
                    String windowId = window.getId();
                    if (!windowId.contains(hostedViewId)) continue;
                    hasExistingDockableWithId = true;
                    break;
                }
                if (!hasExistingDockableWithId) {
                    nav.aboutToAddHostedWindows();
                    NavigatorDockableFactory.this.createDrawer(nav, hostedView);
                    nav.finishedAddingHostedWindows();
                }
            }
        }
    }
}

