/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.util;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.ide.util.Version;

public class BundleUtil {
    private static final String BUNDLEENTRY_SCHEMA = "bundleentry";
    private static final String BUNDLEENTRY_SCHEMA_PREFIX = "bundleentry://";
    private static final int BUNDLEENTRY_SCHEMA_PREFIX_LENGTH = "bundleentry://".length();
    private static final String FWK_SUFFIX = ".fwk";

    private BundleUtil() {
    }

    public static String getBundleEntry(URL bundleURL) {
        if (BundleUtil.isBundleURL(bundleURL)) {
            return bundleURL.getPath();
        }
        return null;
    }

    public static boolean isBundleURL(URL jarURL) {
        return jarURL != null && jarURL.getProtocol().equals(BUNDLEENTRY_SCHEMA);
    }

    public static int extractBundleIdFromJarURL(URL url) {
        String path = url.getPath();
        int result = -1;
        int indexOfBundleEntrySchema = path.indexOf(BUNDLEENTRY_SCHEMA_PREFIX);
        int indexOfFwkSuffix = path.indexOf(FWK_SUFFIX);
        if (indexOfBundleEntrySchema == -1) {
            return result;
        }
        String bundleRuntimeIdString = path.substring(indexOfBundleEntrySchema + BUNDLEENTRY_SCHEMA_PREFIX_LENGTH, indexOfFwkSuffix);
        try {
            result = Integer.parseInt(bundleRuntimeIdString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    public static int extractBundleIdFromURI(URI uri) {
        int bundleId = -1;
        String host = uri.getHost();
        int fwkIndex = host.indexOf(FWK_SUFFIX);
        if (fwkIndex != -1) {
            try {
                bundleId = Integer.parseInt(host.substring(0, fwkIndex));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return bundleId;
    }

    public static org.osgi.framework.Version toOsgiVersion(Version extVersion) {
        int[] versionAsIntArray;
        if (extVersion != null && (versionAsIntArray = extVersion.toIntArray()).length > 0) {
            int major = versionAsIntArray[0];
            int minor = versionAsIntArray.length > 1 ? versionAsIntArray[1] : 0;
            int micro = versionAsIntArray.length > 2 ? versionAsIntArray[2] : 0;
            StringBuilder qualifierBuilder = new StringBuilder();
            for (int i = 3; i < versionAsIntArray.length; ++i) {
                qualifierBuilder.append(versionAsIntArray[i]);
                if (i >= versionAsIntArray.length - 1) continue;
                qualifierBuilder.append("-");
            }
            return new org.osgi.framework.Version(major, minor, micro, qualifierBuilder.toString());
        }
        return null;
    }

    public static List<String> parseOSGiValues(String text) {
        StringBuffer buffer = new StringBuffer();
        boolean ignoreNextComma = false;
        ArrayList<String> values = new ArrayList<String>();
        block4: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case ',': {
                    if (!ignoreNextComma) {
                        values.add(buffer.toString().trim());
                        buffer = new StringBuffer();
                        continue block4;
                    }
                    buffer.append(c);
                    continue block4;
                }
                case '\"': {
                    ignoreNextComma = !ignoreNextComma;
                    buffer.append(c);
                    continue block4;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        values.add(buffer.toString().trim());
        return values;
    }
}

