/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.net;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import oracle.ide.net.JarURLFileSystemHelper;
import oracle.ide.osgi.Platform;
import oracle.ide.osgi.util.BundleUtil;
import org.eclipse.core.runtime.FileLocator;
import org.osgi.framework.Bundle;

public class OSGiJarURLFileSystemHelper
extends JarURLFileSystemHelper {
    private static final String JAR_SEPARATOR = "!/";
    private static final String BUNDLEENTRY_PREFIX = "/bundleentry:";

    public boolean exists(URL url) {
        String path = url.getPath();
        int bundleId = BundleUtil.extractBundleIdFromJarURL(url);
        if (bundleId == -1) {
            return super.exists(url);
        }
        Bundle bundle = Platform.getBundleRegistry().getBundle(bundleId);
        return bundle.getEntry(OSGiJarURLFileSystemHelper.toRelative(path)) != null;
    }

    private static String toRelative(String path) {
        int indexOfJarSeparator = path.indexOf(JAR_SEPARATOR);
        if (indexOfJarSeparator != -1) {
            return path.substring(indexOfJarSeparator + JAR_SEPARATOR.length());
        }
        return null;
    }

    public InputStream openInputStream(URL url) throws IOException {
        URL unOSGifiedURL = FileLocator.find((URL)url);
        return super.openInputStream(unOSGifiedURL != null ? unOSGifiedURL : url);
    }

    public String getPlatformPathName(URL url) {
        URL mappedURL = url;
        String urlAsString = url.toString();
        int bundleId = BundleUtil.extractBundleIdFromJarURL(url);
        int indexOfJarSeparator = urlAsString.indexOf(JAR_SEPARATOR);
        int indexOfBundleEntry = urlAsString.indexOf(BUNDLEENTRY_PREFIX);
        if (bundleId != -1 && indexOfJarSeparator > indexOfBundleEntry && indexOfBundleEntry > -1) {
            Bundle bundle = Platform.getBundleRegistry().getBundle(bundleId);
            try {
                File bundleFile = FileLocator.getBundleFile((Bundle)bundle);
                String bundleFilePath = bundleFile.getPath();
                StringBuffer buffer = new StringBuffer(urlAsString);
                buffer.replace(indexOfBundleEntry, indexOfJarSeparator, "file:" + bundleFilePath);
                mappedURL = new URL(buffer.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return super.getPlatformPathName(mappedURL);
    }
}

