/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.manip;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.osgi.boot.api.BundlesInfoUtil;
import oracle.javatools.util.NullArgumentException;

public class SimpleBundleEntry {
    private String m_version = null;
    private String m_bundleSymbolicName = null;
    private URL m_location = null;
    private short m_startLevel = (short)4;
    private boolean m_startByDefault = false;
    private Map<String, String> m_manifestMap;

    public static SimpleBundleEntry create(String bundleInfoDatum, String installationDirectoryPath) {
        if (bundleInfoDatum == null || installationDirectoryPath == null) {
            throw new NullArgumentException("SimpleBundleEntry.create(String,String) does not permit null arguments");
        }
        BundlesInfoUtil.BundleData bd = BundlesInfoUtil.BundleData.create((String)bundleInfoDatum);
        return new SimpleBundleEntry(bd, installationDirectoryPath);
    }

    public static SimpleBundleEntry create() {
        return new SimpleBundleEntry();
    }

    private SimpleBundleEntry() {
    }

    private SimpleBundleEntry(BundlesInfoUtil.BundleData bdata, String installationDirectoryPath) {
        this.setBundleSymbolicName(bdata.getSymbolicName());
        this.setVersion(bdata.getVersion());
        this.setLocation(URLFactory.newURL((String)"file", (String)(installationDirectoryPath + bdata.getRelativePath())));
        this.setStartByDefault(bdata.isEnabled());
        this.setStartLevel((short)bdata.getRunLevel());
    }

    public final void setVersion(String version) {
        this.m_version = version;
    }

    public final String getVersion() {
        return this.m_version;
    }

    public final void setBundleSymbolicName(String bundleSymbolicName) {
        this.m_bundleSymbolicName = bundleSymbolicName;
    }

    public final String getBundleSymbolicName() {
        return this.m_bundleSymbolicName;
    }

    public final void setLocation(URL location) {
        this.m_location = location;
    }

    public final URL getLocation() {
        return this.m_location;
    }

    public final void setStartLevel(short startLevel) {
        this.m_startLevel = startLevel;
    }

    public final short getStartLevel() {
        return this.m_startLevel;
    }

    public final void setStartByDefault(boolean startByDefault) {
        this.m_startByDefault = startByDefault;
    }

    public final boolean isStartByDefault() {
        return this.m_startByDefault;
    }

    public String toBundleInfoFormat(URL baseURL) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBundleSymbolicName());
        sb.append(",");
        sb.append(this.getVersion());
        sb.append(",");
        String bundleInfoPath = URLFileSystem.getPlatformPathName((URL)baseURL);
        String newBundlePath = URLFileSystem.getPlatformPathName((URL)this.getLocation());
        sb.append(this.getRelativePath(newBundlePath, bundleInfoPath));
        sb.append(",");
        sb.append(this.getStartLevel());
        sb.append(",");
        sb.append(this.isStartByDefault());
        return sb.toString();
    }

    public String getRelativePath(String bundleFilePathIn, String bundlesInfoFilePathIn) {
        StringBuilder buf = new StringBuilder();
        String bundleFilePath = bundleFilePathIn.replace('\\', '/');
        String bundlesInfoFilePath = bundlesInfoFilePathIn.replace('\\', '/');
        String[] bundleFilePathPieces = bundleFilePath.split("/");
        String[] bundlesInfoFilePathPieces = bundlesInfoFilePath.split("/");
        int bundleFileIndex = 0;
        int bundleFileLength = bundleFilePathPieces.length;
        int bundlesInfoFileLength = bundlesInfoFilePathPieces.length;
        for (int bundlesInfoFileIndex = 0; bundleFileIndex < bundleFileLength && bundlesInfoFileIndex < bundlesInfoFileLength; ++bundleFileIndex, ++bundlesInfoFileIndex) {
            if (bundleFilePathPieces[bundleFileIndex].equals(bundlesInfoFilePathPieces[bundlesInfoFileIndex])) continue;
            while (bundlesInfoFileIndex++ < bundlesInfoFileLength) {
                buf.append("../");
            }
            while (bundleFileIndex < bundleFileLength - 1) {
                buf.append(bundleFilePathPieces[bundleFileIndex++]);
                buf.append('/');
            }
            buf.append(bundleFilePathPieces[bundleFileLength - 1]);
            return buf.toString();
        }
        return null;
    }

    public static boolean isValid(SimpleBundleEntry entry) {
        return entry.getBundleSymbolicName() != null && entry.getLocation() != null && entry.getVersion() != null;
    }

    public String toString() {
        return "Symbolic Name = " + this.getBundleSymbolicName() + "\n" + "Name = " + "\n" + "Location = " + this.getLocation() + "\n" + "Version = " + this.getVersion() + "\n" + "Started = " + this.isStartByDefault() + "\n" + "Start Level = " + this.getStartLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getManifestValue(String manifestKey) {
        if (this.m_manifestMap == null) {
            SimpleBundleEntry simpleBundleEntry = this;
            synchronized (simpleBundleEntry) {
                this.m_manifestMap = Collections.synchronizedMap(new HashMap());
                String fileName = this.getLocation().getPath();
                File file = new File(fileName);
                if (fileName.endsWith(".jar")) {
                    ZipFile zipFile = null;
                    try {
                        try {
                            String[] manifestKeysToIterateOver;
                            zipFile = new ZipFile(file);
                            ZipEntry entry = zipFile.getEntry("META-INF/MANIFEST.MF");
                            Manifest manifestFile = new Manifest(zipFile.getInputStream(entry));
                            Attributes mainAttrs = manifestFile.getMainAttributes();
                            for (String key : manifestKeysToIterateOver = new String[]{"Bundle-ActivationPolicy", "Bundle-Activator", "Bundle-Category", "Bundle-ClassPath", "Bundle-ContactAddress", "Bundle-Copyright", "Bundle-Description", "Bundle-ManifestVersion", "Bundle-Name", "Bundle-RequiredExecutionEnvironment", "Bundle-SymbolicName", "Bundle-Version", "Bundle-Vendor", "Import-Package", "Export-Package", "Require-Bundle"}) {
                                Attributes.Name attrName = new Attributes.Name(key);
                                if (!mainAttrs.containsKey(attrName)) continue;
                                this.m_manifestMap.put(key, mainAttrs.getValue(attrName));
                            }
                        }
                        finally {
                            if (zipFile != null) {
                                zipFile.close();
                            }
                        }
                    }
                    catch (Exception ex) {
                        Logger.getLogger("oracle.ide.osgi").log(Level.FINE, fileName + " not found", ex);
                    }
                }
            }
        }
        return this.m_manifestMap.get(manifestKey);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SimpleBundleEntry)) {
            return false;
        }
        SimpleBundleEntry other = (SimpleBundleEntry)object;
        if (!(this.m_version != null ? this.m_version.equals(other.m_version) : other.m_version == null)) {
            return false;
        }
        return this.m_bundleSymbolicName != null ? this.m_bundleSymbolicName.equals(other.m_bundleSymbolicName) : other.m_bundleSymbolicName == null;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 1;
        result = 37 * result + (this.m_version == null ? 0 : this.m_version.hashCode());
        result = 37 * result + (this.m_bundleSymbolicName == null ? 0 : this.m_bundleSymbolicName.hashCode());
        return result;
    }
}

