/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.beans;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.beans.AbstractPropertyEditorFactory;
import oracle.bali.inspector.beans.BeansPropertyID;
import oracle.bali.inspector.beans.IndexedPropertyEditor;

class BeansPropertyEditorFactory
extends AbstractPropertyEditorFactory {
    private PropertyDescriptor _propertyDescriptor;

    public BeansPropertyEditorFactory(Object target, PropertyDescriptor propertyDescriptor) {
        super(target);
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException();
        }
        this._propertyDescriptor = propertyDescriptor;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this._propertyDescriptor;
    }

    public String getDisplayName() {
        return this.getPropertyDescriptor().getDisplayName();
    }

    public String getName() {
        return this.getPropertyDescriptor().getName();
    }

    public String getShortDescription() {
        return this.getPropertyDescriptor().getShortDescription();
    }

    public boolean isExpert() {
        return this.getPropertyDescriptor().isExpert();
    }

    public boolean isHidden() {
        return this.getPropertyDescriptor().isHidden();
    }

    public boolean setValue(Object newValue) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, Exception {
        boolean changed = this.getCachedValue() != newValue;
        try {
            Method writeMethod = this.getPropertyDescriptor().getWriteMethod();
            if (writeMethod != null) {
                writeMethod.invoke(this.getTarget(), newValue);
            }
        }
        catch (Exception e1) {
            if (newValue instanceof String) {
                this.__getPropertyEditor().setAsText((String)newValue);
                newValue = this.__getPropertyEditor().getValue();
                Method writeMethod = this.getPropertyDescriptor().getWriteMethod();
                if (writeMethod != null) {
                    writeMethod.invoke(this.getTarget(), newValue);
                }
            }
            this.__getPropertyEditor().setValue(newValue);
        }
        this.setCachedValue(newValue);
        this.setCachedDisplayValue(INVALID_PROPERTY);
        return changed;
    }

    public Object getValue(Object target) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object cachedValue = this.getCachedValue();
        if (cachedValue == INVALID_PROPERTY) {
            Method readMethod = this.getPropertyDescriptor().getReadMethod();
            cachedValue = readMethod != null ? readMethod.invoke(target, (Object[])null) : PropertyModel.DOES_NOT_EXIST;
            this.setCachedValue(cachedValue);
        }
        return cachedValue;
    }

    public boolean isReadable() {
        return this.getPropertyDescriptor().getReadMethod() != null || this.getPropertyDescriptor() instanceof IndexedPropertyDescriptor;
    }

    public boolean isWritable() {
        return this.getPropertyDescriptor().getWriteMethod() != null && !this.getType().isArray();
    }

    public Class getType() {
        return this.getPropertyDescriptor().getPropertyType();
    }

    protected Object createPropertyID() {
        PropertyDescriptor descriptor = this.getPropertyDescriptor();
        return new BeansPropertyID(descriptor.getName(), descriptor.getPropertyType(), descriptor instanceof IndexedPropertyDescriptor);
    }

    protected PropertyEditor createPropertyEditor() {
        IndexedPropertyDescriptor ipd;
        Class<?> type;
        PropertyEditor indexEditor;
        PropertyEditor editor = null;
        PropertyDescriptor descriptor = this.getPropertyDescriptor();
        Class<?> editorClass = descriptor.getPropertyEditorClass();
        if (editorClass != null) {
            try {
                editor = (PropertyEditor)editorClass.newInstance();
            }
            catch (Exception e) {
                editor = null;
            }
        }
        if (editor == null && descriptor instanceof IndexedPropertyDescriptor && (indexEditor = PropertyEditorManager.findEditor(type = (ipd = (IndexedPropertyDescriptor)descriptor).getIndexedPropertyType())) != null) {
            editor = IndexedPropertyEditor.getPropertyEditor();
        }
        if (editor != null) {
            editor.addPropertyChangeListener(this.getPropertyChangeListener());
        } else {
            editor = super.createPropertyEditor();
        }
        return editor;
    }
}

