/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.bali.inspector.DisplayNameRenderer;
import oracle.bali.inspector.NullEditor;
import oracle.bali.inspector.PropertyFilterer;
import oracle.bali.inspector.PropertyInspector;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.swing.AbstractTableCellEditor;

class GroupCellHandler
extends AbstractTableCellEditor
implements TableCellRenderer {
    private static final int _DEFAULT_INDENT_WIDTH = 7;
    private static final int _BUTTON_MARGIN = 2;
    private TableCellEditor _defaultEditor;
    private TableCellRenderer _defaultRenderer;
    private Icon _expandedIcon;
    private Icon _collapsedIcon;
    private Content _component;
    private JPanel _content;
    private JLabel _iconPanel;
    private IndentLayout _layout;
    private JPanel _editorComponent;
    private JPanel _editorContent;
    private Label _editorIcon;
    private JLabel _editorLabel;
    private IndentLayout _editorLayout;
    private int _levelColumnIndex = -1;
    private int _drillableColumnIndex = -1;
    private Border _noFocusBorder;
    private PropertyInspector _inspector;
    private boolean _foundDrillable;
    private Icon _spacer;

    public GroupCellHandler(PropertyInspector inspector) {
        this(inspector, null, null);
    }

    public GroupCellHandler(PropertyInspector inspector, TableCellRenderer renderer, TableCellEditor editor) {
        this._inspector = inspector;
        if (editor == null) {
            editor = NullEditor.getTableCellEditor();
        }
        if (renderer == null) {
            renderer = DisplayNameRenderer.getTableCellRenderer();
        }
        this._defaultRenderer = renderer;
        this._defaultEditor = editor;
        this._expandedIcon = UIManager.getIcon("Tree.expandedIcon");
        this._collapsedIcon = UIManager.getIcon("Tree.collapsedIcon");
        this._spacer = new Spacer();
        this._component = new Content();
        this._component.setBorder(null);
        this._component.setOpaque(true);
        this._layout = new IndentLayout();
        this._component.setLayout(this._layout);
        this._content = new ToolTipPanel();
        this._content.setBorder(null);
        this._content.setOpaque(false);
        this._content.setLayout(new BorderLayout(2, 0));
        this._iconPanel = new JLabel();
        this._iconPanel.setBorder(null);
        this._iconPanel.setOpaque(false);
        this._content.add("West", this._iconPanel);
        this._component.add(this._content);
        this._editorComponent = new JPanel();
        this._editorComponent.setOpaque(true);
        this._editorLayout = new IndentLayout();
        this._editorComponent.setLayout(this._editorLayout);
        this._editorContent = new JPanel();
        this._editorContent.setOpaque(false);
        this._editorContent.setLayout(new BorderLayout(2, 0));
        this._editorIcon = new Label();
        this._editorLabel = new JLabel();
        this._editorIcon.setOpaque(false);
        this._editorLabel.setOpaque(false);
        this._editorLabel.setBorder(new EmptyBorder(1, 2, 1, 2));
        this._editorContent.add("West", this._editorIcon);
        JPanel editorContainer = new JPanel();
        editorContainer.setLayout(new BorderLayout(2, 0));
        editorContainer.add("West", this._editorContent);
        editorContainer.add("Center", this._editorLabel);
        this._editorComponent.add(editorContainer);
        this._updateNoFocusBorder();
    }

    public TableCellRenderer getDefaultRenderer() {
        return this._defaultRenderer;
    }

    public TableCellEditor getDefaultEditor() {
        return this._defaultEditor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndicies(int levelColumn, int drillableColumn) {
        this._levelColumnIndex = levelColumn;
        this._drillableColumnIndex = drillableColumn;
        this._foundDrillable = false;
        PropertyModel model = this._inspector.getPropertyModel();
        model.startRead();
        try {
            int count = model.getRowCount();
            for (int i = 0; i < count; ++i) {
                if (!this._isCellDrillable(model, i)) continue;
                this._foundDrillable = true;
                break;
            }
        }
        finally {
            model.stopRead();
        }
    }

    public void updateUI() {
        this._expandedIcon = UIManager.getIcon("Tree.expandedIcon");
        this._collapsedIcon = UIManager.getIcon("Tree.collapsedIcon");
        this._updateNoFocusBorder();
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        PropertyModel model = (PropertyModel)table.getModel();
        int indentDepth = this.getCellDepth(model, row);
        boolean hasChildren = this.__cellHasChildren(model, row);
        Component c = this.getDefaultRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this._layout.setIndent(this._getButtonX(indentDepth));
        this._content.add("Center", c);
        if (hasChildren) {
            if (this.__isCellExpanded(model, row)) {
                this._iconPanel.setIcon(this._expandedIcon);
            } else {
                this._iconPanel.setIcon(this._collapsedIcon);
            }
        } else {
            this._iconPanel.setIcon(this._spacer);
        }
        if (hasFocus) {
            Border b = UIManager.getBorder("Table.focusCellHighlightBorder");
            this._component.setBorder(b);
        } else {
            this._component.setBorder(this._noFocusBorder);
        }
        this._component.setAccessibleName(model.getPropertyDisplayName(row));
        return this._component;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        PropertyModel model = (PropertyModel)table.getModel();
        int indentDepth = this.getCellDepth(model, row);
        boolean hasChildren = this.__cellHasChildren(model, row);
        Component c = this.getDefaultEditor().getTableCellEditorComponent(table, value, isSelected, row, column);
        if (hasChildren) {
            if (this.__isCellExpanded(model, row)) {
                this._editorIcon.setIcon(this._expandedIcon);
            } else {
                this._editorIcon.setIcon(this._collapsedIcon);
            }
        } else {
            this._editorIcon.setIcon(this._spacer);
        }
        String text = model.getPropertyDisplayName(row);
        this._editorLabel.setText(text);
        this._editorIcon.setCell(row, model);
        this._editorLayout.setIndent(this._getButtonX(indentDepth));
        if (c != null) {
            this._editorContent.add("Center", c);
        }
        return this._editorComponent;
    }

    public Object getCellEditorValue() {
        return this._editorLabel.getText();
    }

    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            MouseEvent e = (MouseEvent)anEvent;
            if (e.isConsumed()) {
                return false;
            }
            JTable table = (JTable)e.getSource();
            if (!table.isEnabled()) {
                return false;
            }
            PropertyModel model = (PropertyModel)table.getModel();
            Point p = new Point(e.getX(), e.getY());
            int row = table.rowAtPoint(p);
            int indentDepth = this.getCellDepth(model, row);
            int buttonX = this._getButtonX(indentDepth);
            int buttonWidth = buttonX + this._getButtonWidth();
            int x = e.getX();
            if (this.__cellHasChildren(model, row)) {
                if (x >= buttonX && x <= buttonWidth) {
                    boolean expanded = !this.__isCellExpanded(model, row);
                    this.__setCellExpanded(model, row, expanded);
                    return false;
                }
                x -= buttonWidth;
            } else {
                x -= buttonX + this._spacer.getIconWidth();
            }
            MouseEvent mouseEvent = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), x, e.getY(), e.getClickCount(), e.isPopupTrigger());
            return this.getDefaultEditor().isCellEditable(mouseEvent);
        }
        if (anEvent instanceof KeyEvent) {
            return false;
        }
        return false;
    }

    boolean __cellHasChildren(PropertyModel model, int rowIndex) {
        return this._getCellDepth(model, rowIndex) == 0 || this._isCellDrillable(model, rowIndex);
    }

    private int getCellDepth(PropertyModel model, int rowIndex) {
        int cellDepth = this._getCellDepth(model, rowIndex);
        if (cellDepth >= 0) {
            return cellDepth;
        }
        return 0;
    }

    boolean __isCellExpanded(PropertyModel model, int rowIndex) {
        return ((PropertyFilterer)model).getExpansionState(rowIndex);
    }

    void __setCellExpanded(PropertyModel model, int row, boolean expanded) {
        ((PropertyFilterer)model).setExpansionState(row, expanded);
    }

    private int _getCellDepth(PropertyModel model, int rowIndex) {
        if (this._levelColumnIndex == -1) {
            return -1;
        }
        Object levelObject = model.getValueAt(rowIndex, this._levelColumnIndex);
        if (levelObject != null && levelObject != PropertyModel.DOES_NOT_EXIST) {
            return (Integer)levelObject;
        }
        return -1;
    }

    private boolean _isCellDrillable(PropertyModel model, int rowIndex) {
        if (this._drillableColumnIndex == -1) {
            return false;
        }
        Object drillable = model.getValueAt(rowIndex, this._drillableColumnIndex);
        if (drillable == PropertyModel.DOES_NOT_EXIST || drillable == null) {
            return false;
        }
        return Boolean.TRUE.equals(drillable);
    }

    private int _getButtonWidth() {
        return this._expandedIcon.getIconWidth();
    }

    private int _getButtonX(int depth) {
        return depth * 7 + 2;
    }

    private void _updateNoFocusBorder() {
        Border b = UIManager.getBorder("Table.focusCellHighlightBorder");
        Insets i = b.getBorderInsets(this._component);
        this._noFocusBorder = new EmptyBorder(i.top, i.left, i.bottom, i.right);
    }

    private class Spacer
    implements Icon {
        private Spacer() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        public int getIconWidth() {
            return GroupCellHandler.this._foundDrillable ? GroupCellHandler.this._expandedIcon.getIconWidth() : 0;
        }

        public int getIconHeight() {
            return GroupCellHandler.this._expandedIcon.getIconHeight();
        }
    }

    private class Label
    extends JLabel {
        private int _row;
        private PropertyModel _model;

        public Label() {
            this.enableEvents(16L);
        }

        public void setCell(int row, PropertyModel model) {
            this._row = row;
            this._model = model;
        }

        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            if (e.getID() == 501 && SwingUtilities.isLeftMouseButton(e) && this.getIcon() != null) {
                if (this.getIcon() == GroupCellHandler.this._expandedIcon) {
                    this._setExpanded(false);
                } else if (this.getIcon() == GroupCellHandler.this._collapsedIcon) {
                    this._setExpanded(true);
                }
            }
        }

        private void _setExpanded(boolean expanded) {
            GroupCellHandler.this.__setCellExpanded(this._model, this._row, expanded);
            GroupCellHandler.this.cancelCellEditing();
        }
    }

    private class Content
    extends ToolTipPanel {
        private String _name;

        private Content() {
        }

        public void setAccessibleName(String name) {
            this._name = name;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new JComponent.AccessibleJComponent(){

                    public AccessibleRole getAccessibleRole() {
                        return AccessibleRole.LABEL;
                    }

                    public String getAccessibleName() {
                        if (this.accessibleName != null && !"".equals(this.accessibleName)) {
                            return this.accessibleName;
                        }
                        return Content.this._name;
                    }

                    public int getAccessibleChildCount() {
                        return 0;
                    }

                    public Accessible getAccessibleChild(int index) {
                        return null;
                    }
                };
            }
            return this.accessibleContext;
        }
    }

    private class ToolTipPanel
    extends JPanel {
        private ToolTipPanel() {
        }

        public String getToolTipText(MouseEvent e) {
            Component c = this._getComponentAt(e.getPoint());
            if (c != this && c instanceof JComponent) {
                Point p = e.getPoint();
                p.translate(-c.getX(), -c.getY());
                e = new MouseEvent(c, e.getID(), e.getWhen(), e.getModifiers(), p.x, p.y, e.getClickCount(), e.isPopupTrigger());
                return ((JComponent)c).getToolTipText(e);
            }
            return super.getToolTipText(e);
        }

        private Component _getComponentAt(Point p) {
            Component[] comps = this.getComponents();
            int count = comps == null ? 0 : comps.length;
            for (int i = 0; i < count; ++i) {
                if (!comps[i].contains(p)) continue;
                return comps[i];
            }
            return null;
        }
    }

    private class IndentLayout
    implements LayoutManager {
        private int _indent;

        private IndentLayout() {
        }

        public void setIndent(int indent) {
            this._indent = indent;
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension d = parent.getComponent(0).getPreferredSize();
            d.width += this._indent;
            return d;
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension d = parent.getComponent(0).getMinimumSize();
            d.width += this._indent;
            return d;
        }

        public void layoutContainer(Container parent) {
            Dimension size = parent.getSize();
            Insets i = parent.getInsets();
            Component c = parent.getComponent(0);
            c.setBounds(i.left + this._indent, i.top, size.width - this._indent - (i.left + i.right), size.height - (i.top + i.bottom));
        }
    }
}

