/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.timesten;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import oracle.ideri.util.Product;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.timesten.TimesTen11g;
import oracle.javatools.db.timesten.TimesTen11gR2;
import oracle.javatools.db.timesten.TimesTen7;
import oracle.javatools.db.timesten.TimesTenDatabaseDescriptor;
import oracle.javatools.db.timesten.TimesTenDatabaseImpl;
import oracle.javatools.db.timesten.resource.TTBundle;

public class TimesTenDatabaseFactory
extends BaseDatabaseCreator {
    public TimesTenDatabaseFactory() {
        this.registerProviderClass(TimesTenDatabaseImpl.class, TTBundle.get("DB_TIMESTEN_6"), new TimesTenDatabaseImpl.Registerer());
        this.registerProviderClass(TimesTen7.class, TTBundle.get("DB_TIMESTEN_7"), new TimesTen7.Registerer());
        this.registerProviderClass(TimesTen11g.class, TTBundle.get("DB_TIMESTEN_11g"), new TimesTen11g.Registerer());
        this.registerProviderClass(TimesTen11gR2.class, TTBundle.get("DB_TIMESTEN_11gR2"), new TimesTen11gR2.Registerer());
    }

    protected Database createDatabaseImpl(String string, String string2, Connection connection) {
        int n = this.getTimesTenConnectionVersion(connection);
        switch (n) {
            case 0: {
                return null;
            }
            case 112: {
                return new TimesTen11gR2(string, string2, connection);
            }
            case 110: {
                return new TimesTen11g(string, string2, connection);
            }
            case 7: {
                return new TimesTen7(string, string2, connection);
            }
        }
        return new TimesTenDatabaseImpl(string, string2, connection);
    }

    private int getTimesTenConnectionVersion(Connection connection) {
        int n;
        block6: {
            n = 0;
            if (connection != null && !Product.isRaptor()) {
                try {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    String string = databaseMetaData.getDatabaseProductName();
                    if (!string.startsWith("TimesTen")) break block6;
                    try {
                        int n2 = databaseMetaData.getDatabaseMajorVersion();
                        int n3 = this.getMinorVersion(databaseMetaData.getDatabaseProductVersion());
                        if (n2 == 11) {
                            n = n3 >= 2 ? 112 : 110;
                            break block6;
                        }
                        n = n2;
                    }
                    catch (Throwable throwable) {}
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return n;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class clazz) {
        TimesTenDatabaseDescriptor timesTenDatabaseDescriptor = null;
        if (TimesTenDatabaseImpl.class.isAssignableFrom(clazz)) {
            timesTenDatabaseDescriptor = new TimesTenDatabaseDescriptor(clazz);
        }
        return timesTenDatabaseDescriptor;
    }

    private int getMinorVersion(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " .");
        int n = 0;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (n == 2) {
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 0;
                }
                break;
            }
            ++n;
        }
        return n2;
    }
}

