/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.table;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.StatusIndicator;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.table.EditableTableModel;
import oracle.javatools.ui.table.SplitButton;
import oracle.javatools.ui.table.TableHelper;
import oracle.javatools.ui.table.TableUIManager;

public final class TableToolbar
extends JPanel {
    public static final int TOOL_NONE = 0;
    public static final int TOOL_NEW = 1;
    public static final int TOOL_EDIT = 2;
    public static final int TOOL_DELETE = 4;
    public static final int TOOL_CLEAR = 8;
    public static final int TOOL_COPY = 16;
    public static final int TOOL_PASTE = 32;
    public static final int TOOL_DUPLICATE = 64;
    private static final Border _EMPTY_BORDER = BorderFactory.createEmptyBorder();
    private static final Border _NON_EMPTY_BORDER = BorderFactory.createMatteBorder(1, 1, 0, 1, Colors.FLAT_EDITOR_BORDER);
    private JTable _table;
    private TitleBarComp _bar;
    private ControlBar _controls;
    private HashMap<ToolAction, Action> _actions;
    private int _toolMask;
    private ToolBarButton _add;
    private ToolBarButton _edit;
    private ToolBarButton _delete;
    private ToolBarButton _clear;
    private ToolBarButton _copy;
    private ToolBarButton _paste;
    private ToolBarButton _duplicate;
    private Listener _listener;

    public TableToolbar(JTable table) {
        this(table, null);
    }

    public TableToolbar(JTable table, String label) {
        this(table, label, 0);
    }

    public TableToolbar(JTable table, String label, int toolMask) {
        this._init(table, label, toolMask);
    }

    public void setLabel(String text) {
        if (text != this.getLabel()) {
            JLabel label = this._bar.getLabel();
            if (label == null) {
                label = new JLabel();
                this._bar.setLabel(label);
            }
            label.setText(text);
            this._installBorder();
        }
    }

    public String getLabel() {
        JLabel label = this._bar.getLabel();
        if (label != null) {
            return label.getText();
        }
        return null;
    }

    public void setStatusIndicator(StatusIndicator statusIndicator) {
        this._bar.setStatusIndicator(statusIndicator);
    }

    public void setToolMask(int mask) {
        if (mask > 127) {
            throw new IllegalArgumentException("Tool Mask out of range");
        }
        if (mask != this._toolMask) {
            int removeMask = this._toolMask & ~mask;
            if ((removeMask & 1) > 0) {
                this.setAddVisible(false);
            }
            if ((removeMask & 2) > 0) {
                this.setEditVisible(false);
            }
            if ((removeMask & 4) > 0) {
                this.setDeleteVisible(false);
            }
            if ((removeMask & 8) > 0) {
                this.setClearVisible(false);
            }
            if ((removeMask & 0x10) > 0) {
                this.setCopyVisible(false);
            }
            if ((removeMask & 0x20) > 0) {
                this.setPasteVisible(false);
            }
            if ((removeMask & 0x40) > 0) {
                this.setDuplicateVisible(false);
            }
            if ((mask & 1) > 0) {
                this.setAddVisible(true);
            }
            if ((mask & 2) > 0) {
                this.setEditVisible(true);
            }
            if ((mask & 4) > 0) {
                this.setDeleteVisible(true);
            }
            if ((mask & 8) > 0) {
                this.setClearVisible(true);
            }
            if ((mask & 0x10) > 0) {
                this.setCopyVisible(true);
            }
            if ((mask & 0x20) > 0) {
                this.setPasteVisible(true);
            }
            if ((mask & 0x40) > 0) {
                this.setDuplicateVisible(true);
            }
        }
    }

    public int getToolMask() {
        return this._toolMask;
    }

    public void setAddVisible(boolean visible) {
        if (visible != this.isAddVisible()) {
            if (visible) {
                if (this._add == null) {
                    this._add = this._createButton("add.png");
                }
                this._controls.add(this._add);
                this._toolMask |= 1;
            } else {
                if (this._add != null) {
                    this._controls.remove(this._add);
                }
                this._toolMask &= 0xFFFFFFFE;
            }
            this.revalidate();
            this._installBorder();
        }
    }

    public boolean isAddVisible() {
        return (this._toolMask & 1) > 0;
    }

    public void setAddEnabled(boolean enable) {
        if (this._add != null) {
            this._add.setEnabled(enable);
        }
    }

    public boolean isAddEnabled() {
        return this._add != null && this._add.isEnabled();
    }

    public void setAddMenuActions(Action ... addAction) {
        if (this._add == null) {
            this._add = this._createButton("add.png");
        }
        this._add.setMenuActions(addAction);
    }

    public Action[] getAddMenuActions() {
        if (this._add != null) {
            return this._add.getMenuActions();
        }
        return null;
    }

    public void setDefaultAddAction(Action action) {
        if (this._add == null) {
            this._add = this._createButton("add.png");
        }
        this._add.setAction(action);
    }

    public Action getDefaultAddAction() {
        if (this._add != null) {
            return this._add.getAction();
        }
        return null;
    }

    public void setEditVisible(boolean visible) {
        if (visible != this.isEditVisible()) {
            if (visible) {
                if (this._edit == null) {
                    this._edit = this._createButton("edit.png");
                }
                this._controls.add(this._edit);
                this._toolMask |= 2;
            } else {
                if (this._edit != null) {
                    this._controls.remove(this._edit);
                }
                this._toolMask &= 0xFFFFFFFD;
            }
            this.revalidate();
            this._installBorder();
        }
    }

    public boolean isEditVisible() {
        return (this._toolMask & 2) > 0;
    }

    public void setEditEnabled(boolean enable) {
        if (this._edit != null) {
            this._edit.setEnabled(enable);
        }
    }

    public boolean isEditEnabled() {
        return this._edit != null && this._edit.isEnabled();
    }

    public void setEditMenuActions(Action ... editAction) {
        if (this._edit == null) {
            this._edit = this._createButton("edit.png");
        }
        this._edit.setMenuActions(editAction);
    }

    public Action[] getEditMenuActions() {
        if (this._edit != null) {
            return this._edit.getMenuActions();
        }
        return null;
    }

    public void setDefaultEditAction(Action action) {
        if (this._edit == null) {
            this._edit = this._createButton("edit.png");
        }
        this._edit.setAction(action);
    }

    public Action getDefaultEditAction() {
        if (this._edit != null) {
            return this._edit.getAction();
        }
        return null;
    }

    public void setDeleteVisible(boolean visible) {
        if (visible != this.isDeleteVisible()) {
            if (visible) {
                if (this._delete == null) {
                    this._delete = this._createButton("delete.png");
                }
                this._controls.add(this._delete);
                this._toolMask |= 4;
            } else {
                if (this._delete != null) {
                    this._controls.remove(this._delete);
                }
                this._toolMask &= 0xFFFFFFFB;
            }
            this.revalidate();
            this._installBorder();
        }
    }

    public boolean isDeleteVisible() {
        return (this._toolMask & 4) > 0;
    }

    public void setDeleteEnabled(boolean enable) {
        if (this._delete != null) {
            this._delete.setEnabled(enable);
        }
    }

    public boolean isDeleteEnabled() {
        return this._delete != null && this._delete.isEnabled();
    }

    public void setDeleteMenuActions(Action ... copyAction) {
        if (this._delete == null) {
            this._delete = this._createButton("delete.png");
        }
        this._delete.setMenuActions(copyAction);
    }

    public Action[] getDeleteMenuActions() {
        if (this._delete != null) {
            return this._delete.getMenuActions();
        }
        return null;
    }

    public void setDefaultDeleteAction(Action action) {
        if (this._delete == null) {
            this._delete = this._createButton("delete.png");
        }
        this._delete.setAction(action);
    }

    public Action getDefaultDeleteAction() {
        if (this._delete != null) {
            return this._delete.getAction();
        }
        return null;
    }

    public void setClearVisible(boolean visible) {
        if (visible != this.isClearVisible()) {
            if (visible) {
                if (this._clear == null) {
                    this._clear = this._createButton("clear.png");
                }
                this._controls.add(this._clear);
                this._toolMask |= 8;
            } else {
                if (this._clear != null) {
                    this._controls.remove(this._clear);
                }
                this._toolMask &= 0xFFFFFFF7;
            }
            this.revalidate();
            this._installBorder();
        }
    }

    public boolean isClearVisible() {
        return (this._toolMask & 8) > 0;
    }

    public void setClearEnabled(boolean enable) {
        if (this._clear != null) {
            this._clear.setEnabled(enable);
        }
    }

    public boolean isClearEnabled() {
        return this._clear != null && this._clear.isEnabled();
    }

    public void setClearMenuActions(Action ... copyAction) {
        if (this._clear == null) {
            this._clear = this._createButton("clear.png");
        }
        this._clear.setMenuActions(copyAction);
    }

    public Action[] getClearMenuActions() {
        if (this._clear != null) {
            return this._clear.getMenuActions();
        }
        return null;
    }

    public void setDefaultClearAction(Action action) {
        if (this._clear == null) {
            this._clear = this._createButton("clear.png");
        }
        this._clear.setAction(action);
    }

    public Action getDefaultClearAction() {
        if (this._clear != null) {
            return this._clear.getAction();
        }
        return null;
    }

    public void setCopyVisible(boolean visible) {
        if (visible != this.isCopyVisible()) {
            if (visible) {
                if (this._copy == null) {
                    this._copy = this._createButton("copy.png");
                }
                this._controls.add(this._copy);
                this._toolMask |= 0x10;
            } else {
                if (this._copy != null) {
                    this._controls.remove(this._copy);
                }
                this._toolMask &= 0xFFFFFFEF;
            }
            this.revalidate();
            this._installBorder();
        }
    }

    public boolean isCopyVisible() {
        return (this._toolMask & 0x10) > 0;
    }

    public void setCopyEnabled(boolean enable) {
        if (this._copy != null) {
            this._copy.setEnabled(enable);
        }
    }

    public boolean isCopyEnabled() {
        return this._copy != null && this._copy.isEnabled();
    }

    public void setCopyMenuActions(Action ... copyAction) {
        if (this._copy == null) {
            this._copy = this._createButton("copy.png");
        }
        this._copy.setMenuActions(copyAction);
    }

    public Action[] getCopyMenuActions() {
        if (this._copy != null) {
            return this._copy.getMenuActions();
        }
        return null;
    }

    public void setDefaultCopyAction(Action action) {
        if (this._copy == null) {
            this._copy = this._createButton("copy.png");
        }
        this._copy.setAction(action);
    }

    public Action getDefaultCopyAction() {
        if (this._copy != null) {
            return this._copy.getAction();
        }
        return null;
    }

    public void setPasteVisible(boolean visible) {
        if (visible != this.isPasteVisible()) {
            if (visible) {
                if (this._paste == null) {
                    this._paste = this._createButton("paste.png");
                }
                this._controls.add(this._paste);
                this._toolMask |= 0x20;
            } else {
                if (this._paste != null) {
                    this._controls.remove(this._paste);
                }
                this._toolMask &= 0xFFFFFFDF;
            }
            this.revalidate();
            this._installBorder();
        }
    }

    public boolean isPasteVisible() {
        return (this._toolMask & 0x20) > 0;
    }

    public void setPasteEnabled(boolean enable) {
        if (this._paste != null) {
            this._paste.setEnabled(enable);
        }
    }

    public boolean isPasteEnabled() {
        return this._paste != null && this._paste.isEnabled();
    }

    public void setPasteMenuActions(Action ... copyAction) {
        if (this._paste == null) {
            this._paste = this._createButton("paste.png");
        }
        this._paste.setMenuActions(copyAction);
    }

    public Action[] getPasteMenuActions() {
        if (this._paste != null) {
            return this._paste.getMenuActions();
        }
        return null;
    }

    public void setDefaultPasteAction(Action action) {
        if (this._paste == null) {
            this._paste = this._createButton("paste.png");
        }
        this._paste.setAction(action);
    }

    public Action getDefaultPasteAction() {
        if (this._paste != null) {
            return this._paste.getAction();
        }
        return null;
    }

    public void setDuplicateVisible(boolean visible) {
        if (visible != this.isDuplicateVisible()) {
            if (visible) {
                if (this._duplicate == null) {
                    this._duplicate = this._createButton("duplicate.png");
                }
                this._controls.add(this._duplicate);
                this._toolMask |= 0x40;
            } else {
                if (this._duplicate != null) {
                    this._controls.remove(this._duplicate);
                }
                this._toolMask &= 0xFFFFFFBF;
            }
            this.revalidate();
            this._installBorder();
        }
    }

    public boolean isDuplicateVisible() {
        return (this._toolMask & 0x40) > 0;
    }

    public void setDuplicateEnabled(boolean enable) {
        if (this._duplicate != null) {
            this._duplicate.setEnabled(enable);
        }
    }

    public boolean isDuplicateEnabled() {
        return this._duplicate != null && this._duplicate.isEnabled();
    }

    public void setDuplicateMenuActions(Action ... copyAction) {
        if (this._duplicate == null) {
            this._duplicate = this._createButton("duplicate.png");
        }
        this._duplicate.setMenuActions(copyAction);
    }

    public Action[] getDuplicateMenuActions() {
        if (this._duplicate != null) {
            return this._duplicate.getMenuActions();
        }
        return null;
    }

    public void setDefaultDuplicateAction(Action action) {
        if (this._duplicate == null) {
            this._duplicate = this._createButton("duplicate.png");
        }
        this._duplicate.setAction(action);
    }

    public Action getDefaultDuplicateAction() {
        if (this._duplicate != null) {
            return this._duplicate.getAction();
        }
        return null;
    }

    public void addActionControl(Action action) {
        this.addActionControl(action, true);
    }

    public void addActionControl(Action action, boolean right) {
        this.addActionControl(new JButton(action), right);
    }

    public void addActionControl(Component tool) {
        this.addActionControl(tool, true);
    }

    public void addActionControl(Component tool, boolean right) {
        if (!right) {
            ControlBar leftControls = this._bar.getLeftControlBar();
            if (leftControls == null) {
                leftControls = this._bar.createControlBar();
                this._bar.setLeftControlBar(leftControls);
            }
            leftControls.add(tool, leftControls.getComponentCount());
        } else {
            this._controls.add(tool, this._controls.getComponentCount());
        }
    }

    public void removeActionControl(Component tool) {
        this._controls.remove(tool);
        ControlBar leftControls = this._bar.getLeftControlBar();
        if (leftControls != null) {
            leftControls.remove(tool);
        }
    }

    public Action getDefaultAction(ToolAction action) {
        Action defaultAction = this._actions.get((Object)action);
        if (defaultAction == null) {
            defaultAction = new DefaultModelAction(action.getName());
            defaultAction.putValue("SwingLargeIconKey", OracleIcons.getIcon((String)action.getIconKey()));
            defaultAction.putValue("ShortDescription", action.getName());
            defaultAction.putValue("ActionCommandKey", action.getName());
            this._updateEnableActions(defaultAction, action);
            this._actions.put(action, defaultAction);
        }
        return defaultAction;
    }

    private void _init(JTable table, String label, int toolMask) {
        this.setLayout(new BorderLayout());
        this._bar = new TitleBarComp();
        this._bar.setBackground(TableUIManager.TABLE_GRID_COLOR);
        this.add((Component)this._bar, "North");
        this._controls = this._bar.createControlBar();
        this._bar.setControlBar(this._controls);
        this._actions = new HashMap(8);
        this._listener = new Listener();
        this._table = table;
        this._table.addPropertyChangeListener("rowSelectionAllowed", this._listener);
        this._table.addPropertyChangeListener("columnSelectionAllowed", this._listener);
        this._table.addPropertyChangeListener("model", this._listener);
        this._table.addPropertyChangeListener("transferHandler", this._listener);
        this._table.addPropertyChangeListener("enabled", this._listener);
        this._table.getSelectionModel().addListSelectionListener(this._listener);
        this._table.getColumnModel().getSelectionModel().addListSelectionListener(this._listener);
        this.setLabel(label);
        this.setToolMask(toolMask);
        this._installBorder();
    }

    private void _installBorder() {
        Component title = this._bar.getComponent(0);
        if (title != null && title instanceof JComponent) {
            String label = this.getLabel();
            if ((label == null || "".equals(label)) && this._toolMask == 0) {
                ((JComponent)title).setBorder(_EMPTY_BORDER);
            } else {
                ((JComponent)title).setBorder(_NON_EMPTY_BORDER);
            }
        }
    }

    private ToolBarButton _createButton(String iconKey) {
        return new ToolBarButton(OracleIcons.getIcon((String)iconKey));
    }

    private void _updateAllEnableActions() {
        if (this._actions != null) {
            Set<ToolAction> actionkeys = this._actions.keySet();
            for (ToolAction ta : actionkeys) {
                this._updateEnableActions(this._actions.get((Object)ta), ta);
            }
        }
    }

    private void _updateEnableActions(Action action, ToolAction actionKey) {
        if (action != null) {
            if (!this._table.isEnabled()) {
                action.setEnabled(false);
                return;
            }
            TableModel model = this._table.getModel();
            boolean isEditableModel = model instanceof EditableTableModel || model instanceof DefaultTableModel;
            boolean isEnabled = action.isEnabled();
            if (ToolAction.ADD_ROW.equals((Object)actionKey) || ToolAction.ADD_COLUMN.equals((Object)actionKey)) {
                isEnabled = isEditableModel;
            } else if (ToolAction.ADD_ROW_AFTER.equals((Object)actionKey) || ToolAction.ADD_ROW_BEFORE.equals((Object)actionKey) || ToolAction.DUPLICATE_ROW.equals((Object)actionKey)) {
                isEnabled = isEditableModel && this._table.getRowSelectionAllowed() && this._table.getSelectedRowCount() != 0;
            } else if (ToolAction.DELETE_ROW.equals((Object)actionKey)) {
                isEnabled = isEditableModel && !this._table.getCellSelectionEnabled() && this._table.getRowSelectionAllowed() && this._table.getSelectedRowCount() != 0;
            } else if (ToolAction.DELETE_COLUMN.equals((Object)actionKey)) {
                isEnabled = model instanceof EditableTableModel && !this._table.getCellSelectionEnabled() && this._table.getColumnSelectionAllowed() && this._table.getSelectedColumnCount() != 0;
            } else if (ToolAction.CLEAR.equals((Object)actionKey)) {
                isEnabled = this._isSomeThingSelected();
            } else if (ToolAction.COPY.equals((Object)actionKey)) {
                TransferHandler th = this._table.getTransferHandler();
                isEnabled = th != null && (th.getSourceActions(this._table) & 1) != 0 && this._isSomeThingSelected();
            } else if (ToolAction.PASTE.equals((Object)actionKey)) {
                isEnabled = isEditableModel && this._table.getTransferHandler() != null;
            }
            action.setEnabled(isEnabled);
        }
    }

    private boolean _isSomeThingSelected() {
        if (this._table.getCellSelectionEnabled()) {
            return this._table.getSelectedColumnCount() != 0 && this._table.getSelectedRowCount() != 0;
        }
        if (this._table.getRowSelectionAllowed()) {
            return this._table.getSelectedRowCount() != 0;
        }
        if (this._table.getColumnSelectionAllowed()) {
            return this._table.getSelectedColumnCount() != 0;
        }
        return false;
    }

    private void _addRowAtEnd() {
        TableModel model = this._table.getModel();
        if (model instanceof EditableTableModel) {
            TableHelper.stopCellEditing(this._table);
            ((EditableTableModel)((Object)model)).addRow(null);
        } else if (model instanceof DefaultTableModel) {
            TableHelper.stopCellEditing(this._table);
            ((DefaultTableModel)model).addRow((Object[])null);
        } else {
            return;
        }
        this._scrollIntoViewAndEditCell(this._table.convertRowIndexToView(model.getRowCount() - 1), 0, true);
    }

    private void _insertRowAfterSel() {
        int row = this._table.getSelectedRow();
        if (row != -1) {
            TableModel model = this._table.getModel();
            int modelIndex = this._table.convertRowIndexToModel(row);
            if (model instanceof EditableTableModel) {
                TableHelper.stopCellEditing(this._table);
                ((EditableTableModel)((Object)model)).insertRow(modelIndex + 1, null);
            } else if (model instanceof DefaultTableModel) {
                TableHelper.stopCellEditing(this._table);
                ((DefaultTableModel)model).insertRow(modelIndex + 1, (Object[])null);
            } else {
                return;
            }
            this._scrollIntoViewAndEditCell(this._table.convertRowIndexToView(modelIndex + 1), 0, true);
        }
    }

    private void _insertRowBeforeSel() {
        int row = this._table.getSelectedRow();
        if (row != -1) {
            TableModel model = this._table.getModel();
            int modelIndex = this._table.convertRowIndexToModel(row);
            if (model instanceof EditableTableModel) {
                TableHelper.stopCellEditing(this._table);
                ((EditableTableModel)((Object)model)).insertRow(modelIndex, null);
            } else if (model instanceof DefaultTableModel) {
                TableHelper.stopCellEditing(this._table);
                ((DefaultTableModel)model).insertRow(modelIndex, (Object[])null);
            } else {
                return;
            }
            this._scrollIntoViewAndEditCell(this._table.convertRowIndexToView(modelIndex), 0, true);
        }
    }

    private void _addColumnAtEnd() {
        TableModel model = this._table.getModel();
        if (model instanceof EditableTableModel || model instanceof DefaultTableModel) {
            TableHelper.stopCellEditing(this._table);
            TableHelper.addColumn(this._table, null, null);
            this._scrollIntoViewAndEditCell(0, Math.max(this._table.getColumnCount() - 1, 0), true);
        }
    }

    private void _deleteSelectedRows() {
        if (!this._table.getCellSelectionEnabled() && this._table.getRowSelectionAllowed()) {
            TableHelper.stopCellEditing(this._table);
            TableModel model = this._table.getModel();
            if (model instanceof EditableTableModel || model instanceof DefaultTableModel) {
                int i;
                int[] rows = this._table.getSelectedRows();
                int[] modelIndices = new int[rows.length];
                for (i = 0; i < rows.length; ++i) {
                    modelIndices[i] = this._table.convertRowIndexToModel(rows[i]);
                }
                Arrays.sort(modelIndices);
                for (i = modelIndices.length - 1; i >= 0; --i) {
                    int modelIndex = modelIndices[i];
                    if (model instanceof EditableTableModel) {
                        ((EditableTableModel)((Object)model)).removeRow(modelIndex);
                        continue;
                    }
                    ((DefaultTableModel)model).removeRow(modelIndex);
                }
                int rCount = this._table.getRowCount() - 1;
                for (int i2 = 0; i2 < rows.length; ++i2) {
                    int row = Math.min(rows[i2], rCount);
                    if (row == -1) continue;
                    this._table.addRowSelectionInterval(row, row);
                }
            }
        }
    }

    private void _deleteSelectedColumns() {
        if (!this._table.getCellSelectionEnabled() && this._table.getColumnSelectionAllowed()) {
            TableHelper.stopCellEditing(this._table);
            TableModel model = this._table.getModel();
            if (model instanceof EditableTableModel) {
                int[] cols = this._table.getSelectedColumns();
                int[] modelIndices = new int[cols.length];
                for (int i = 0; i < cols.length; ++i) {
                    modelIndices[i] = this._table.convertColumnIndexToModel(cols[i]);
                }
                Arrays.sort(modelIndices);
                TableHelper.removeColumn(this._table, modelIndices);
                int colCount = this._table.getColumnCount() - 1;
                for (int i = 0; i < cols.length; ++i) {
                    int col = Math.min(cols[i], colCount);
                    if (col == -1) continue;
                    this._table.addColumnSelectionInterval(col, col);
                }
            }
        }
    }

    private void _clearSelectedCells() {
        block7: {
            TableModel model;
            block8: {
                block6: {
                    model = this._table.getModel();
                    if (!this._table.getCellSelectionEnabled()) break block6;
                    int[] cols = this._table.getSelectedColumns();
                    int[] rows = this._table.getSelectedRows();
                    for (int col : cols) {
                        for (int row : rows) {
                            if (!this._table.isCellEditable(row, col)) continue;
                            model.setValueAt(null, this._table.convertRowIndexToModel(row), this._table.convertColumnIndexToModel(col));
                        }
                    }
                    break block7;
                }
                if (!this._table.getRowSelectionAllowed()) break block8;
                int[] rows = this._table.getSelectedRows();
                int modelColCount = this._table.getModel().getColumnCount();
                for (int row : rows) {
                    for (int modelCol = 0; modelCol < modelColCount; ++modelCol) {
                        if (!this._table.isCellEditable(row, this._table.convertColumnIndexToView(modelCol))) continue;
                        model.setValueAt(null, this._table.convertRowIndexToModel(row), modelCol);
                    }
                }
                break block7;
            }
            if (!this._table.getColumnSelectionAllowed()) break block7;
            int[] cols = this._table.getSelectedColumns();
            int modelRowCount = this._table.getModel().getRowCount();
            for (int col : cols) {
                for (int modelRow = 0; modelRow < modelRowCount; ++modelRow) {
                    if (!this._table.isCellEditable(this._table.convertRowIndexToView(modelRow), col)) continue;
                    model.setValueAt(null, modelRow, this._table.convertColumnIndexToModel(col));
                }
            }
        }
    }

    private void _duplicateSelectedRows() {
        int row = this._table.getSelectedRow();
        if (row != -1) {
            TableModel model = this._table.getModel();
            int modelIndex = this._table.convertRowIndexToModel(row);
            int selectIndex = modelIndex + 1;
            if (model instanceof EditableTableModel) {
                TableHelper.stopCellEditing(this._table);
                selectIndex = ((EditableTableModel)((Object)model)).duplicateRow(modelIndex, 1);
            } else if (model instanceof DefaultTableModel) {
                TableHelper.stopCellEditing(this._table);
                Object[] rowData = new Object[model.getColumnCount()];
                for (int i = 0; i < rowData.length; ++i) {
                    rowData[i] = model.getValueAt(modelIndex, i);
                }
                ((DefaultTableModel)model).insertRow(modelIndex + 1, rowData);
            } else {
                return;
            }
            if (selectIndex != -1) {
                this._scrollIntoViewAndEditCell(this._table.convertRowIndexToView(selectIndex), 0, false);
            }
        }
    }

    private void _scrollIntoViewAndEditCell(int row, int col, boolean edit) {
        if (col < 0 || col >= this._table.getColumnCount() || row < 0 || row >= this._table.getRowCount()) {
            return;
        }
        this._table.setRowSelectionInterval(row, row);
        this._table.setColumnSelectionInterval(col, col);
        this._table.scrollRectToVisible(this._table.getCellRect(row, col, true));
        if (edit) {
            this._table.requestFocus();
            this._table.editCellAt(row, col);
        }
    }

    private class TitleBarComp
    extends JPanel {
        private final JPanel _header = new JPanel((LayoutManager)new MigLayout("ins 0, hidemode 3, fillx"));
        private final JPanel _title = new JPanel();
        private JLabel _label;
        private JComponent _statusIndicatorComp;
        private ControlBar _controlBar;
        private ControlBar _leftControlBar;

        public TitleBarComp() {
            this.setLayout(new BorderLayout(0, 0));
            this.add((Component)this._header, "North");
            this._header.add((Component)this._title, "grow x");
            this._title.setLayout(new BorderLayout());
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Boolean highContrast = (Boolean)toolkit.getDesktopProperty("win.highContrast.on");
            if (Boolean.TRUE.equals(highContrast)) {
                this._title.setBackground(Color.BLACK);
            } else {
                this._title.setBackground(Colors.TAB_PANE_BACKGROUND);
            }
            this._header.setBackground(Colors.TAB_PANE_BACKGROUND);
        }

        public ControlBar createControlBar() {
            ControlBar bar = new ControlBar();
            bar.setOpaque(false);
            return bar;
        }

        public void setLabel(JLabel label) {
            if (this._label == label) {
                return;
            }
            this.installLabelBorder(label);
            this.swapComponent(this._title, this._label, label, "West");
            this._label = label;
        }

        public JLabel getLabel() {
            return this._label;
        }

        public void setControlBar(ControlBar controlBar) {
            if (this._controlBar == controlBar) {
                return;
            }
            this.swapComponent(this._title, this._controlBar, controlBar, "East");
            this._controlBar = controlBar;
        }

        public ControlBar getControlBar() {
            return this._controlBar;
        }

        public void setLeftControlBar(ControlBar controlBar) {
            if (this._leftControlBar == controlBar) {
                return;
            }
            this.swapComponent(this._title, this._leftControlBar, controlBar, "Center");
            this._leftControlBar = controlBar;
        }

        public ControlBar getLeftControlBar() {
            return this._leftControlBar;
        }

        private void installLabelBorder(JLabel label) {
            if (!this.canInstallBorder(label)) {
                return;
            }
            label.setBorder(new BorderUIResource.EmptyBorderUIResource(3, 3, 3, 3));
        }

        private boolean canInstallBorder(JComponent c) {
            if (c == null) {
                return false;
            }
            return c.getBorder() == null || c.getBorder() instanceof UIResource;
        }

        private void swapComponent(JComponent parent, Component oldComponent, Component newComponent, String layoutPosition) {
            if (oldComponent != null) {
                parent.remove(oldComponent);
            }
            if (newComponent != null) {
                parent.add(newComponent, layoutPosition);
            }
            parent.revalidate();
            this.revalidate();
        }

        @Override
        protected void paintChildren(Graphics g) {
            if (!this._title.isOpaque()) {
                this._title.setOpaque(true);
            }
            super.paintChildren(g);
        }

        private void setStatusIndicator(StatusIndicator statusIndicator) {
            if (this._statusIndicatorComp != null) {
                this._header.remove(this._statusIndicatorComp);
            }
            this._statusIndicatorComp = null;
            if (statusIndicator != null) {
                this._statusIndicatorComp = statusIndicator.configureStandalone(StatusIndicator.OkPolicy.REMOVE);
                this._statusIndicatorComp.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 3));
                this._header.add((Component)this._statusIndicatorComp, "dock west");
            }
        }
    }

    private class Listener
    implements ActionListener,
    PropertyChangeListener,
    ListSelectionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String actionCommand = ae.getActionCommand();
            if (ToolAction.ADD_ROW.getName().equals(actionCommand)) {
                TableToolbar.this._addRowAtEnd();
            } else if (ToolAction.ADD_ROW_BEFORE.getName().equals(actionCommand)) {
                TableToolbar.this._insertRowBeforeSel();
            } else if (ToolAction.ADD_ROW_AFTER.getName().equals(actionCommand)) {
                TableToolbar.this._insertRowAfterSel();
            } else if (ToolAction.ADD_COLUMN.getName().equals(actionCommand)) {
                TableToolbar.this._addColumnAtEnd();
            } else if (ToolAction.DELETE_ROW.getName().equals(actionCommand)) {
                TableToolbar.this._deleteSelectedRows();
            } else if (ToolAction.DELETE_COLUMN.getName().equals(actionCommand)) {
                TableToolbar.this._deleteSelectedColumns();
            } else if (ToolAction.CLEAR.getName().equals(actionCommand)) {
                TableToolbar.this._clearSelectedCells();
            } else if (ToolAction.COPY.getName().equals(actionCommand)) {
                ae.setSource(TableToolbar.this._table);
                TableToolbar.this._table.getActionMap().get("copy").actionPerformed(ae);
            } else if (ToolAction.PASTE.getName().equals(actionCommand)) {
                ae.setSource(TableToolbar.this._table);
                TableToolbar.this._table.getActionMap().get("paste").actionPerformed(ae);
            } else if (ToolAction.DUPLICATE_ROW.getName().equals(actionCommand)) {
                TableToolbar.this._duplicateSelectedRows();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent pe) {
            if ("transferHandler".equals(pe.getPropertyName())) {
                TableToolbar.this._updateEnableActions((Action)TableToolbar.this._actions.get((Object)ToolAction.COPY), ToolAction.COPY);
                TableToolbar.this._updateEnableActions((Action)TableToolbar.this._actions.get((Object)ToolAction.PASTE), ToolAction.PASTE);
            } else {
                TableToolbar.this._updateAllEnableActions();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            TableToolbar.this._updateAllEnableActions();
        }
    }

    private class DefaultModelAction
    extends AbstractAction {
        public DefaultModelAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TableToolbar.this._listener.actionPerformed(ae);
        }
    }

    private class ToolBarButton
    extends SplitButton {
        public ToolBarButton(Icon icon) {
            super((Action)null);
            this.setIcon(icon);
            this.setOpaque(false);
            this.setHideActionText(true);
        }

        @Override
        protected void configurePropertiesFromAction(Action a) {
            Icon oldIcon = this.getIcon();
            super.configurePropertiesFromAction(a);
            if (oldIcon != null && this.getIcon() == null) {
                this.setIcon(oldIcon);
            }
        }
    }

    public static enum ToolAction {
        ADD_ROW(UIBundle.get("TABLE_ADD_ROW"), "add.png"),
        ADD_ROW_BEFORE(UIBundle.get("TABLE_ADD_ROW_BEFORE"), "add.png"),
        ADD_ROW_AFTER(UIBundle.get("TABLE_ADD_ROW_AFTER"), "add.png"),
        ADD_COLUMN(UIBundle.get("TABLE_ADD_COLUMN"), "add.png"),
        DELETE_ROW(UIBundle.get("TABLE_DELETE_ROW"), "delete.png"),
        DELETE_COLUMN(UIBundle.get("TABLE_DELETE_COLUMN"), "delete.png"),
        CLEAR(UIBundle.get("TABLE_CLEAR"), "clear.png"),
        COPY(UIBundle.get("TABLE_COPY"), "copy.png"),
        PASTE(UIBundle.get("TABLE_PASTE"), "paste.png"),
        DUPLICATE_ROW(UIBundle.get("TABLE_DUPLICATE_ROW"), "duplicate.png");

        private String _iconKey;
        private String _name;

        private ToolAction(String name, String iconKey) {
            this._name = name;
            this._iconKey = iconKey;
        }

        private String getName() {
            return this._name;
        }

        private String getIconKey() {
            return this._iconKey;
        }
    }
}

