/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.table;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.ewt.util.MenuUtils;

class SplitButton
extends JToggleButton {
    protected static final PopupMenuListener POPUP_MENU_LISTENER = new ButtonPopupMenuListener();
    protected static final Icon POPUP_ICON = new PopupIndicator();
    protected static final int POPUP_WIDTH = Math.max(3 + POPUP_ICON.getIconWidth() + 3, 13);
    protected static final int NO_ACTION_POPUP_WIDTH = Math.max(2 + POPUP_ICON.getIconWidth() + 2, 9);
    protected static final String ACTION_SHOW_POPUP_MENU = "ShowPopupMenu";
    protected SplitPopupMenu _popup;
    private Image _capturedImage;
    private int _popup_width;
    private Action _showPopupAction;
    private ButtonCaptureAdapter _adapter;
    private AWTEventListener _awtListener;
    private boolean _popupAlreadyShown;

    public SplitButton(Action action) {
        super(action);
        this.setHorizontalAlignment(2);
        this.setModel(this.createModel());
        this._adapter = new ButtonCaptureAdapter();
        this.addComponentListener(this._adapter);
        this.addMouseListener(this._adapter);
        this.addMouseMotionListener(this._adapter);
        this.addPropertyChangeListener(this._adapter);
        this.createKeyBindings();
        this._awtListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event.getSource() == SplitButton.this && event.getID() == 501) {
                    SplitButton.this._popupAlreadyShown = SplitButton.this.isPopupVisible();
                }
            }
        };
    }

    private void createKeyBindings() {
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 0), ACTION_SHOW_POPUP_MENU);
        this.getActionMap().put(ACTION_SHOW_POPUP_MENU, this.getShowpopupAction());
    }

    private Action getShowpopupAction() {
        if (this._showPopupAction == null) {
            this._showPopupAction = new AbstractAction(ACTION_SHOW_POPUP_MENU){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SplitButton.this.hasPopup()) {
                        SplitButton.this._showPopup(e);
                    }
                }
            };
            this._showPopupAction.putValue("ActionCommandKey", ACTION_SHOW_POPUP_MENU);
        }
        return this._showPopupAction;
    }

    private void _showPopup(ActionEvent e) {
        this._adapter.showPopupMenu(e);
    }

    public void setMenuActions(Action[] actions) {
        if (actions == null) {
            this.releasePopupMenu();
        } else {
            if (this._popup == null) {
                this.createPopupMenu();
            } else {
                this._popup.removeAll();
            }
            for (int i = 0; i < actions.length; ++i) {
                Action action = actions[i];
                if (action != null) {
                    this._popup.add(action);
                    continue;
                }
                this._popup.addSeparator();
            }
            if (this.getMenuActionCount() != 0) {
                this._addDefaultActionToMenu(this.getAction());
            }
        }
        this._checkEnabledState();
    }

    @Override
    public void setAction(Action action) {
        Action old;
        if (this.getMenuActionCount() != 0 && (old = this.getAction()) != null) {
            Component[] comps;
            for (Component defActionComp : comps = this._popup.getComponents()) {
                AbstractButton b;
                if (!(defActionComp instanceof AbstractButton) || (b = (AbstractButton)defActionComp).getAction() != old) continue;
                this._popup.remove(defActionComp);
                break;
            }
        }
        super.setAction(action);
        if (this.getMenuActionCount() != 0) {
            this._addDefaultActionToMenu(action);
        }
        this._checkEnabledState();
        if (action == null) {
            this.addActionListener(this.getShowpopupAction());
        } else {
            this.removeActionListener(this.getShowpopupAction());
        }
        this._popup_width = action == null ? NO_ACTION_POPUP_WIDTH : POPUP_WIDTH;
        this.revalidate();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this._awtListener);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Toolkit.getDefaultToolkit().addAWTEventListener(this._awtListener, 16L);
    }

    @Override
    protected void actionPropertyChanged(Action action, String propertyName) {
        super.actionPropertyChanged(action, propertyName);
        if (propertyName == "enabled") {
            this._checkEnabledState();
        }
    }

    private void _checkEnabledState() {
        Action defAction = this.getAction();
        if (defAction != null) {
            if (this.getMenuActionCount() != 0) {
                this.setEnabled(true);
                if (!defAction.isEnabled()) {
                    this.listenerList.remove(ActionListener.class, defAction);
                } else if (!this._isListener(ActionListener.class, defAction)) {
                    this.listenerList.add(ActionListener.class, defAction);
                }
            } else if (defAction.isEnabled()) {
                this.setEnabled(true);
                if (!this._isListener(ActionListener.class, defAction)) {
                    this.listenerList.add(ActionListener.class, defAction);
                }
            } else {
                this.setEnabled(false);
                this.listenerList.remove(ActionListener.class, defAction);
            }
        }
    }

    private boolean _isListener(Class c, ActionListener a) {
        boolean isListener = false;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != c || listeners[i + 1] != a) continue;
            isListener = true;
        }
        return isListener;
    }

    private void _addDefaultActionToMenu(Action action) {
        if (action != null) {
            JMenuItem mi = this._popup.createActionComponent(action);
            mi.setAction(action);
            this._popup.add((Component)mi, 0);
        }
    }

    public int getMenuActionCount() {
        if (this._popup != null) {
            return this._popup.getComponentCount();
        }
        return 0;
    }

    public Action[] getMenuActions() {
        if (this.getMenuActionCount() == 0) {
            return null;
        }
        Component[] comps = this._popup.getComponents();
        Action defAction = this.getAction();
        int len = comps.length;
        if (defAction != null) {
            --len;
        }
        Action[] actions = new Action[len];
        int i = 0;
        for (int j = 0; j < comps.length; ++j) {
            if (comps[j] instanceof JMenuItem) {
                Action a = ((JMenuItem)comps[j]).getAction();
                if (defAction != null && a == defAction) continue;
                actions[i++] = a;
                continue;
            }
            actions[i++] = null;
        }
        return actions;
    }

    protected ButtonModel createModel() {
        return new JToggleButton.ToggleButtonModel(){

            @Override
            public boolean isSelected() {
                return SplitButton.this.isPopupVisible();
            }

            @Override
            public void setPressed(boolean b) {
                super.setPressed(b);
                if (!b && !SplitButton.this.isPopupVisible()) {
                    SplitButton.this._capturedImage = null;
                }
            }
        };
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this._popup == null || this._popup.getComponentCount() == 0) {
            return size;
        }
        size.width += this._popup_width + 1;
        return size;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this._popup != null) {
            SwingUtilities.updateComponentTreeUI(this._popup);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this._capturedImage != null && (this.isPopupVisible() || this.getModel().isPressed())) {
            g.drawImage(this._capturedImage, 0, 0, this);
            return;
        }
        this._capturedImage = null;
        super.paint(g);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth();
        int h = this.getHeight();
        if (this._popup == null || this._popup.getComponentCount() == 0) {
            return;
        }
        Action defAction = this.getAction();
        if (this.isEnabled() && (this.getModel().isRollover() || this.getModel().isSelected()) && defAction != null) {
            int x = w - this._popup_width - 1;
            boolean inset = true;
            Color oldColor = g.getColor();
            g.setColor(SystemColor.controlShadow);
            g.drawLine(x, 1, x, h - 1 - 1);
            g.setColor(SystemColor.controlLtHighlight);
            g.drawLine(x + 1, 1, x + 1, h - 1 - 1);
            g.setColor(oldColor);
        }
        Insets insets = this.getInsets();
        int xOff = defAction != null ? insets.left / 2 : insets.left;
        int x = w - xOff - (this._popup_width + POPUP_ICON.getIconWidth()) / 2;
        int y = (h - 1 - POPUP_ICON.getIconHeight()) / 2;
        POPUP_ICON.paintIcon(this, g, x, y);
    }

    @Override
    protected ActionListener createActionListener() {
        return new FilterActionEvents(this);
    }

    protected JPopupMenu createPopupMenu() {
        if (this._popup != null) {
            this.releasePopupMenu();
        }
        this._popup = new SplitPopupMenu();
        this._popup.addPopupMenuListener(POPUP_MENU_LISTENER);
        this.invalidate();
        return this._popup;
    }

    protected void releasePopupMenu() {
        if (this._popup != null) {
            this._popup.removePopupMenuListener(POPUP_MENU_LISTENER);
            this._popup.removeAll();
            this._popup = null;
            this.invalidate();
        }
    }

    protected boolean hasPopup() {
        return this._popup != null;
    }

    protected boolean isPopupVisible() {
        return this._popup != null && this._popup.isVisible();
    }

    private class SplitPopupMenu
    extends JPopupMenu {
        private SplitPopupMenu() {
        }

        @Override
        public JMenuItem createActionComponent(Action a) {
            return super.createActionComponent(a);
        }
    }

    protected static class ButtonPopupMenuListener
    implements PopupMenuListener {
        protected ButtonPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            JPopupMenu popup = (JPopupMenu)e.getSource();
            AbstractButton b = (AbstractButton)popup.getInvoker();
            b.getModel().setArmed(false);
            b.setSelected(false);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            Component[] comps;
            JPopupMenu popup = (JPopupMenu)e.getSource();
            for (Component comp : comps = popup.getComponents()) {
                JMenuItem item;
                if (!(comp instanceof JMenuItem)) continue;
                Action a = (item = (JMenuItem)comp).getAction();
                item.setEnabled(a != null ? item.getAction().isEnabled() : true);
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    private static final class PopupIndicator
    extends Polygon
    implements Icon {
        private static final int SIZE = 4;

        public PopupIndicator() {
            this.addPoint(0, 0);
            this.addPoint(2, 2);
            this.addPoint(4, 0);
        }

        @Override
        public int getIconHeight() {
            return this.getBounds().height;
        }

        @Override
        public int getIconWidth() {
            return this.getBounds().width;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c.isEnabled()) {
                this.paint(g, x, y, c.getForeground());
            } else {
                this.paint(g, x, y, c.getBackground().darker());
            }
        }

        private void paint(Graphics g, int x, int y, Color color) {
            Color oldColor = g.getColor();
            g.translate(x, y);
            g.setColor(color);
            g.fillPolygon(this);
            g.drawPolygon(this);
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }

    private static final class ButtonCaptureAdapter
    implements MouseInputListener,
    ComponentListener,
    PropertyChangeListener {
        private BufferedImage _buttonImage;
        private boolean _captured;

        private ButtonCaptureAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!this._captured && ((SplitButton)e.getComponent()).getAction() != null) {
                this.captureButtonImage(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.mouseEntered(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            SplitButton b = (SplitButton)e.getComponent();
            if (!b._popupAlreadyShown && b._popup != null && b._popup.getComponentCount() > 0 && this.isInPopup(e)) {
                this.showPopupMenu(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            this.uncaptureImage(e);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.uncaptureImage(e);
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.uncaptureImage(e);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("icon") || propertyName.equals("foreground") || propertyName.equals("background") || propertyName.equals("border") || propertyName.equals("opaque") || propertyName.equals("contentAreaFilled") || propertyName.equals("borderPainted") || propertyName.equals("rolloverEnabled") || propertyName.equals("rolloverIcon") || propertyName.equals("UI")) {
                this.uncaptureImage(e);
            }
        }

        private void showPopupMenu(EventObject e) {
            SplitButton b = (SplitButton)e.getSource();
            if (!this._captured && b.getAction() != null) {
                this.capturePopupImage(e);
            }
            b._capturedImage = this._captured ? this._buttonImage : null;
            MenuUtils.showPopupMenu((JPopupMenu)b._popup, (Component)b, (int)0, (int)b.getHeight());
        }

        private void captureButtonImage(EventObject e) {
            SplitButton b = (SplitButton)e.getSource();
            if (b.isEnabled() && b.isRolloverEnabled()) {
                BufferedImage image = this.getBufferedImage(b);
                if (!b.getModel().isRollover()) {
                    b.getModel().setRollover(true);
                }
                Graphics2D g2 = image.createGraphics();
                g2.setClip(0, 0, b.getWidth() - b._popup_width, b.getHeight());
                b.paintAll(g2);
                g2.dispose();
            }
        }

        private void capturePopupImage(EventObject e) {
            SplitButton b = (SplitButton)e.getSource();
            if (b.isEnabled() && b.isRolloverEnabled()) {
                BufferedImage image = this.getBufferedImage(b);
                Graphics2D g2 = image.createGraphics();
                g2.setClip(b.getWidth() - b._popup_width, 0, b._popup_width, b.getHeight());
                b.paintAll(g2);
                g2.dispose();
                this._captured = true;
            }
        }

        private void uncaptureImage(EventObject e) {
            SplitButton b = (SplitButton)e.getSource();
            b._capturedImage = null;
            this._captured = false;
        }

        private BufferedImage getBufferedImage(AbstractButton b) {
            if (this._buttonImage == null) {
                this._buttonImage = new BufferedImage(b.getWidth(), b.getHeight(), 2);
            }
            return this._buttonImage;
        }

        private boolean isInPopup(MouseEvent e) {
            SplitButton b = (SplitButton)e.getComponent();
            return SwingUtilities.isLeftMouseButton(e) && b.isEnabled() && b.hasPopup() && b.contains(e.getX(), e.getY()) && (b.getAction() == null || e.getX() >= b.getWidth() - b._popup_width);
        }
    }

    protected static class FilterActionEvents
    implements ActionListener,
    Serializable {
        private SplitButton _button;

        public FilterActionEvents(SplitButton button) {
            this._button = button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.canPerformAction()) {
                this._button.fireActionPerformed(e);
            }
        }

        protected boolean canPerformAction() {
            return !this._button.isPopupVisible() && this._button._capturedImage == null;
        }
    }
}

