/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.table;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.table.RolloverTableHandler;

class RolloverColumnHeaderRenderer
implements TableCellRenderer {
    private TableCellRenderer _baseRenderer;

    public RolloverColumnHeaderRenderer(TableCellRenderer baseRenderer) {
        this._baseRenderer = baseRenderer;
    }

    public TableCellRenderer getBaseRenderer() {
        return this._baseRenderer;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean isRollover = this._isColHeaderRolloverHighlight(table, column);
        if (isSelected && isRollover) {
            isSelected = false;
        }
        Component c = this._baseRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (isRollover) {
            this._setColHeaderRolloverHighlight((JComponent)c);
        }
        return c;
    }

    private boolean _isColHeaderRolloverHighlight(JTable table, int col) {
        JTableHeader header;
        if (table != null && table.isEnabled() && (header = table.getTableHeader()) != null && header.isEnabled()) {
            Integer rCol = (Integer)header.getClientProperty("ROLLOVER_COLUMN");
            rCol = rCol == null ? -1 : rCol;
            return rCol == col;
        }
        return false;
    }

    private void _setColHeaderRolloverHighlight(JComponent c) {
        c.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Colors.FLAT_EDITOR_BORDER), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 3, 0, RolloverTableHandler.getHeaderRolloverHighlight()), BorderFactory.createEmptyBorder(2, 6, 0, 6))));
    }
}

