/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.search;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import oracle.javatools.ui.search.PromptedTextField;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchFieldUI;
import oracle.javatools.ui.search.SearchProgress;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;

final class ThemedSearchFieldUI
extends SearchFieldUI {
    private static final Insets BORDER_INSETS = new Insets(2, 5, 2, 8);
    private static final Border _TEXTFIELD_BORDER = new EmptyBorder(0, 9, 0, 2);
    private static final Border _TEXTFIELD_BORDER_NO_MENU = new EmptyBorder(0, 0, 0, 7);

    public static ComponentUI createUI(JComponent c) {
        return new ThemedSearchFieldUI();
    }

    @Override
    public JPanel createSearchPanel() {
        JPanel panel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                SearchProgress progress = ThemedSearchFieldUI.this.getSearchField().getSearchProgress();
                int height = this.getHeight();
                int width = this.getWidth();
                Insets inset = this.getInsets();
                ThemeProperties properties = Themes.getActiveTheme().getStateProperties("searchfield.center", "default");
                Painter painter = properties.getPainter("bg");
                painter.paint(g, 7, 0, width - 14, height);
                if (ThemedSearchFieldUI.this.getSearchField().getSearchButton().isEnabled()) {
                    properties = Themes.getActiveTheme().getStateProperties("searchfield.searchmenu", ThemedSearchFieldUI.this.getSearchField().getSearchButton().getModel().isRollover() ? "active" : "default");
                    painter = properties.getPainter("bg");
                    painter.paint(g, 0, 0, width, height);
                } else {
                    properties = Themes.getActiveTheme().getStateProperties("searchfield.edge1", "default");
                    painter = properties.getPainter("bg");
                    painter.paint(g, 0, 0, width, height);
                }
                properties = Themes.getActiveTheme().getStateProperties("searchfield.edge2", "default");
                painter = properties.getPainter("bg");
                painter.paint(g, 0, 0, width, height);
                if (progress != null) {
                    if (progress.isDeterminate()) {
                        int leftInset;
                        int x = leftInset = ThemedSearchFieldUI.this.getSearchField().getSearchButton().isEnabled() ? inset.left + 20 : 0;
                        int availWidth = width - ThemedSearchFieldUI.this.getSearchField().getNextButton().getWidth() - leftInset - inset.right;
                        double pctComplete = (double)progress.getProgress() / (double)progress.getTotalSteps();
                        int progressBarWidth = Math.max(15, (int)((double)availWidth * pctComplete));
                        properties = Themes.getActiveTheme().getStateProperties("searchfield.progress.edge1", "determinate");
                        painter = properties.getPainter("bg");
                        painter.paint(g, x, Math.max(inset.top, (this.getHeight() - inset.top - inset.bottom - 15) / 2), progressBarWidth, 15);
                        properties = Themes.getActiveTheme().getStateProperties("searchfield.progress.center", "determinate");
                        painter = properties.getPainter("bg");
                        painter.paint(g, x + 7, Math.max(inset.top, (this.getHeight() - inset.top - inset.bottom - 15) / 2), progressBarWidth - 14, 15);
                        properties = Themes.getActiveTheme().getStateProperties("searchfield.progress.edge2", "determinate");
                        painter = properties.getPainter("bg");
                        painter.paint(g, x, Math.max(inset.top, (this.getHeight() - inset.top - inset.bottom - 15) / 2), progressBarWidth, 15);
                    } else {
                        Composite cc = ((Graphics2D)g).getComposite();
                        int y = Math.max(0, (this.getHeight() - inset.top - inset.bottom - 14) / 2);
                        float indeterValue = ThemedSearchFieldUI.this.getSearchField().getIndeterminateValue();
                        if (indeterValue >= 0.0f) {
                            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 1.0f - indeterValue));
                            int w = Math.max(40, this.getWidth() / 6);
                            int leftInset = ThemedSearchFieldUI.this.getSearchField().getSearchButton().isEnabled() ? 20 : 12;
                            int availWidth = width - ThemedSearchFieldUI.this.getSearchField().getNextButton().getWidth() - inset.left - inset.right - leftInset - w;
                            int x = (int)((float)availWidth * indeterValue);
                            x = x + inset.left + leftInset;
                            properties = Themes.getActiveTheme().getStateProperties("searchfield.progress.edge1", "indeterminate");
                            painter = properties.getPainter("bg");
                            painter.paint(g, x, y, w, 14);
                            properties = Themes.getActiveTheme().getStateProperties("searchfield.progress.center", "indeterminate");
                            painter = properties.getPainter("bg");
                            painter.paint(g, x + 5, y, w - 10, 14);
                            properties = Themes.getActiveTheme().getStateProperties("searchfield.progress.edge2", "indeterminate");
                            painter = properties.getPainter("bg");
                            painter.paint(g, x, y, w, 14);
                            ((Graphics2D)g).setComposite(cc);
                        }
                    }
                }
                super.paintComponent(g);
            }
        };
        panel.setBorder(new EmptyBorder(BORDER_INSETS));
        panel.setOpaque(false);
        return panel;
    }

    @Override
    public void configureTextField(PromptedTextField field) {
        field.setPromptForeground(new Color(130, 130, 130));
        field.setBorder(_TEXTFIELD_BORDER);
        field.setOpaque(false);
    }

    @Override
    public void configureSearchButton(final JButton button) {
        button.setRolloverEnabled(true);
        button.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ThemedSearchFieldUI.this.getSearchField().getSearchPanel().repaint();
            }
        });
        button.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pe) {
                if (button.isEnabled()) {
                    ThemedSearchFieldUI.this.getSearchField().getTextField().setBorder(_TEXTFIELD_BORDER);
                } else {
                    ThemedSearchFieldUI.this.getSearchField().getTextField().setBorder(_TEXTFIELD_BORDER_NO_MENU);
                }
            }
        });
    }

    @Override
    public Icon getCancelIcon(boolean enabled) {
        ThemeProperties prop = Themes.getActiveTheme().getStateProperties("searchfield.cancel", enabled ? "active" : "default");
        return prop.getIcon("icon");
    }

    @Override
    public Icon getPreviousIcon(boolean enabled) {
        ThemeProperties prop = Themes.getActiveTheme().getStateProperties("searchfield.previous", enabled ? "active" : "default");
        return prop.getIcon("icon");
    }

    @Override
    public Icon getFindNextIcon(boolean enabled) {
        ThemeProperties prop = Themes.getActiveTheme().getStateProperties("searchfield.next", enabled ? "active" : "default");
        return prop.getIcon("icon");
    }

    @Override
    public Icon getSearchIcon(Icon baseIcon, boolean enabled) {
        ThemeProperties prop = Themes.getActiveTheme().getStateProperties("searchfield.search", "menu");
        Icon enabledIcon = prop.getIcon("icon");
        return new PopupIndicator(enabledIcon, baseIcon);
    }

    @Override
    public Icon getSearchPopupIcon() {
        ThemeProperties prop = Themes.getActiveTheme().getStateProperties("searchfield.search", "nomenu");
        return prop.getIcon("icon");
    }

    @Override
    public Icon getSearchDefaultIcon() {
        return null;
    }

    @Override
    public Icon getSearchingIcon() {
        ThemeProperties prop = Themes.getActiveTheme().getStateProperties("searchfield.search", "default");
        return prop.getIcon("icon");
    }

    @Override
    public Icon getSearchHaveTextIcon() {
        ThemeProperties prop = Themes.getActiveTheme().getStateProperties("searchfield.search", "active");
        return prop.getIcon("icon");
    }

    @Override
    public Border getPreviousBorder() {
        if (this.getSearchField().getStyle() == SearchField.Style.FIND) {
            return BorderFactory.createEmptyBorder(0, 2, 0, 2);
        }
        return null;
    }

    @Override
    public Border getNextBorder() {
        if (this.getSearchField().getStyle() == SearchField.Style.FIND) {
            return BorderFactory.createEmptyBorder(0, 3, 0, 3);
        }
        return null;
    }

    private static final class PopupIndicator
    implements Icon {
        private final Icon _baseIcon;
        private final Icon _disabledIcon;

        public PopupIndicator(Icon baseIcon, Icon disabledIcon) {
            this._baseIcon = baseIcon;
            this._disabledIcon = disabledIcon;
        }

        @Override
        public int getIconHeight() {
            return Math.max(this._baseIcon.getIconHeight(), this._disabledIcon.getIconHeight());
        }

        @Override
        public int getIconWidth() {
            return Math.max(this._baseIcon.getIconWidth(), this._disabledIcon.getIconWidth());
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c.isEnabled()) {
                this._baseIcon.paintIcon(c, g, x, y);
            } else {
                this._disabledIcon.paintIcon(c, g, x, y);
            }
        }
    }
}

