/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EmptyBorder;

public final class SearchFieldBorder
extends AbstractBorder {
    private Color _foreground = UIManager.getColor("TextArea.foreground");
    private Color _background = UIManager.getColor("TextArea.background");
    private static final Insets BORDER_INSETS = new Insets(2, 8, 2, 8);

    public void setForeground(Color foreground) {
        if (foreground == null) {
            throw new NullPointerException("foreground is null");
        }
        this._foreground = foreground;
    }

    public Color getForeground() {
        return this._foreground;
    }

    public void setBackground(Color background) {
        if (background == null) {
            throw new NullPointerException("background is null");
        }
        this._background = background;
    }

    public Color getBackground() {
        return this._background;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        Object oldAAValue = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Color oldColor = g2d.getColor();
        Shape oldClip = g2d.getClip();
        try {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GeneralPath areaPath = new GeneralPath();
            areaPath.append(new Arc2D.Double(x, y, SearchFieldBorder.BORDER_INSETS.left * 2 - 1, height - 1, 90.0, 180.0, 0), true);
            areaPath.lineTo(x + width - SearchFieldBorder.BORDER_INSETS.right - 2, y + height - 1);
            areaPath.append(new Arc2D.Double(x + width - SearchFieldBorder.BORDER_INSETS.right * 2 - 1, y, SearchFieldBorder.BORDER_INSETS.right * 2 - 1, height - 1, 270.0, 180.0, 0), true);
            areaPath.lineTo(x + SearchFieldBorder.BORDER_INSETS.left, y);
            Rectangle rect = new Rectangle(x, y, width, height);
            Area area = new Area(rect);
            area.subtract(new Area(new Rectangle(x + SearchFieldBorder.BORDER_INSETS.left, y + SearchFieldBorder.BORDER_INSETS.top, x + width - SearchFieldBorder.BORDER_INSETS.left - SearchFieldBorder.BORDER_INSETS.right, y + height - SearchFieldBorder.BORDER_INSETS.top - SearchFieldBorder.BORDER_INSETS.bottom)));
            g2d.setClip(area);
            g2d.setColor(this._background);
            g2d.fill(areaPath);
            g2d.setColor(this._foreground);
            g2d.draw(areaPath);
        }
        finally {
            g2d.setColor(oldColor);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAAValue);
            g2d.setClip(oldClip);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return BORDER_INSETS;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = SearchFieldBorder.BORDER_INSETS.top;
        insets.left = SearchFieldBorder.BORDER_INSETS.left;
        insets.right = SearchFieldBorder.BORDER_INSETS.right;
        insets.bottom = SearchFieldBorder.BORDER_INSETS.bottom;
        return BORDER_INSETS;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        JPanel p = new JPanel();
        p.setBorder(new SearchFieldBorder());
        p.setLayout(new BorderLayout());
        JTextField field = new JTextField();
        field.setBorder(null);
        p.add((Component)field, "Center");
        JPanel o = new JPanel();
        o.setBorder(new EmptyBorder(10, 10, 10, 10));
        o.setLayout(new BorderLayout());
        o.add((Component)p, "Center");
        f.setDefaultCloseOperation(2);
        f.setContentPane(o);
        f.pack();
        f.setVisible(true);
    }
}

