/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.search;

import java.util.EventObject;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchProgress;

public final class SearchEvent
extends EventObject {
    private final String _searchText;
    private final transient SearchCategory _searchCategory;
    private final transient SearchProgress _searchProgress;
    private final Direction _direction;
    private final boolean _isFromKeypress;
    private final boolean _isFromClear;

    SearchEvent(Object source, String searchText, SearchCategory searchCategory, SearchProgress searchProgress, Direction direction, boolean keypress) {
        super(source);
        if (searchText == null) {
            searchText = "";
        }
        this._searchText = searchText;
        this._searchCategory = searchCategory;
        this._searchProgress = searchProgress;
        this._direction = direction;
        this._isFromKeypress = keypress;
        this._isFromClear = false;
    }

    SearchEvent(Object source, String textBeforeClear, boolean isFromClear) {
        super(source);
        if (textBeforeClear == null) {
            textBeforeClear = "";
        }
        this._searchText = textBeforeClear;
        this._searchCategory = null;
        this._searchProgress = null;
        this._direction = null;
        this._isFromKeypress = false;
        this._isFromClear = isFromClear;
    }

    public boolean isTriggeredByKeypress() {
        return this._isFromKeypress;
    }

    public boolean isFromClear() {
        return this._isFromClear;
    }

    public String getSearchText() {
        return this._searchText;
    }

    public SearchCategory getSearchCategory() {
        return this._searchCategory;
    }

    public SearchProgress getSearchProgress() {
        if (this._searchProgress == null) {
            SearchField sf = (SearchField)this.getSource();
            throw new IllegalStateException("Cannot call getSearchProgress() on event fired from search field in style " + (Object)((Object)sf.getStyle()));
        }
        return this._searchProgress;
    }

    public Direction getDirection() {
        return this._direction;
    }

    @Override
    public String toString() {
        return String.format("%s [searchText=%s, searchCategory=%s, direction=%s]", new Object[]{this.getClass().getSimpleName(), this._searchText, this._searchCategory, this._direction});
    }

    public static enum Direction {
        FORWARD,
        BACKWARD;

    }
}

