/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.search;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;

final class DocumentTextFinder {
    private final List<Integer> offsetList = new ArrayList<Integer>();
    private final List<Highlight> highlightList = new ArrayList<Highlight>();
    private String lastSearchText;
    private boolean lastMatchCase;
    private boolean lastWholeWordOnly;
    private final Segment segment = new Segment();
    private Document document;
    private final HighlightService highlightService;
    private final DocumentLockService lockService;
    private final DocumentListener documentListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            DocumentTextFinder.this.insertUpdate(e.getOffset(), e.getLength());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            DocumentTextFinder.this.removeUpdate(e.getOffset(), e.getLength());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            DocumentTextFinder.this.changedUpdate(e.getOffset(), e.getLength());
        }
    };
    private static final DocumentLockService NULL_LOCK_SERVICE = new DocumentLockService(){};
    private static final HighlightService NULL_HIGHLIGHT_SERVICE = new HighlightService(){

        @Override
        public Highlight highlight(int start, int end) {
            return null;
        }

        @Override
        public void removeHighlight(Highlight highlight) {
        }

        @Override
        public void removeAllHighlights() {
        }
    };

    public DocumentTextFinder() {
        this(NULL_HIGHLIGHT_SERVICE, NULL_LOCK_SERVICE);
    }

    public DocumentTextFinder(HighlightService highlightService, DocumentLockService lockService) {
        if (highlightService == null) {
            throw new NullPointerException("highlightService is null");
        }
        this.highlightService = highlightService;
        this.lockService = lockService;
    }

    public DocumentTextFinder(HighlightService highlightService) {
        this(highlightService, NULL_LOCK_SERVICE);
    }

    private void insertUpdate(int offset, int count) {
        if (this.lastSearchText != null) {
            Document document = this.getDocument();
            int searchLen = this.lastSearchText.length();
            int startAffected = Math.max(0, offset - searchLen);
            int endAffected = offset;
            int listSize = this.offsetList.size();
            int removeStart = -1;
            int removeEnd = -1;
            boolean SEARCH_FOR_START = false;
            boolean SEARCH_FOR_END = true;
            int UPDATE_OFFSETS = 2;
            int state = 0;
            block5: for (int i = 0; i < listSize; ++i) {
                int highlightOffset = this.offsetList.get(i);
                switch (state) {
                    case 0: {
                        if (highlightOffset < startAffected) continue block5;
                        removeStart = i;
                        state = 1;
                        removeEnd = listSize;
                    }
                    case 1: {
                        if (highlightOffset <= endAffected) {
                            Highlight highlightToRemove = this.highlightList.get(i);
                            this.highlightService.removeHighlight(highlightToRemove);
                            continue block5;
                        }
                        removeEnd = i;
                        state = 2;
                    }
                    case 2: {
                        this.offsetList.set(i, new Integer(highlightOffset += count));
                    }
                }
            }
            if (removeStart != removeEnd) {
                int countToRemove = removeEnd - removeStart;
                for (int i = 0; i < countToRemove; ++i) {
                    this.offsetList.remove(removeStart);
                    this.highlightList.remove(removeStart);
                }
            }
            int recomputeStart = startAffected;
            int recomputeEnd = Math.min(offset + count + searchLen, document.getLength());
            this.updateFindRegion(recomputeStart, recomputeEnd);
        }
    }

    private void removeUpdate(int offset, int count) {
        if (this.lastSearchText != null) {
            Document document = this.getDocument();
            int searchLen = this.lastSearchText.length();
            int startAffected = Math.max(0, offset - searchLen);
            int endAffected = Math.min(document.getLength(), offset + count);
            int listSize = this.offsetList.size();
            int removeStart = -1;
            int removeEnd = -1;
            boolean SEARCH_FOR_START = false;
            boolean SEARCH_FOR_END = true;
            int UPDATE_OFFSETS = 2;
            int state = 0;
            block5: for (int i = 0; i < listSize; ++i) {
                int highlightOffset = this.offsetList.get(i);
                switch (state) {
                    case 0: {
                        if (highlightOffset < startAffected) continue block5;
                        removeStart = i;
                        state = 1;
                        removeEnd = listSize;
                    }
                    case 1: {
                        if (highlightOffset <= endAffected) {
                            Highlight highlightToRemove = this.highlightList.get(i);
                            this.highlightService.removeHighlight(highlightToRemove);
                            continue block5;
                        }
                        removeEnd = i;
                        state = 2;
                    }
                    case 2: {
                        this.offsetList.set(i, new Integer(highlightOffset -= count));
                    }
                }
            }
            if (removeStart != removeEnd) {
                int countToRemove = removeEnd - removeStart;
                for (int i = 0; i < countToRemove; ++i) {
                    this.offsetList.remove(removeStart);
                    this.highlightList.remove(removeStart);
                }
            }
            int recomputeStart = startAffected;
            int recomputeEnd = Math.min(offset + searchLen, document.getLength());
            this.updateFindRegion(recomputeStart, recomputeEnd);
        }
    }

    private void changedUpdate(int start, int length) {
    }

    public final void clearHighlighting() {
        this.highlightService.removeAllHighlights();
        this.lastSearchText = null;
        this.offsetList.clear();
    }

    public final void setDocument(Document document) {
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentListener);
            this.highlightService.removeAllHighlights();
            this.highlightList.clear();
            this.offsetList.clear();
        }
        this.document = document;
        this.document.addDocumentListener(this.documentListener);
        if (this.lastSearchText != null) {
            this.updateFindRegion(0, document.getLength());
        }
    }

    public final Document getDocument() {
        return this.document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performHighlighting(String text, boolean matchCase, boolean wholeWordOnly) {
        if (text == null) {
            return;
        }
        if (this.getDocument() == null) {
            return;
        }
        this.lastSearchText = text;
        this.lastMatchCase = matchCase;
        this.lastWholeWordOnly = wholeWordOnly;
        try {
            this.lockService.readLock();
            this.updateFindRegion(0, this.getDocument().getLength());
        }
        finally {
            this.lockService.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFindRegion(int startOffset, int endOffset) {
        if (this.lastSearchText == null) {
            return;
        }
        int insertPoint = this.offsetList.size();
        for (int i = 0; i < this.offsetList.size(); ++i) {
            int higlightOffset = this.offsetList.get(i);
            if (higlightOffset <= startOffset) continue;
            insertPoint = i;
            break;
        }
        int searchLen = this.lastSearchText.length();
        this.highlightService.beginHighlighting();
        try {
            int currentOffset = startOffset;
            while (currentOffset < endOffset) {
                int foundOffset = this.findTextInternal(this.lastSearchText, currentOffset, true, this.lastMatchCase, this.lastWholeWordOnly, endOffset);
                if (foundOffset == -1) {
                    break;
                }
                Highlight highlight = this.highlightService.highlight(foundOffset, foundOffset + searchLen);
                int ip = insertPoint++;
                this.offsetList.add(ip, foundOffset);
                this.highlightList.add(ip, highlight);
                currentOffset = foundOffset + 1;
            }
        }
        finally {
            this.highlightService.endHighlighting();
        }
    }

    public final int findText(String text, int startOffset, boolean forward, boolean matchCase, boolean wrap, boolean wholeWordOnly, boolean highlight) {
        if (this.document == null) {
            throw new IllegalStateException("No document set");
        }
        if (highlight) {
            return this.highlightMatches(text, matchCase, wholeWordOnly, forward, wrap);
        }
        this.clearHighlighting();
        Document document = this.getDocument();
        int foundOffset = this.findTextInternal(text, forward ? startOffset : 0, forward, matchCase, wholeWordOnly, forward ? document.getLength() : startOffset);
        if (wrap && foundOffset == -1) {
            foundOffset = this.findTextInternal(text, forward ? 0 : startOffset, forward, matchCase, wholeWordOnly, forward ? startOffset : document.getLength());
        }
        return foundOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findTextInternal(String text, int startOffset, boolean forward, boolean matchCase, boolean wholeWordOnly, int endOffset) {
        try {
            int foundOffset;
            this.lockService.readLock();
            Document document = this.getDocument();
            while (true) {
                foundOffset = -1;
                foundOffset = matchCase ? (forward ? this.searchForwardMatch(text, document, startOffset, endOffset) : this.searchBackwardMatch(text, document, startOffset, endOffset)) : (forward ? this.searchForwardNoMatch(text, document, startOffset, endOffset) : this.searchBackwardNoMatch(text, document, startOffset, endOffset));
                if (foundOffset == -1 || !wholeWordOnly || this.isWholeWordMatch(document, foundOffset, text.length())) break;
                if (forward) {
                    startOffset = foundOffset + 1;
                    continue;
                }
                endOffset = foundOffset - 1;
            }
            int n = foundOffset;
            return n;
        }
        finally {
            this.lockService.readUnlock();
        }
    }

    private boolean isWholeWordMatch(Document document, int startOffset, int length) {
        return false;
    }

    private char getChar(Document doc, int index) {
        try {
            doc.getText(index, 1, this.segment);
            return this.segment.array[0];
        }
        catch (BadLocationException ble) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    private int searchForwardMatch(String searchText, Document doc, int startOffset, int endOffset) {
        int searchLength = searchText.length();
        int lastOffset = endOffset - searchLength;
        block0: for (int currentOffset = startOffset; currentOffset <= lastOffset; ++currentOffset) {
            int stringOffset = 0;
            int textOffset = currentOffset;
            int lastTextOffset = currentOffset + searchLength;
            while (textOffset < lastTextOffset) {
                char s;
                char t;
                if ((t = this.getChar(doc, textOffset++)) == (s = searchText.charAt(stringOffset++))) continue;
                continue block0;
            }
            return currentOffset;
        }
        return -1;
    }

    private int searchBackwardMatch(String searchText, Document doc, int startOffset, int endOffset) {
        int searchLength = searchText.length();
        block0: for (int currentOffset = endOffset - searchLength; currentOffset >= startOffset; --currentOffset) {
            int stringOffset = 0;
            int textOffset = currentOffset;
            int lastTextOffset = currentOffset + searchLength;
            while (textOffset < lastTextOffset) {
                char s;
                char t;
                if ((t = this.getChar(doc, textOffset++)) == (s = searchText.charAt(stringOffset++))) continue;
                continue block0;
            }
            return currentOffset;
        }
        return -1;
    }

    private int searchForwardNoMatch(String searchText, Document doc, int startOffset, int endOffset) {
        int searchLength = searchText.length();
        int lastOffset = endOffset - searchLength;
        block0: for (int currentOffset = startOffset; currentOffset <= lastOffset; ++currentOffset) {
            int stringOffset = 0;
            int textOffset = currentOffset;
            int lastTextOffset = currentOffset + searchLength;
            while (textOffset < lastTextOffset) {
                char s2;
                char t2;
                char s1;
                char t1;
                char s;
                char t;
                if ((t = this.getChar(doc, textOffset++)) == (s = searchText.charAt(stringOffset++)) || (t1 = Character.toUpperCase(t)) == (s1 = Character.toUpperCase(s)) || (t2 = Character.toLowerCase(t1)) == (s2 = Character.toLowerCase(s1))) continue;
                continue block0;
            }
            return currentOffset;
        }
        return -1;
    }

    private int searchBackwardNoMatch(String searchText, Document doc, int startOffset, int endOffset) {
        int searchLength = searchText.length();
        block0: for (int currentOffset = endOffset - searchLength; currentOffset >= startOffset; --currentOffset) {
            int stringOffset = 0;
            int textOffset = currentOffset;
            int lastTextOffset = currentOffset + searchLength;
            while (textOffset < lastTextOffset) {
                char s2;
                char t2;
                char s1;
                char t1;
                char s;
                char t;
                if ((t = this.getChar(doc, textOffset++)) == (s = searchText.charAt(stringOffset++)) || (t1 = Character.toUpperCase(t)) == (s1 = Character.toUpperCase(s)) || (t2 = Character.toLowerCase(t1)) == (s2 = Character.toLowerCase(s1))) continue;
                continue block0;
            }
            return currentOffset;
        }
        return -1;
    }

    private int highlightMatches(String text, boolean matchCase, boolean wholeWordOnly, boolean forward, boolean wrap) {
        int highlightOffset;
        if (this.sameAsLastSearch(text, matchCase, wholeWordOnly)) {
            this.clearHighlighting();
            this.performHighlighting(text, matchCase, wholeWordOnly);
        }
        int foundOffset = -1;
        int listSize = this.offsetList.size();
        int start = forward ? 0 : listSize - 1;
        int step = forward ? 1 : -1;
        int textLength = text.length();
        int i = start;
        while (forward ? i < listSize : i >= 0) {
            highlightOffset = this.offsetList.get(i);
            if (forward ? highlightOffset >= start : highlightOffset + textLength <= start) {
                foundOffset = highlightOffset;
                break;
            }
            i += step;
        }
        if (wrap && foundOffset == -1) {
            i = start;
            while (forward ? i < listSize : i >= 0) {
                highlightOffset = this.offsetList.get(i);
                if (forward ? highlightOffset < start : highlightOffset + textLength > start) {
                    foundOffset = highlightOffset;
                    break;
                }
                i += step;
            }
        }
        return foundOffset;
    }

    private boolean sameAsLastSearch(String text, boolean matchCase, boolean wholeWordOnly) {
        return this.lastSearchText != null && text.equals(this.lastSearchText) && matchCase == this.lastMatchCase && wholeWordOnly == this.lastWholeWordOnly;
    }

    public static abstract class DocumentLockService {
        public void readLock() {
        }

        public void readUnlock() {
        }
    }

    public static interface Highlight {
    }

    public static abstract class HighlightService {
        public void beginHighlighting() {
        }

        public void endHighlighting() {
        }

        public abstract Highlight highlight(int var1, int var2);

        public abstract void removeHighlight(Highlight var1);

        public abstract void removeAllHighlights();
    }
}

