/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.popup;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.javatools.ui.GraphicsUtils;
import oracle.javatools.ui.popup.PopupWindow;
import oracle.javatools.ui.popup.TransparentWindow;

public class PopupWindowManager {
    private ParentListener parentListener = new ParentListener();
    private JComponent parentComponent;
    private FocusL focusL = new FocusL();
    private final List<PopupWindow> popupWindows = new CopyOnWriteArrayList<PopupWindow>();
    public static final int WEST = 1;
    public static final int EAST = 2;
    public static final int NORTH = 4;
    public static final int SOUTH = 8;
    private static final String PWM_KEY = "**PWM_KEY**";
    private static final int SPACING = 5;
    private int[] LOCATION_COUNT = new int[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PopupWindowManager getPopupWindowManager(JComponent parentComponent) {
        String string = PWM_KEY;
        synchronized (PWM_KEY) {
            PopupWindowManager pwm = (PopupWindowManager)parentComponent.getClientProperty(PWM_KEY);
            if (pwm == null) {
                pwm = new PopupWindowManager(parentComponent);
                parentComponent.putClientProperty(PWM_KEY, pwm);
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return pwm;
        }
    }

    private PopupWindowManager(JComponent parentComponent) {
        this.parentComponent = parentComponent;
        parentComponent.addFocusListener(this.focusL);
        parentComponent.addAncestorListener(this.parentListener);
        parentComponent.addMouseWheelListener(this.parentListener);
    }

    private JComponent getParentComponent() {
        return this.parentComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose() {
        if (this.parentComponent == null) {
            return;
        }
        Window parentWindow = SwingUtilities.getWindowAncestor(this.parentComponent);
        if (parentWindow != null) {
            parentWindow.removeWindowFocusListener(this.parentListener);
        }
        this.parentComponent.removeAncestorListener(this.parentListener);
        this.parentComponent.removeMouseWheelListener(this.parentListener);
        this.parentComponent.removeFocusListener(this.focusL);
        List<PopupWindow> popups = PopupWindowManager.getPopupWindows(this.parentComponent);
        for (int i = popups.size() - 1; i >= 0; --i) {
            PopupWindowManager.dismissPopup(popups.get(i));
        }
        String string = PWM_KEY;
        synchronized (PWM_KEY) {
            this.parentComponent.putClientProperty(PWM_KEY, null);
            // ** MonitorExit[var3_4] (shouldn't be in output)
            this.parentComponent = null;
            return;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public static PopupWindow showPopup(JComponent parentComponent, JComponent content, boolean focusable, Rectangle relativeToLocation, int[] preferredLocations, boolean center) {
        assert (SwingUtilities.isEventDispatchThread());
        Window parentWindow = SwingUtilities.getWindowAncestor(parentComponent);
        TransparentWindow window = new TransparentWindow(parentWindow);
        GraphicsUtils.setWindowOpacity(window, 0.96f);
        Dimension contentSize = content.getPreferredSize();
        window.getContentPane().add(content);
        window.setSize(contentSize);
        window.validate();
        PopupWindowManager pwm = PopupWindowManager.getPopupWindowManager(parentComponent);
        PopupWindow popup = new PopupWindow(content, window, pwm);
        window.setFocusableWindowState(focusable);
        pwm.positionPopup(popup, relativeToLocation, preferredLocations, center);
        popup.setVisible(true);
        pwm.show(popup);
        return popup;
    }

    private void show(PopupWindow popup) {
        this.popupWindows.add(popup);
        popup.getWindow().setVisible(true);
        Window parentWindow = SwingUtilities.getWindowAncestor(this.parentComponent);
        parentWindow.addWindowFocusListener(this.parentListener);
        this.transferFocusToComponent();
    }

    private void positionPopup(PopupWindow popupWindow, Rectangle relativeToLocation, int[] preferredLocations, boolean center) {
        Rectangle absoluteLocation = this.convertToAbsolute(relativeToLocation);
        Point absolutePoint = new Point(absoluteLocation.x, absoluteLocation.y);
        Object[] screenInfo = this.getScreenInfo(absolutePoint);
        Rectangle screenBounds = (Rectangle)screenInfo[0];
        Insets screenInsets = (Insets)screenInfo[2];
        screenInsets.top += 5;
        screenInsets.left += 5;
        screenInsets.right += 5;
        screenInsets.bottom += 5;
        absoluteLocation = this.ensureOnScreen(screenBounds, screenInsets, absoluteLocation);
        JWindow window = popupWindow.getWindow();
        Dimension viewSize = new Dimension(window.getWidth(), window.getHeight());
        int[] availableLocations = this.getAvailableLocations(screenBounds, screenInsets, viewSize, absoluteLocation, preferredLocations);
        int locationToUse = availableLocations[0];
        Point viewPosition = this.calculateLocation(screenBounds, screenInsets, absoluteLocation, viewSize, locationToUse, center);
        PopupWindow currentPopup = popupWindow.isVisible() ? popupWindow : null;
        Point adjustedPosition = this.adjustForCollisions(currentPopup, screenBounds, screenInsets, viewPosition, viewSize, locationToUse);
        window.setLocation(adjustedPosition);
    }

    public static void dismissPopup(PopupWindow popup) {
        assert (SwingUtilities.isEventDispatchThread());
        PopupWindowManager manager = popup.getManager();
        manager.dismiss(popup);
    }

    private void dismiss(PopupWindow popup) {
        this.popupWindows.remove(popup);
        popup.close();
        if (this.popupWindows.isEmpty()) {
            this.dispose();
        }
    }

    private int[] getAvailableLocations(Rectangle screenBounds, Insets screenInsets, Dimension viewSize, Rectangle locationRect, int[] preferredLocations) {
        boolean nothingAvailable;
        int available = 0;
        int requested = 0;
        int numRequested = preferredLocations.length;
        for (int i = 0; i < numRequested; ++i) {
            requested |= preferredLocations[i];
        }
        if ((requested & 0xC) != 0) {
            int locationBottom;
            int usableSpaceBelow;
            int viewHeight = viewSize.height;
            nothingAvailable = true;
            int screenTop = screenBounds.y + screenInsets.top;
            int screenBottom = screenBounds.y + screenBounds.height - screenInsets.bottom;
            int usableSpaceAbove = locationRect.y - screenTop - viewHeight;
            if (usableSpaceAbove >= 0) {
                available |= 4;
                nothingAvailable = false;
            }
            if ((usableSpaceBelow = screenBottom - (locationBottom = locationRect.y + locationRect.height) - viewHeight) >= 0) {
                available |= 8;
                nothingAvailable = false;
            }
            if (nothingAvailable) {
                available |= usableSpaceBelow > usableSpaceAbove ? 4 : 8;
            }
        }
        if ((requested & 3) != 0) {
            int locationRight;
            int usableSpaceRight;
            int viewWidth = viewSize.width;
            nothingAvailable = true;
            int screenLeft = screenBounds.x + screenInsets.left;
            int screenRight = screenBounds.x + screenBounds.width - screenInsets.right;
            int usableSpaceLeft = locationRect.x - screenLeft - viewWidth;
            if (usableSpaceLeft >= 0) {
                available |= 1;
                nothingAvailable = false;
            }
            if ((usableSpaceRight = screenRight - (locationRight = locationRect.x + locationRect.width) - viewWidth) >= 0) {
                available |= 2;
                nothingAvailable = false;
            }
            if (nothingAvailable) {
                available |= usableSpaceRight > usableSpaceLeft ? 2 : 1;
            }
        }
        int numAvailable = this.LOCATION_COUNT[available];
        int availIndex = 0;
        int[] availableLocations = new int[numAvailable];
        for (int i = 0; i < numRequested; ++i) {
            if ((preferredLocations[i] & available) == 0) continue;
            availableLocations[availIndex++] = preferredLocations[i];
        }
        return availableLocations;
    }

    public static List<PopupWindow> getPopupWindows(JComponent parent) {
        if (parent == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(PopupWindowManager.getPopupWindowManager((JComponent)parent).popupWindows);
    }

    private Point adjustForCollisions(PopupWindow currentPopup, Rectangle screenBounds, Insets screenInsets, Point viewPosition, Dimension viewSize, int locationUsed) {
        Rectangle currentRectangle = new Rectangle(viewPosition, viewSize);
        List<PopupWindow> allPopups = PopupWindowManager.getPopupWindows(this.parentComponent);
        List<PopupWindow> regionPopups = this.findPopupsInRegion(currentPopup, currentRectangle, locationUsed, allPopups);
        List<PopupWindow> collidingPopups = this.findCollidingPopups(currentRectangle, regionPopups);
        if (!collidingPopups.isEmpty()) {
            int size = collidingPopups.size();
            ArrayList<PopupWindow> attemptPopups = new ArrayList<PopupWindow>();
            for (int i = 0; i < size; ++i) {
                attemptPopups.add(collidingPopups.get(i));
                Rectangle collidingRect = this.getPopupSpace(attemptPopups);
                Point attemptPoint = this.avoidCollision(collidingRect, screenBounds, screenInsets, viewPosition, viewSize, locationUsed);
                if (attemptPoint == null) break;
                Rectangle attemptRect = new Rectangle(attemptPoint, viewSize);
                if (this.findCollidingPopups(attemptRect, regionPopups).size() != 0) continue;
                return attemptPoint;
            }
        }
        return viewPosition;
    }

    private Point avoidCollision(Rectangle collidingRect, Rectangle screenBounds, Insets screenInsets, Point viewPosition, Dimension viewSize, int locationUsed) {
        int[] checks;
        int screenLeft = screenBounds.x + screenInsets.left;
        int screenTop = screenBounds.y + screenInsets.top;
        int screenRight = screenBounds.x + screenBounds.width - screenInsets.right;
        int screenBottom = screenBounds.y + screenBounds.height - screenInsets.bottom;
        int spaceAbove = collidingRect.y - screenTop - 5;
        int spaceBelow = screenBottom - (collidingRect.y + collidingRect.height) - 5;
        int spaceLeft = collidingRect.x - screenLeft - 5;
        int spaceRight = screenRight - (collidingRect.x + collidingRect.width) - 5;
        int viewWidth = viewSize.width;
        int viewHeight = viewSize.height;
        switch (locationUsed) {
            case 4: {
                checks = new int[]{2, 1, 4};
                break;
            }
            case 8: {
                checks = new int[]{2, 1, 8};
                break;
            }
            case 1: {
                checks = new int[]{4, 8, 1};
                break;
            }
            case 2: {
                checks = new int[]{4, 8, 2};
                break;
            }
            default: {
                throw new IllegalStateException("unknown loc: " + locationUsed);
            }
        }
        block12: for (int dir : checks) {
            switch (dir) {
                case 4: {
                    if (spaceAbove <= viewHeight) continue block12;
                    int yPos = collidingRect.y - viewHeight - 1;
                    return new Point(viewPosition.x, yPos);
                }
                case 8: {
                    if (spaceBelow <= viewHeight) continue block12;
                    int yPos = collidingRect.y + collidingRect.height + 1;
                    return new Point(viewPosition.x, yPos);
                }
                case 1: {
                    if (spaceLeft <= viewWidth) continue block12;
                    int xPos = collidingRect.x - viewWidth - 1;
                    return new Point(xPos, viewPosition.y);
                }
                case 2: {
                    if (spaceRight <= viewWidth) continue block12;
                    int xPos = collidingRect.x + collidingRect.width + 1;
                    return new Point(xPos, viewPosition.y);
                }
            }
        }
        return null;
    }

    private Rectangle getPopupSpace(List<PopupWindow> popups) {
        Rectangle unionRect = null;
        for (PopupWindow checkPopup : popups) {
            JWindow checkWindow = checkPopup.getWindow();
            unionRect = unionRect == null ? checkWindow.getBounds() : unionRect.union(checkWindow.getBounds());
        }
        if (unionRect != null) {
            this.addPadding(unionRect);
        }
        return unionRect;
    }

    private void addPadding(Rectangle rect) {
        rect.x -= 5;
        rect.y -= 5;
        rect.width += 10;
        rect.height += 10;
    }

    private List<PopupWindow> findCollidingPopups(Rectangle currentRect, List<PopupWindow> regionPopups) {
        Rectangle checkRect = new Rectangle();
        ArrayList<PopupWindow> regionList = new ArrayList<PopupWindow>();
        for (PopupWindow checkPopup : regionPopups) {
            JWindow checkWindow = checkPopup.getWindow();
            checkWindow.getBounds(checkRect);
            this.addPadding(checkRect);
            if (!checkRect.intersects(currentRect)) continue;
            regionList.add(checkPopup);
        }
        return regionList;
    }

    private List<PopupWindow> findPopupsInRegion(PopupWindow currentPopup, Rectangle currentRect, int locationUsed, List<PopupWindow> allPopups) {
        Rectangle checkRect = new Rectangle();
        ArrayList<PopupWindow> regionList = new ArrayList<PopupWindow>();
        for (PopupWindow checkPopup : allPopups) {
            if (checkPopup == currentPopup) continue;
            JWindow checkWindow = checkPopup.getWindow();
            checkWindow.getBounds(checkRect);
            boolean inRegion = false;
            switch (locationUsed) {
                case 4: {
                    int currentBottom = currentRect.y + currentRect.height;
                    if (checkRect.y >= currentBottom) break;
                    inRegion = true;
                    break;
                }
                case 8: {
                    int checkBottom = checkRect.y + checkRect.height;
                    if (currentRect.y >= checkBottom) break;
                    inRegion = true;
                    break;
                }
                case 2: {
                    int checkRight = checkRect.x + checkRect.width;
                    if (currentRect.x >= checkRight) break;
                    inRegion = true;
                    break;
                }
                case 1: {
                    int currentRight = currentRect.x + currentRect.width;
                    if (checkRect.x >= currentRight) break;
                    inRegion = true;
                }
            }
            if (!inRegion) continue;
            regionList.add(checkPopup);
        }
        return regionList;
    }

    private int adjustXForParent(int xPos, int width) {
        Point parentOrigin = this.getParentComponent().getLocationOnScreen();
        int parentX = parentOrigin.x;
        Rectangle parentRect = this.getParentComponent().getVisibleRect();
        int parentWidth = parentRect.width;
        int parentViewX = parentRect.x;
        int parentLeftEdgeX = parentX + parentViewX;
        int parentRightEdgeX = parentLeftEdgeX + parentWidth;
        int INSET = 2;
        if (width > parentWidth - INSET * 2) {
            xPos = parentX - (width - parentWidth) / 2;
        } else if (xPos < parentLeftEdgeX + INSET) {
            xPos = parentLeftEdgeX + INSET;
        } else if (xPos + width > parentRightEdgeX - INSET) {
            xPos = parentRightEdgeX - INSET - width;
        }
        return xPos;
    }

    private int adjustYForParent(int yPos, int height) {
        Point parentOrigin = this.getParentComponent().getLocationOnScreen();
        int parentY = parentOrigin.y;
        Rectangle parentRect = this.getParentComponent().getVisibleRect();
        int parentHeight = parentRect.height;
        int parentViewY = parentRect.y;
        int parentTopEdgeY = parentY + parentViewY;
        int parentBottomEdgeY = parentY + parentViewY + parentHeight;
        int INSET = 2;
        if (height > parentHeight - INSET * 2) {
            yPos = parentY - (height - parentHeight) / 2;
        } else if (yPos < parentTopEdgeY + INSET) {
            yPos = parentTopEdgeY + INSET;
        } else if (yPos + height > parentBottomEdgeY - INSET) {
            yPos = parentBottomEdgeY - INSET - height;
        }
        return yPos;
    }

    private Point calculateLocation(Rectangle screenBounds, Insets screenInsets, Rectangle locationRect, Dimension viewSize, int locationToUse, boolean centered) {
        int yPos;
        int xPos;
        int viewHeight = viewSize.height;
        int viewWidth = viewSize.width;
        switch (locationToUse) {
            default: {
                xPos = locationRect.x;
                if (centered) {
                    xPos -= viewWidth / 2;
                }
                xPos = this.adjustXForParent(xPos, viewWidth);
                break;
            }
            case 2: {
                xPos = locationRect.x + locationRect.width + 5;
                break;
            }
            case 1: {
                xPos = locationRect.x - 5 - viewWidth;
            }
        }
        switch (locationToUse) {
            case 1: 
            case 2: {
                yPos = locationRect.y - viewHeight / 2;
                yPos = this.adjustYForParent(yPos, viewHeight);
                break;
            }
            case 4: {
                yPos = locationRect.y - viewHeight - 5;
                break;
            }
            default: {
                yPos = locationRect.y + locationRect.height + 5;
            }
        }
        Point viewPos = new Point(xPos, yPos);
        Rectangle calcRect = new Rectangle(viewPos, viewSize);
        calcRect = this.ensureOnScreen(screenBounds, screenInsets, calcRect);
        return new Point(calcRect.x, calcRect.y);
    }

    private Object[] getScreenInfo(Point parentPoint) {
        Rectangle screenBounds;
        Insets screenInsets;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration gc = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        for (int i = 0; i < gd.length; ++i) {
            GraphicsConfiguration dgc;
            if (gd[i].getType() != 0 || !(dgc = gd[i].getDefaultConfiguration()).getBounds().contains(parentPoint)) continue;
            gc = dgc;
            break;
        }
        if (gc == null) {
            JComponent component = this.getParentComponent();
            gc = component.getGraphicsConfiguration();
        }
        if (gc != null) {
            screenInsets = toolkit.getScreenInsets(gc);
            screenBounds = gc.getBounds();
        } else {
            screenInsets = new Insets(0, 0, 0, 0);
            screenBounds = new Rectangle(toolkit.getScreenSize());
        }
        Dimension screenSize = new Dimension(screenBounds.width, screenBounds.height);
        return new Object[]{screenBounds, screenSize, screenInsets};
    }

    private Rectangle ensureOnScreen(Rectangle screenBounds, Insets screenInsets, Rectangle absoluteLocation) {
        Rectangle rect = new Rectangle(absoluteLocation);
        int left = screenBounds.x + screenInsets.left;
        int top = screenBounds.y + screenInsets.top;
        int right = screenBounds.x + screenBounds.width - screenInsets.right;
        int bottom = screenBounds.y + screenBounds.height - screenInsets.bottom;
        if (rect.x < left) {
            rect.x = left;
        }
        if (rect.y < top) {
            rect.y = top;
        }
        if (rect.x + rect.width > right) {
            rect.x = right - rect.width;
        }
        if (rect.y + rect.height > bottom) {
            rect.y = bottom - rect.height;
        }
        return rect;
    }

    private Rectangle convertToAbsolute(Rectangle relativeRect) {
        Rectangle absoluteRect = new Rectangle(relativeRect);
        Point parentOrigin = this.getParentComponent().getLocationOnScreen();
        absoluteRect.x = (int)((double)absoluteRect.x + parentOrigin.getX());
        absoluteRect.y = (int)((double)absoluteRect.y + parentOrigin.getY());
        return absoluteRect;
    }

    private void transferFocusToComponent() {
        final JComponent componentToFocus = this.getParentComponent();
        Runnable focusTask = new Runnable(){

            @Override
            public void run() {
                if (componentToFocus.isShowing()) {
                    componentToFocus.requestFocus();
                }
            }
        };
        SwingUtilities.invokeLater(focusTask);
    }

    private class FocusL
    implements FocusListener {
        private FocusL() {
        }

        @Override
        public void focusGained(FocusEvent event) {
            List<PopupWindow> popups = PopupWindowManager.getPopupWindows(PopupWindowManager.this.parentComponent);
            for (int i = popups.size() - 1; i >= 0; --i) {
                popups.get(i).parentFocusGained();
            }
        }

        @Override
        public void focusLost(FocusEvent event) {
            boolean isTemporary = event.isTemporary();
            List<PopupWindow> windows = PopupWindowManager.getPopupWindows(PopupWindowManager.this.parentComponent);
            Component newFocusComp = event.getOppositeComponent();
            if (newFocusComp != null) {
                for (PopupWindow window : windows) {
                    if (window.getWindow() != newFocusComp) continue;
                    return;
                }
            }
            for (int i = windows.size() - 1; i >= 0; --i) {
                windows.get(i).parentFocusLost(isTemporary);
            }
        }
    }

    private class ParentListener
    implements AncestorListener,
    MouseWheelListener,
    WindowFocusListener {
        private ParentListener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            for (PopupWindow popup : new ArrayList(PopupWindowManager.this.popupWindows)) {
                PopupWindowManager.dismissPopup(popup);
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
            if (event.getAncestorParent() != null && event.getAncestorParent() instanceof JViewport) {
                return;
            }
            this.dismiss();
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            this.dismiss();
        }

        private void dismiss() {
            for (PopupWindow w : new ArrayList<PopupWindow>(PopupWindowManager.getPopupWindows(PopupWindowManager.this.parentComponent))) {
                PopupWindowManager.dismissPopup(w);
            }
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            this.dismiss();
        }
    }
}

