/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.internal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.bali.ewt.util.WindowUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Header;
import oracle.javatools.ui.HeaderPanel;
import oracle.javatools.ui.ResizeComponent;
import oracle.javatools.ui.TransparentPanel;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.table.EditableTableModel;
import oracle.javatools.ui.table.EmptyTableTextLayer;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTableModel;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import oracle.javatools.ui.table.TableHelper;
import oracle.javatools.ui.table.TableToolbar;

final class UICTableDemoPanel
extends JPanel {
    private static String[] defaultColumns = new String[]{"Artist", "Album", "Genre", "Year", "Length"};
    private static String[][] defaultModel = new String[][]{{"The White Stripes", "Elephant", "Rock", "2003", "45:02"}, {"Oasis", "Definitely Maybe", "Rock", "1995", "48:21"}, {"James Brown", "20 All-Time Greatest Hits", "Soul", "1978", "55:12"}, {"Ali Farka Toure", "Savane", "Blues", "2006", "54:54"}, {"Django Reinhardt", "Djangologie", "Jazz", "1937", "34:11"}, {"The Beatles", "Abbey Road", "Pop", "1970", "34:12"}, {"Primus", "Frizzle Fry", "Rock", "1997", "38:23"}, {"AIR", "Moon Safari", "Electronic", "2000", "46:42"}, {"Iron Maiden", "Live After Death", "Metal", "1984", "85:23"}, {"Zero-7", "In The Waiting Line", "Downtempo", "2006", "45:02"}, {"The Rolling Stones", "Let It Bleed", "Rock", "1972", "37:23"}, {"Aretha Franklin", "I Never Loved A Man", "Soul", "1966", "39:23"}, {"Rammstein", "Mutter", "Metal", "2002", "44:12"}, {"Coldplay", "Viva La Vida", "Pop", "2008", "51:00"}, {"Art Of Noise", "In Visible Silence", "Electronic", "1986", "39:12"}, {"New Order", "Bizarre Love Triangle", "Electronic", "1985", "43:23"}};
    private GenericTable _table;
    private TableToolbar _toolBar;
    private ReorderableTableWithTitleBar _panel;
    private JCheckBox _add;
    private JCheckBox _edit;
    private JCheckBox _delete;
    private JCheckBox _clear;
    private JCheckBox _copy;
    private JCheckBox _paste;
    private JCheckBox _duplicate;
    private JCheckBox _rowSel;
    private JCheckBox _colSel;
    private JCheckBox _selAll;
    private JCheckBox _colSelector;
    private JCheckBox _sorting;
    private JCheckBox _reorder;
    private JCheckBox _roll;
    private JCheckBox _reorderCols;
    private JCheckBox _tooltip;
    private JCheckBox _doubleClk;
    private JCheckBox _rowNum;
    private Listener _listener;
    private JComboBox<Integer> _alignCombo;
    private JComboBox<Integer> _modeCombo;
    private JButton _sizeAllButton;

    public UICTableDemoPanel() {
        this.setLayout(new BorderLayout());
        this.add(this._createGenericTable());
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new OracleLookAndFeel());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JFrame frame = new JFrame("Generic Table Demo");
        frame.add(new UICTableDemoPanel());
        frame.setDefaultCloseOperation(3);
        frame.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        frame.setVisible(true);
    }

    private JPanel _createGenericTable() {
        this._listener = new Listener();
        TransparentPanel p = new TransparentPanel();
        p.setLayout(new BorderLayout(10, 0));
        EditDefaultTableModel model = new EditDefaultTableModel(defaultModel, defaultColumns);
        this._table = new GenericTable(model);
        JScrollPane pane = new JScrollPane(this._table);
        ResizeComponent rc = new ResizeComponent(pane);
        JLayer<ResizeComponent> overlayLabel = new JLayer<ResizeComponent>(rc, new EmptyTableTextLayer(this._table, UIBundle.get("TABLE_NO_DATA")));
        JPanel content = new JPanel(new BorderLayout());
        content.add(overlayLabel);
        this._panel = new ReorderableTableWithTitleBar(this._table, content, true, true);
        this._configureGenericTable();
        this._configureToolbar();
        TransparentPanel p1 = new TransparentPanel();
        p1.setLayout(new FlowLayout());
        p1.add(this._panel);
        p.add((Component)p1, "West");
        JPanel controlsPanel = this._createGenericTableControls();
        p.add((Component)controlsPanel, "East");
        return p;
    }

    private void _configureGenericTable() {
        TableHelper.installTableTransferHandler(this._table, true);
        this._table.setRowHeader(this._table.createDefaultRowHeader());
        this._table.setSelectAllEnabled(true);
        this._table.setColumnSelectorAvailable(true);
        this._table.setSelectColumnsAction(new AbstractAction("Select Columns...", OracleIcons.getIcon((String)"table.png")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JEWTDialog d = new JEWTDialog(WindowUtils.parentFrame((Component)UICTableDemoPanel.this._table), "Customize Table Columns");
                d.setContent((Component)new JLabel("Client Specific Option. This is just a demo"));
                d.pack();
                d.runDialog();
            }
        });
        this._table.setPreferredVisibleRowCount(this._table.getRowCount());
        this._table.setPreferredScrollableViewportSize(new Dimension(320, this._table.getPreferredScrollableViewportSize().height));
    }

    private void _configureToolbar() {
        this._toolBar = this._panel.getTableToolbar();
        this._toolBar.setLabel("Generic Table Demo: ");
        this._toolBar.setAddVisible(true);
        this._toolBar.setDefaultAddAction(this._toolBar.getDefaultAction(TableToolbar.ToolAction.ADD_ROW));
        this._toolBar.setAddMenuActions(this._toolBar.getDefaultAction(TableToolbar.ToolAction.ADD_COLUMN), this._toolBar.getDefaultAction(TableToolbar.ToolAction.ADD_ROW_BEFORE), this._toolBar.getDefaultAction(TableToolbar.ToolAction.ADD_ROW_AFTER));
        this._toolBar.setEditVisible(true);
        this._toolBar.setDefaultEditAction(new EditAction());
        this._toolBar.setDeleteVisible(true);
        this._toolBar.setDefaultDeleteAction(this._toolBar.getDefaultAction(TableToolbar.ToolAction.DELETE_ROW));
        this._toolBar.setDeleteMenuActions(this._toolBar.getDefaultAction(TableToolbar.ToolAction.DELETE_COLUMN));
        this._toolBar.setClearVisible(true);
        this._toolBar.setDefaultClearAction(this._toolBar.getDefaultAction(TableToolbar.ToolAction.CLEAR));
        this._toolBar.setCopyVisible(true);
        this._toolBar.setDefaultCopyAction(this._toolBar.getDefaultAction(TableToolbar.ToolAction.COPY));
        this._toolBar.setPasteVisible(true);
        this._toolBar.setDefaultPasteAction(this._toolBar.getDefaultAction(TableToolbar.ToolAction.PASTE));
        this._toolBar.setDuplicateVisible(true);
        this._toolBar.setDefaultDuplicateAction(this._toolBar.getDefaultAction(TableToolbar.ToolAction.DUPLICATE_ROW));
    }

    private JPanel _createGenericTableControls() {
        TransparentPanel panel = new TransparentPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel tableTool = new JPanel();
        this._add = new JCheckBox("Add Row", true);
        this._edit = new JCheckBox("Edit", true);
        this._delete = new JCheckBox("Delete Row", true);
        this._clear = new JCheckBox("Clear", true);
        this._copy = new JCheckBox("Copy", true);
        this._paste = new JCheckBox("Paste", true);
        this._duplicate = new JCheckBox("Duplicate", true);
        this._add.addItemListener(this._listener);
        this._edit.addItemListener(this._listener);
        this._delete.addItemListener(this._listener);
        this._clear.addItemListener(this._listener);
        this._copy.addItemListener(this._listener);
        this._paste.addItemListener(this._listener);
        this._duplicate.addItemListener(this._listener);
        GridLayout gl = new GridLayout(0, 2);
        tableTool.setLayout(gl);
        tableTool.add(this._add);
        tableTool.add(this._edit);
        tableTool.add(this._delete);
        tableTool.add(this._clear);
        tableTool.add(this._copy);
        tableTool.add(this._paste);
        tableTool.add(this._duplicate);
        HeaderPanel<JPanel> toolHeader = new HeaderPanel<JPanel>(tableTool);
        toolHeader.getHeader().setLevel(Header.Level.DIALOG);
        toolHeader.getHeader().setText("TableToolbar: ");
        toolHeader.getHeader().setExpandable(true);
        panel.add(toolHeader);
        JPanel selPanel = new JPanel(new GridLayout(0, 2));
        this._rowSel = new JCheckBox("Row Selection", true);
        this._colSel = new JCheckBox("Column Selection");
        this._selAll = new JCheckBox("Select All", true);
        this._rowSel.addItemListener(this._listener);
        this._colSel.addItemListener(this._listener);
        this._selAll.addItemListener(this._listener);
        selPanel.add(this._rowSel);
        selPanel.add(this._colSel);
        selPanel.add(this._selAll);
        HeaderPanel<JPanel> selHeader = new HeaderPanel<JPanel>(selPanel);
        selHeader.getHeader().setLevel(Header.Level.DIALOG);
        selHeader.getHeader().setText("Table Selection: ");
        selHeader.getHeader().setExpandable(true);
        panel.add(selHeader);
        JPanel sizePanel = new JPanel(new GridLayout(0, 2, 2, 5));
        sizePanel.add(new JLabel("Size Table To Contents: "));
        this._sizeAllButton = new JButton("Size");
        this._sizeAllButton.addActionListener(this._listener);
        JPanel sp = new JPanel(new BorderLayout());
        sp.add((Component)this._sizeAllButton, "West");
        sizePanel.add(sp);
        sizePanel.add(new JLabel("Visible Rows: "));
        SpinnerNumberModel rowModel = new SpinnerNumberModel(this._table.getRowCount(), 2, 25, 1);
        rowModel.addChangeListener(this._listener);
        sp = new JPanel(new BorderLayout());
        sp.add((Component)new JSpinner(rowModel), "West");
        sizePanel.add(sp);
        sizePanel.add(new JLabel("Col Sizing: "));
        this._modeCombo = new JComboBox<Integer>(new Integer[]{4, 3, 1, 0, 2});
        this._modeCombo.setRenderer(new DefaultListCellRenderer(){

            public JComponent getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
                switch ((Integer)value) {
                    case 4: {
                        label.setText("AUTO_RESIZE_ALL_COLUMNS");
                        break;
                    }
                    case 3: {
                        label.setText("AUTO_RESIZE_LAST_COLUMN");
                        break;
                    }
                    case 1: {
                        label.setText("AUTO_RESIZE_NEXT_COLUMN");
                        break;
                    }
                    case 0: {
                        label.setText("AUTO_RESIZE_OFF");
                        break;
                    }
                    case 2: {
                        label.setText("AUTO_RESIZE_SUBSEQUENT_COLUMNS");
                    }
                }
                return label;
            }
        });
        this._modeCombo.setPreferredSize(new Dimension(100, this._modeCombo.getPreferredSize().height));
        this._modeCombo.addActionListener(this._listener);
        sizePanel.add(this._modeCombo);
        sizePanel.add(new JLabel("Column Alignment: "));
        this._alignCombo = new JComboBox();
        this._alignCombo.addItem(2);
        this._alignCombo.addItem(0);
        this._alignCombo.addItem(4);
        this._alignCombo.setRenderer(new DefaultListCellRenderer(){

            public JComponent getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
                switch ((Integer)value) {
                    case 2: {
                        label.setText("Left");
                        break;
                    }
                    case 4: {
                        label.setText("Right");
                        break;
                    }
                    case 0: {
                        label.setText("Center");
                    }
                }
                return label;
            }
        });
        this._alignCombo.addActionListener(this._listener);
        sizePanel.add(this._alignCombo);
        HeaderPanel<JPanel> sizeHeader = new HeaderPanel<JPanel>(sizePanel);
        sizeHeader.getHeader().setLevel(Header.Level.DIALOG);
        sizeHeader.getHeader().setText("Sizing and Layout Controls: ");
        sizeHeader.getHeader().setExpandable(true);
        panel.add(sizeHeader);
        JPanel othrPanel = new JPanel(new GridLayout(0, 2));
        this._doubleClk = new JCheckBox("Autofit Cols", true);
        this._doubleClk.setToolTipText("Double click on the column separator to resize the column to the width of the widest cell");
        this._doubleClk.addItemListener(this._listener);
        othrPanel.add(this._doubleClk);
        this._colSelector = new JCheckBox("Column Selector", true);
        this._colSelector.addItemListener(this._listener);
        othrPanel.add(this._colSelector);
        this._sorting = new JCheckBox("Sorting");
        this._sorting.addItemListener(this._listener);
        othrPanel.add(this._sorting);
        this._tooltip = new JCheckBox("Truncated Cell Tooltip", true);
        this._tooltip.setToolTipText("Show tool tip for the truncated cell");
        this._tooltip.addItemListener(this._listener);
        othrPanel.add(this._tooltip);
        JCheckBox _roll = new JCheckBox("Mouse RollOver", true);
        _roll.addItemListener(this._listener);
        othrPanel.add(_roll);
        this._reorderCols = new JCheckBox("Reorder Columns", true);
        this._reorderCols.addItemListener(this._listener);
        othrPanel.add(this._reorderCols);
        this._reorder = new JCheckBox("Reorderable Table", true);
        this._reorder.addItemListener(this._listener);
        othrPanel.add(this._reorder);
        this._rowNum = new JCheckBox("Show RowNumber");
        this._rowNum.addItemListener(this._listener);
        othrPanel.add(this._rowNum);
        HeaderPanel<JPanel> othrHeader = new HeaderPanel<JPanel>(othrPanel);
        othrHeader.getHeader().setLevel(Header.Level.DIALOG);
        othrHeader.getHeader().setText("Other Controls: ");
        othrHeader.getHeader().setExpandable(true);
        panel.add(othrHeader);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)panel, "North");
        return topPanel;
    }

    private class EditAction
    extends AbstractAction {
        private EditAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (UICTableDemoPanel.this._table.getRowSelectionAllowed() || UICTableDemoPanel.this._table.getColumnSelectionAllowed()) {
                int row = UICTableDemoPanel.this._table.getSelectedRow();
                int col = UICTableDemoPanel.this._table.getSelectedColumn();
                if (row != -1 && col != -1) {
                    TableHelper.stopCellEditing(UICTableDemoPanel.this._table);
                    JEWTDialog d = new JEWTDialog(WindowUtils.parentFrame((Component)UICTableDemoPanel.this._toolBar), "Edit Cell/Row (Use Case Specific)");
                    JLabel label = new JLabel("Enter the data for the new row or column");
                    JTextField jt = new JTextField(20);
                    JPanel p = new JPanel(new BorderLayout());
                    p.add((Component)label, "North");
                    p.add((Component)jt, "Center");
                    d.setContent((Component)p);
                    Object value = UICTableDemoPanel.this._table.getModel().getValueAt(row, col);
                    if (value != null) {
                        jt.setText(value.toString());
                    }
                    if (d.runDialog()) {
                        UICTableDemoPanel.this._table.getModel().setValueAt(jt.getText(), row, col);
                    }
                }
            }
        }
    }

    private class Listener
    implements ItemListener,
    ActionListener,
    ChangeListener {
        private Listener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object src = e.getSource();
            if (src == UICTableDemoPanel.this._add) {
                UICTableDemoPanel.this._toolBar.setAddVisible(UICTableDemoPanel.this._add.isSelected());
            } else if (src == UICTableDemoPanel.this._edit) {
                UICTableDemoPanel.this._toolBar.setEditVisible(UICTableDemoPanel.this._edit.isSelected());
            } else if (src == UICTableDemoPanel.this._delete) {
                UICTableDemoPanel.this._toolBar.setDeleteVisible(UICTableDemoPanel.this._delete.isSelected());
            } else if (src == UICTableDemoPanel.this._clear) {
                UICTableDemoPanel.this._toolBar.setClearVisible(UICTableDemoPanel.this._clear.isSelected());
            } else if (src == UICTableDemoPanel.this._copy) {
                UICTableDemoPanel.this._toolBar.setCopyVisible(UICTableDemoPanel.this._copy.isSelected());
            } else if (src == UICTableDemoPanel.this._paste) {
                UICTableDemoPanel.this._toolBar.setPasteVisible(UICTableDemoPanel.this._paste.isSelected());
            } else if (src == UICTableDemoPanel.this._duplicate) {
                UICTableDemoPanel.this._toolBar.setDuplicateVisible(UICTableDemoPanel.this._duplicate.isSelected());
            } else if (src == UICTableDemoPanel.this._rowSel) {
                UICTableDemoPanel.this._table.setRowSelectionAllowed(UICTableDemoPanel.this._rowSel.isSelected());
            } else if (src == UICTableDemoPanel.this._colSel) {
                UICTableDemoPanel.this._table.setColumnSelectionAllowed(UICTableDemoPanel.this._colSel.isSelected());
            } else if (src == UICTableDemoPanel.this._selAll) {
                UICTableDemoPanel.this._table.setSelectAllEnabled(UICTableDemoPanel.this._selAll.isSelected());
            } else if (src == UICTableDemoPanel.this._colSelector) {
                UICTableDemoPanel.this._table.setColumnSelectorAvailable(UICTableDemoPanel.this._colSelector.isSelected());
            } else if (src == UICTableDemoPanel.this._sorting) {
                if (UICTableDemoPanel.this._sorting.isSelected()) {
                    UICTableDemoPanel.this._table.setAutoCreateRowSorter(true);
                } else {
                    UICTableDemoPanel.this._table.setRowSorter(null);
                }
            } else if (src == UICTableDemoPanel.this._reorder) {
                if (UICTableDemoPanel.this._reorder.isSelected()) {
                    UICTableDemoPanel.this._panel.setReorderableTable(UICTableDemoPanel.this._panel.createDefaultReorderableTable());
                } else {
                    UICTableDemoPanel.this._panel.setReorderableTable(null);
                }
            } else if (src == UICTableDemoPanel.this._roll) {
                UICTableDemoPanel.this._table.setRolloverHighlightingEnabled(UICTableDemoPanel.this._roll.isSelected());
            } else if (src == UICTableDemoPanel.this._reorderCols) {
                UICTableDemoPanel.this._table.getTableHeader().setReorderingAllowed(UICTableDemoPanel.this._reorderCols.isSelected());
            } else if (src == UICTableDemoPanel.this._tooltip) {
                UICTableDemoPanel.this._table.setShowToolTips(UICTableDemoPanel.this._tooltip.isSelected());
            } else if (src == UICTableDemoPanel.this._doubleClk) {
                UICTableDemoPanel.this._table.setResizeColumnOnDoubleClick(UICTableDemoPanel.this._doubleClk.isSelected());
            } else if (src == UICTableDemoPanel.this._rowNum) {
                UICTableDemoPanel.this._table.getRowHeader().setShowRowNumber(UICTableDemoPanel.this._rowNum.isSelected());
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object src = ae.getSource();
            if (src == UICTableDemoPanel.this._sizeAllButton) {
                TableHelper.sizeTableToContents(UICTableDemoPanel.this._table);
            } else if (src == UICTableDemoPanel.this._modeCombo) {
                UICTableDemoPanel.this._table.setAutoResizeMode((Integer)UICTableDemoPanel.this._modeCombo.getSelectedItem());
            } else if (src == UICTableDemoPanel.this._alignCombo) {
                UICTableDemoPanel.this._table.repaint();
                UICTableDemoPanel.this._table.getTableHeader().repaint();
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            UICTableDemoPanel.this._table.setVisibleRows((Integer)((SpinnerNumberModel)e.getSource()).getValue());
        }
    }

    private class EditDefaultTableModel
    extends DefaultTableModel
    implements EditableTableModel,
    GenericTableModel {
        public EditDefaultTableModel(Object[][] datas, Object[] cols) {
            super(datas, cols);
        }

        @Override
        public void insertColumn(int column, Object columnName, Object[] columnData) {
        }

        @Override
        public void removeColumn(int column) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                Vector row = (Vector)this.dataVector.elementAt(i);
                row.remove(column);
            }
            this.columnIdentifiers.remove(column);
            this.fireTableStructureChanged();
        }

        @Override
        public int duplicateRow(int row, int nCopy) {
            Object[] rowData = new Object[this.getColumnCount()];
            for (int i = 0; i < rowData.length; ++i) {
                rowData[i] = i == 0 ? "Copy of " + this.getValueAt(row, i) : this.getValueAt(row, i);
            }
            this.insertRow(row + 1, rowData);
            return row + 1;
        }

        @Override
        public int duplicateColumn(int col, int nCopy) {
            return -1;
        }

        @Override
        public int getColumnAlignment(int column) {
            return (Integer)UICTableDemoPanel.this._alignCombo.getSelectedItem();
        }

        @Override
        public boolean canHide(int column) {
            return column != 2;
        }
    }
}

