/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.ghost;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeCellRenderer;
import oracle.javatools.ui.border.FocusBorder;
import oracle.javatools.ui.ghost.GhostButtonUI;
import oracle.javatools.ui.ghost.GhostScrollBarUI;
import oracle.javatools.ui.ghost.UIConstants;
import oracle.javatools.ui.internal.Exceptions;

public final class ComponentConverter {
    public static void convertToGhost(JComponent component, UIConstants.Look look) {
        HashMap<String, Object> props = null;
        props = ComponentConverter.getLook(look);
        ComponentConverter.visit(component, props, look);
    }

    private static HashMap<String, Object> getLook(UIConstants.Look look) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("Foreground", UIConstants.getColor("ghost.text.foreground", look));
        props.put("Background", UIConstants.getColor("ghost.transparent", look));
        props.put("BackgroundNonSelectionColor", UIConstants.getColor("ghost.transparent", look));
        props.put("BackgroundSelectionColor", UIConstants.getColor("ghost.selection.background", look));
        props.put("textSelectionColor", UIConstants.getColor("ghost.selection.text", look));
        props.put("textNonSelectionColor", UIConstants.getColor("ghost.text.foreground", look));
        props.put("selectionColor", UIConstants.getColor("ghost.selection.background", look));
        props.put("selectedTextColor", UIConstants.getColor("ghost.selection.text", look));
        props.put("caretColor", UIConstants.getColor("ghost.caret.foreground", look));
        props.put("Opaque", Boolean.FALSE);
        return props;
    }

    private static void visit(JComponent c, Map<String, Object> props, UIConstants.Look look) {
        Object vetoAllProp = c.getClientProperty(UIConstants.VETO_HIERARCHY_CONVERSION);
        if (vetoAllProp != null && vetoAllProp == Boolean.TRUE) {
            return;
        }
        Object vetoProp = c.getClientProperty(UIConstants.VETO_CONVERSION);
        if (vetoProp == null || vetoProp != Boolean.TRUE) {
            c.putClientProperty(UIConstants.GHOST_LOOK, (Object)look);
            ComponentConverter.setProperties(c, props);
            ComponentConverter.convertSpecialCases(props, look, c);
        }
        for (Component comp : c.getComponents()) {
            if (!(comp instanceof JComponent) || comp instanceof JTextComponent) continue;
            ComponentConverter.visit((JComponent)comp, props, look);
            vetoProp = ((JComponent)comp).getClientProperty(UIConstants.VETO_CONVERSION);
            if (vetoProp != null && vetoProp == Boolean.TRUE) continue;
            ComponentConverter.convertSpecialCases(props, look, comp);
        }
    }

    private static void convertSpecialCases(Map<String, Object> props, UIConstants.Look look, Component comp) {
        if (comp instanceof JComponent && ((JComponent)comp).getClientProperty(UIConstants.INSTRUCTION_LABEL) == Boolean.TRUE) {
            ((JComponent)comp).setForeground(UIConstants.getColor("ghost.instruction.foreground", look));
        }
        if (comp instanceof JTree) {
            JTree tree = (JTree)comp;
            TreeCellRenderer renderer = tree.getCellRenderer();
            if (renderer instanceof JComponent) {
                ComponentConverter.setProperties((JComponent)((Object)renderer), props);
            }
        } else if (comp instanceof JList) {
            JList list = (JList)comp;
            ListCellRenderer renderer = list.getCellRenderer();
            if (renderer instanceof JComponent) {
                ComponentConverter.setProperties((JComponent)((Object)renderer), props);
            }
        } else if (comp instanceof JTextComponent) {
            JTextComponent textComp = (JTextComponent)comp;
            textComp.setOpaque(true);
        } else if (comp instanceof JComboBox) {
            JComboBox combo = (JComboBox)comp;
            Accessible a = combo.getUI().getAccessibleChild(combo, 0);
            if (a != null && a instanceof ComboPopup) {
                JList<Object> list = ((ComboPopup)((Object)a)).getList();
                list.setOpaque(true);
                list.setBackground(UIConstants.getColor("ghost.panel.background", look));
                ComponentConverter.setProperties(list, props);
            }
        } else if (comp instanceof JScrollPane) {
            JScrollPane sp = (JScrollPane)comp;
            sp.getVerticalScrollBar().setUI((ScrollBarUI)GhostScrollBarUI.createUI(sp.getVerticalScrollBar()));
            sp.getVerticalScrollBar().putClientProperty("JScrollBar.fastWheelScrolling", Boolean.TRUE);
            sp.getHorizontalScrollBar().setUI((ScrollBarUI)GhostScrollBarUI.createUI(sp.getHorizontalScrollBar()));
        } else if (comp instanceof JButton && !(comp.getParent() instanceof JToolBar)) {
            JButton button = (JButton)comp;
            button.setBorder(new FocusBorder(new Insets(1, 3, 1, 3)));
            button.setUI((ButtonUI)GhostButtonUI.createUI(button));
            if (button.getIcon() != null && (button.getText() == null || "".equals(button.getText()))) {
                button.setRolloverEnabled(true);
                button.putClientProperty(UIConstants.ICON_BUTTON, Boolean.TRUE);
            }
        } else if (comp instanceof AbstractButton && comp.getParent() instanceof JToolBar) {
            AbstractButton button = (AbstractButton)comp;
            button.setBackground(Color.DARK_GRAY);
            button.setBorderPainted(true);
            button.setContentAreaFilled(true);
        }
    }

    private static void setProperties(JComponent c, Map<String, Object> props) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(c.getClass());
            PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
            for (String key : props.keySet()) {
                for (PropertyDescriptor pd : pds) {
                    if (!pd.getName().equalsIgnoreCase(key)) continue;
                    Object value = props.get(key);
                    try {
                        pd.getWriteMethod().invoke((Object)c, value);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IntrospectionException e) {
            Exceptions.swallow(e);
        }
    }
}

