/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.datatips;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import oracle.javatools.ui.MouseHoverListener;
import oracle.javatools.ui.MouseHoverSupport;
import oracle.javatools.ui.datatips.ExpansionRenderer;
import oracle.javatools.ui.datatips.TableCustomizer;
import oracle.javatools.ui.popup.TransparentWindow;
import oracle.javatools.ui.table.RowHeader;
import oracle.javatools.ui.treetable.NodeTableModelAdapter;

public class DataTipWindow {
    private DataTipWindowImpl window;
    private JTable table;
    private ExpansionL expansionL = new ExpansionL();
    private DataTipWindow parentTipWindow;
    private DataTipWindow childTipWindow;
    private GlassPane glassPane;
    private TableCustomizer tableCustomizer;
    Rectangle locationRect;
    private GraphicsDevice graphicsDevice;
    private Rectangle screenBounds;
    private final int MAX_HEIGHT = 400;

    public DataTipWindow(DataTipWindow parentTipWindow, Window owner, NodeTableModelAdapter tableModel, TableCustomizer tableCustomizer) {
        this.parentTipWindow = parentTipWindow;
        this.tableCustomizer = tableCustomizer;
        this.window = new DataTipWindowImpl(owner);
        this.table = new JTable(tableModel);
        this.table.setSelectionMode(0);
        this.table.setShowHorizontalLines(false);
        this.table.setTableHeader(null);
        this.table.getSelectionModel().setSelectionInterval(0, 0);
        if (tableCustomizer != null) {
            tableCustomizer.customizeTable(this.table, tableModel.getNode());
        }
        this.window.setLayout(new BorderLayout());
        this.glassPane = new GlassPane();
        this.window.setGlassPane(this.glassPane);
        RowHeader rowHeader = new RowHeader(this.table);
        rowHeader.setCellRenderer(new ExpansionRenderer());
        MouseHoverSupport hoverSupport = new MouseHoverSupport(rowHeader, 100, false);
        hoverSupport.addMouseHoverListener(this.expansionL);
        JScrollPane sp = new JScrollPane(this.table);
        sp.setRowHeaderView(rowHeader);
        sp.getViewport().setPreferredSize(this.table.getPreferredSize());
        this.window.add(sp);
        this.addKeyBindings();
    }

    private void addKeyBindings() {
        String CLOSE_ACTION = "CLOSE_ACTION";
        this.table.getInputMap(0).put(KeyStroke.getKeyStroke(27, 0, false), "CLOSE_ACTION");
        this.table.getActionMap().put("CLOSE_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window owner = DataTipWindow.this.window.getOwner();
                DataTipWindow.this.disposeAll();
                Component c = owner.getMostRecentFocusOwner();
                if (c != null) {
                    c.requestFocus();
                }
            }
        });
        String EXPAND_ACTION = "EXPAND_ACTION";
        this.table.getInputMap(0).put(KeyStroke.getKeyStroke(39, 128, false), "EXPAND_ACTION");
        this.table.getInputMap(0).put(KeyStroke.getKeyStroke(40, 128, false), "EXPAND_ACTION");
        this.table.getActionMap().put("EXPAND_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTipWindow.this.showChildWindow(DataTipWindow.this.table.getSelectedRow());
            }
        });
        String COLLAPSE_ACTION = "COLLAPSE_ACTION";
        this.table.getInputMap(0).put(KeyStroke.getKeyStroke(37, 128, false), "COLLAPSE_ACTION");
        this.table.getInputMap(0).put(KeyStroke.getKeyStroke(38, 128, false), "COLLAPSE_ACTION");
        this.table.getActionMap().put("COLLAPSE_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DataTipWindow.this.parentTipWindow != null) {
                    DataTipWindow.this.parentTipWindow.disposeChildren();
                } else {
                    Window owner = DataTipWindow.this.window.getOwner();
                    DataTipWindow.this.disposeAll();
                    owner.getMostRecentFocusOwner().requestFocus();
                }
            }
        });
    }

    public void setLocationRectangle(Rectangle rect) {
        this.locationRect = rect;
    }

    public void setGraphicsDevice(GraphicsDevice device) {
        this.graphicsDevice = device;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.window.pack();
            this.window.setSize(this.window.getWidth(), Math.min(400, this.window.getHeight()));
            Rectangle screenDesktopBounds = null;
            GraphicsDevice defaultDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            screenDesktopBounds = this.graphicsDevice != null && this.graphicsDevice != defaultDevice ? this.graphicsDevice.getDefaultConfiguration().getBounds() : GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            int screenRightEdge = screenDesktopBounds.x + screenDesktopBounds.width;
            int screenBottomEdge = screenDesktopBounds.y + screenDesktopBounds.height;
            Point p = this.locationRect.getLocation();
            p.y = this.locationRect.y + this.locationRect.height + this.window.getHeight() < screenBottomEdge ? (p.y += this.locationRect.height) : (p.y -= this.window.getHeight());
            int screenRightDiff = p.x + this.window.getWidth() - screenRightEdge;
            if (screenRightDiff > 0) {
                p.x -= screenRightDiff;
            }
            if (p.x < screenDesktopBounds.x) {
                p.x = screenDesktopBounds.x;
            }
            this.window.setLocation(p);
        }
        this.window.setVisible(visible);
        if (visible) {
            this.screenBounds = new Rectangle(this.window.getLocationOnScreen(), this.window.getSize());
            this.table.requestFocus();
        }
    }

    public boolean isExpanded() {
        return this.childTipWindow != null;
    }

    public int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public void dispose() {
        this.window.setVisible(false);
        this.window.dispose();
        this.disposeChildren();
        this.childTipWindow = null;
        this.screenBounds = null;
    }

    public void disposeChildren() {
        if (this.childTipWindow != null) {
            this.childTipWindow.dispose();
        }
        this.childTipWindow = null;
        this.glassPane.setVisible(false);
        this.table.requestFocus();
    }

    public void disposeAll() {
        this.dispose();
        if (this.parentTipWindow != null) {
            this.parentTipWindow.disposeAll();
        }
    }

    public Rectangle getScreenBounds() {
        return this.screenBounds;
    }

    private void showChildWindow(int row) {
        NodeTableModelAdapter model;
        if (this.childTipWindow != null) {
            this.childTipWindow.dispose();
        }
        if ((model = (NodeTableModelAdapter)this.table.getModel()).isExpandable(row)) {
            this.table.getSelectionModel().setSelectionInterval(row, row);
            NodeTableModelAdapter childModel = model.getNodeTableModelForChild(row);
            this.childTipWindow = new DataTipWindow(this, this.window.getOwner(), childModel, this.tableCustomizer);
            Rectangle r = this.table.getCellRect(row, 0, true);
            Point p = r.getLocation();
            SwingUtilities.convertPointToScreen(p, this.table);
            r.setLocation(p);
            this.childTipWindow.setLocationRectangle(r);
            this.childTipWindow.setVisible(true);
            this.glassPane.setVisible(true);
            this.window.repaint();
        }
    }

    void setTableCustomizer(TableCustomizer tableCustomizer) {
        this.tableCustomizer = tableCustomizer;
    }

    public DataTipWindow getChildTipWindow() {
        return this.childTipWindow;
    }

    public JWindow getWindow() {
        return this.window;
    }

    private class GlassPane
    extends JComponent {
        private Color color = new Color(0.5f, 0.5f, 0.5f, 0.2f);

        public GlassPane() {
            this.setOpaque(false);
        }

        @Override
        public void paint(Graphics g) {
            int y1;
            g.setColor(this.color);
            int row = DataTipWindow.this.table.getSelectedRow();
            Rectangle r = DataTipWindow.this.table.getCellRect(row, 0, false);
            r = SwingUtilities.convertRectangle(DataTipWindow.this.table, r, this);
            if (r.y > 0) {
                g.fillRect(0, 0, this.getWidth(), Math.min(this.getHeight(), r.y));
            }
            if ((y1 = r.y + r.height) < this.getHeight()) {
                g.fillRect(0, y1, this.getWidth(), this.getHeight() - y1);
            }
        }
    }

    class DataTipWindowImpl
    extends TransparentWindow {
        public DataTipWindowImpl(Window owner) {
            super(owner);
        }

        public DataTipWindow getDataTipWindow() {
            return DataTipWindow.this;
        }

        @Override
        public void setTransparent(boolean transparent) {
            super.setTransparent(transparent);
            if (DataTipWindow.this.parentTipWindow != null) {
                DataTipWindow.this.parentTipWindow.window.setTransparent(transparent);
            }
        }
    }

    private class ExpansionL
    implements MouseHoverListener {
        private ExpansionL() {
        }

        @Override
        public void mouseHovered(MouseEvent me) {
            Point p;
            RowHeader header = (RowHeader)me.getSource();
            int i = header.locationToIndex(p = me.getPoint());
            if (i > -1) {
                NodeTableModelAdapter model = (NodeTableModelAdapter)DataTipWindow.this.table.getModel();
                if (DataTipWindow.this.childTipWindow == null || model.isExpandable(i) && DataTipWindow.this.table.getSelectedRow() != i) {
                    DataTipWindow.this.showChildWindow(i);
                }
            }
        }
    }
}

