/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.checklist.xml;

import java.awt.Component;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.share.nls.LocaleUtils;
import oracle.javatools.ui.checklist.Checklist;
import oracle.javatools.ui.checklist.ContentElement;
import oracle.javatools.ui.checklist.Step;
import oracle.javatools.ui.checklist.TaskContent;
import oracle.javatools.ui.checklist.xml.XMLChecklistModel;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLChecklist
extends Checklist {
    private ClassLoader _classLoader;

    public XMLChecklist(Reader reader) {
        this(reader, null);
    }

    public XMLChecklist(Reader reader, String saxParserClassName) {
        this(reader, saxParserClassName, null);
    }

    public XMLChecklist(Reader reader, String saxParserClassName, ClassLoader classLoader) {
        super(new XMLChecklistModel());
        this._classLoader = classLoader;
        try {
            XMLReader xr = null;
            if (saxParserClassName != null) {
                try {
                    xr = XMLReaderFactory.createXMLReader(saxParserClassName);
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
            }
            if (xr == null) {
                xr = XMLReaderFactory.createXMLReader();
            }
            Handler h = new Handler();
            xr.setContentHandler(h);
            xr.setErrorHandler(h);
            xr.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            xr.parse(new InputSource(reader));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public XMLChecklistModel getXMLChecklistModel() {
        return (XMLChecklistModel)this.getChecklistModel();
    }

    private class Handler
    extends DefaultHandler {
        private static final String _CHECKLIST = "checklist";
        private static final String _STATUS = "stepStatus";
        private static final String _HEADER = "checklistHeader";
        private static final String _TITLE = "title";
        private static final String _ICON = "icon";
        private static final String _DESCRIPTION = "description";
        private static final String _STEP = "step";
        private static final String _SUB_STEP = "substep";
        private static final String _STEP_CONTENT = "stepContent";
        private static final String _PREREQ = "prerequisites";
        private static final String _NEXT_STEPS = "nextSteps";
        private static final String _LIST_ITEM = "listItem";
        private static final String _LINK = "link";
        private static final String _CONCEPT_IMAGE = "conceptualImage";
        private static final String _CONTENT_LINK = "contentLink";
        private static final String _LINK_TYPE = "linkType";
        private static final String _LINK_LABEL = "label";
        private static final String _LINK_HINT = "linkHint";
        private static final String _LINK_TARGET = "target";
        private static final String _ATTR_RSBUNDLE = "rs-bundle-class";
        private static final String _ATTR_SHOW_STATUS = "show";
        private static final String _ATTR_STEP_ID = "stepId";
        private static final String _ATTR_STEP_ENABLE = "enabled";
        private static final String _ATTR_STEP_VISIBLE = "visible";
        private static final String _ATTR_TITLE = "title";
        private static final String _ATTR_LINK_ID = "linkId";
        private static final String _ATTR_LINK_TARGET = "target";
        private ArrayDeque<String> _stack = new ArrayDeque();
        private ArrayDeque<StringBuffer> _stackChars = new ArrayDeque();
        private Step _step;
        private Step _parent;
        private LinkInfo _linkElement;
        private List<String> _items;
        private StringBuffer _currLinkItem;
        private ResourceBundle _bundle;

        private Handler() {
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes atts) {
            this._stack.push(name);
            this._stackChars.push(new StringBuffer());
            if (name == _CHECKLIST) {
                String rsBundle = atts.getValue(_ATTR_RSBUNDLE);
                if (rsBundle != null && !"".equals(rsBundle)) {
                    this._bundle = XMLChecklist.this._classLoader == null ? ResourceBundle.getBundle(rsBundle, LocaleUtils.getDefaultableLocale((Component)XMLChecklist.this)) : ResourceBundle.getBundle(rsBundle, LocaleUtils.getDefaultableLocale((Component)XMLChecklist.this), XMLChecklist.this._classLoader);
                }
            } else if (name == _STATUS) {
                String value = atts.getValue(_ATTR_SHOW_STATUS);
                XMLChecklist.this.setShowStatus(value != null && !"".equals(value) ? Boolean.parseBoolean(value) : true);
            } else if (name == _STEP) {
                this._step = new Step();
                String id = atts.getValue(_ATTR_STEP_ID);
                String value = atts.getValue(_ATTR_STEP_ENABLE);
                this._step.setEnabled(value != null && !"".equals(value) ? Boolean.parseBoolean(value) : true);
                value = atts.getValue(_ATTR_STEP_VISIBLE);
                this._step.setVisible(value != null && !"".equals(value) ? Boolean.parseBoolean(value) : true);
                XMLChecklist.this.getXMLChecklistModel().addStep(id, this._step);
                this._parent = this._step;
            } else if (name == _SUB_STEP) {
                if (this._parent != null) {
                    this._step = new Step();
                    String id = atts.getValue(_ATTR_STEP_ID);
                    String value = atts.getValue(_ATTR_STEP_ENABLE);
                    this._step.setEnabled(value != null && !"".equals(value) ? Boolean.parseBoolean(value) : true);
                    value = atts.getValue(_ATTR_STEP_VISIBLE);
                    this._step.setVisible(value != null && !"".equals(value) ? Boolean.parseBoolean(value) : true);
                    XMLChecklist.this.getXMLChecklistModel().addSubstep(this._parent, id, this._step);
                }
            } else if (name == _STEP_CONTENT) {
                Step step = this._getCurrentStep();
                if (step != null) {
                    step.setContent(new TaskContent(step));
                }
            } else if (name == _PREREQ) {
                TaskContent content = this._getCurrentStepContent();
                if (content != null) {
                    content.getTaskContentProvider().setRequirementHeaderLabel(this._getValueFromResourceBundle(atts.getValue("title")));
                }
            } else if (name == _LIST_ITEM) {
                this._currLinkItem = new StringBuffer();
            } else if (name == _NEXT_STEPS) {
                TaskContent content = this._getCurrentStepContent();
                if (content != null) {
                    content.getTaskContentProvider().setSummaryHeaderLabel(this._getValueFromResourceBundle(atts.getValue("title")));
                }
            } else if (name == _LINK) {
                String parent = this._getParentElement(this._getCurrentElement());
                if (parent == _LIST_ITEM) {
                    this._stackChars.pop();
                    this._currLinkItem.append(this._stackChars.peek().toString());
                    this._stackChars.pop();
                    this._stackChars.push(new StringBuffer());
                    this._stackChars.push(new StringBuffer());
                    String ref = atts.getValue("target");
                    String id = atts.getValue(_ATTR_LINK_ID);
                    this._currLinkItem.append(" <a id=" + id + " href=" + ref + "> ");
                }
            } else if (name == _CONTENT_LINK) {
                this._linkElement = new LinkInfo();
                this._linkElement._id = atts.getValue(_ATTR_LINK_ID);
            }
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            TaskContent content;
            String parent = this._getParentElement(this._getCurrentElement());
            StringBuffer buff = this._stackChars.peek();
            this.characters(buff.toString());
            this._stackChars.pop();
            this._stack.pop();
            if (name == _STEP) {
                this._step = null;
                this._parent = null;
            } else if (name == _SUB_STEP) {
                this._step = this._parent;
            } else if (name == _PREREQ) {
                TaskContent content2 = this._getCurrentStepContent();
                if (content2 != null && this._items != null) {
                    content2.getTaskContentProvider().setRequirements(this._items);
                }
                this._items = null;
            } else if (name == _LIST_ITEM) {
                if (this._items == null) {
                    this._items = new ArrayList<String>();
                }
                this._items.add(this._currLinkItem.toString());
                this._currLinkItem = null;
            } else if (name == _NEXT_STEPS) {
                TaskContent content3 = this._getCurrentStepContent();
                if (content3 != null && this._items != null) {
                    content3.getTaskContentProvider().setSummary(this._items);
                }
                this._items = null;
            } else if (name == _LINK) {
                if (parent == _LIST_ITEM) {
                    this._currLinkItem.append(" </a>");
                }
            } else if (name == _CONTENT_LINK && this._linkElement != null && (content = this._getCurrentStepContent()) != null) {
                ContentElement elem = new ContentElement(this._linkElement._id, this._linkElement._type, this._linkElement._label, this._linkElement._icon, this._linkElement._targetLink, this._linkElement._description);
                content.getTaskContentProvider().addContentElement(elem);
                this._linkElement = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            StringBuffer strBuff = this._stackChars.peek();
            strBuff.append(String.valueOf(ch, start, length));
        }

        public void characters(String value) {
            Step step;
            String curr = this._getCurrentElement();
            String parent = this._getParentElement(this._getCurrentElement());
            value = value.trim();
            value = this._getValueFromResourceBundle(value);
            if (parent == _HEADER) {
                if (curr == "title") {
                    XMLChecklist.this.setHeaderText(value);
                } else if (curr == _ICON) {
                    XMLChecklist.this.setHeaderIcon(new ImageIcon(ImageUtils.getImageResource(XMLChecklist.class, (ClassLoader)XMLChecklist.this._classLoader, (String)value), null));
                } else if (curr == _DESCRIPTION) {
                    XMLChecklist.this.setHeaderDescription(value);
                }
            }
            if ((parent == _STEP || parent == _SUB_STEP) && (step = this._getCurrentStep()) != null) {
                if (curr == "title") {
                    step.setTitle(value);
                } else if (curr == _ICON) {
                    step.setIcon(new ImageIcon(ImageUtils.getImageResource(XMLChecklist.class, (ClassLoader)XMLChecklist.this._classLoader, (String)value)));
                }
            }
            if ((parent == _PREREQ || parent == _NEXT_STEPS) && curr == _LIST_ITEM) {
                this._currLinkItem.append(value);
            }
            if (parent == _LIST_ITEM && curr == _LINK) {
                this._currLinkItem.append(value);
            }
            if (parent == _STEP_CONTENT) {
                TaskContent content;
                if (curr == _DESCRIPTION) {
                    content = this._getCurrentStepContent();
                    if (content != null) {
                        content.getTaskContentProvider().setDescription(value);
                    }
                } else if (curr == _CONCEPT_IMAGE && (content = this._getCurrentStepContent()) != null) {
                    content.getTaskContentProvider().setImage(ImageUtils.getImageResource(XMLChecklist.class, (ClassLoader)XMLChecklist.this._classLoader, (String)value));
                }
            }
            if (parent == _CONTENT_LINK) {
                if (curr == _LINK_TYPE) {
                    this._linkElement._type = this._getLinkType(value);
                    if (this._linkElement._type == ContentElement.Type.ACTIONBUTTON && this._linkElement._description != null && !"".equals(this._linkElement._description)) {
                        this._linkElement._description = this._linkElement._description.replace(",", " > ");
                    }
                } else if (curr == _LINK_LABEL) {
                    this._linkElement._label = value;
                } else if (curr == _LINK_HINT) {
                    if (this._linkElement._type == ContentElement.Type.ACTIONBUTTON) {
                        value = value.replace(",", " > ");
                    }
                    this._linkElement._description = value;
                } else if (curr == _ICON) {
                    this._linkElement._icon = new ImageIcon(ImageUtils.getImageResource(XMLChecklist.class, (ClassLoader)XMLChecklist.this._classLoader, (String)value));
                } else if (curr == "target") {
                    this._linkElement._targetLink = value;
                }
            }
        }

        @Override
        public void error(SAXParseException exception) {
            System.out.println(exception.getMessage());
        }

        @Override
        public void fatalError(SAXParseException exception) {
            System.out.println(exception.getMessage());
        }

        @Override
        public void warning(SAXParseException exception) {
            System.out.println(exception.getMessage());
        }

        private String _getCurrentElement() {
            return this._stack.peek();
        }

        private String _getParentElement(String current) {
            Iterator<String> iter = this._stack.iterator();
            while (iter.hasNext()) {
                String curr = iter.next();
                if (curr != current || !iter.hasNext()) continue;
                return iter.next();
            }
            return null;
        }

        private Step _getCurrentStep() {
            return this._step;
        }

        private TaskContent _getCurrentStepContent() {
            Step step = this._getCurrentStep();
            if (step != null) {
                return (TaskContent)step.getContent();
            }
            return null;
        }

        private String _getValueFromResourceBundle(String value) {
            if (this._bundle == null || value == null) {
                return value;
            }
            String resValue = value.trim();
            if (resValue.startsWith("${") && resValue.endsWith("}")) {
                resValue = resValue.substring(2, resValue.length() - 1);
                return this._bundle.getString(resValue);
            }
            return value;
        }

        private ContentElement.Type _getLinkType(String value) {
            if (value.equals("ACTION")) {
                return ContentElement.Type.ACTIONBUTTON;
            }
            if (value.equals("DEVGUIDE")) {
                return ContentElement.Type.HELPLINK_DEVGUIDE;
            }
            if (value.equals("STEPBYSTEP")) {
                return ContentElement.Type.HELPLINK_STEPBYSTEP;
            }
            if (value.equals("HELPTOPIC")) {
                return ContentElement.Type.HELPLINK_HELPTOPIC;
            }
            if (value.equals("WHATISEE")) {
                return ContentElement.Type.HELPLINK_WHATISEE;
            }
            if (value.equals("CUECARD")) {
                return ContentElement.Type.HELPLINK_CUECARD;
            }
            if (value.equals("TUTORIAL")) {
                return ContentElement.Type.HELPLINK_TUTORIAL;
            }
            if (value.equals("USERGUIDE")) {
                return ContentElement.Type.HELPLINK_USERGUIDE;
            }
            if (value.equals("CUSTOMHELP")) {
                return ContentElement.Type.HELPLINK_CUSTOMHELP;
            }
            return ContentElement.Type.HYPERLINK;
        }

        private class LinkInfo {
            private ContentElement.Type _type;
            private String _id;
            private Icon _icon;
            private String _label;
            private String _targetLink;
            private String _description;

            private LinkInfo() {
            }
        }
    }
}

