/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.checklist;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import oracle.javatools.ui.checklist.ChecklistModel;
import oracle.javatools.ui.checklist.ChecklistModelEvent;
import oracle.javatools.ui.checklist.ChecklistModelListener;
import oracle.javatools.ui.checklist.Step;

public class DefaultChecklistModel
implements ChecklistModel {
    private Vector<Step> _steps = new Vector();
    private Listener _listener;
    private EventListenerList _listenerList = new EventListenerList();

    public DefaultChecklistModel() {
        this._listener = new Listener();
    }

    @Override
    public Step getStepAt(int index) {
        return this._steps.get(index);
    }

    @Override
    public int getStepCount() {
        return this._steps.size();
    }

    @Override
    public int getStepIndex(Step step) {
        return this._steps.indexOf(step);
    }

    @Override
    public Step getSubstepAt(Step step, int index) {
        return step.getSubstepAt(index);
    }

    @Override
    public int getSubstepCount(Step step) {
        return step.getSubstepCount();
    }

    @Override
    public int getSubstepIndex(Step parent, Step child) {
        return parent.getSubstepIndex(child);
    }

    public void addStep(Step step) {
        this._steps.add(step);
        step.setModel(this);
        step.addPropertyChangeListener(this._listener);
        this.fireStepAdded(step, this._steps.size() - 1);
    }

    public void addStep(Step step, int index) {
        this._steps.add(index, step);
        step.setModel(this);
        step.addPropertyChangeListener(this._listener);
        this.fireStepAdded(step, index);
    }

    public void removeStep(Step step) {
        int index = this.getStepIndex(step);
        this._steps.remove(step);
        step.setModel(null);
        step.removePropertyChangeListener(this._listener);
        this.fireStepRemoved(step, index);
    }

    public void removeStepAt(int index) {
        Step step = this._steps.remove(index);
        step.setModel(null);
        this.fireStepRemoved(step, index);
    }

    public void removeAllSteps() {
        for (int i = 0; i < this._steps.size(); ++i) {
            this.removeStepAt(i);
        }
    }

    public void addSubstep(Step parent, Step child) {
        parent.addSubstep(child);
    }

    public void addSubstep(Step parent, Step child, int index) {
        parent.addSubstep(child, index);
    }

    public void removeSubstep(Step parent, Step child) {
        parent.addSubstep(child);
    }

    public void removeSubstepAt(Step parent, int index) {
        Step child = parent.getSubstepAt(index);
        if (child != null) {
            this.removeSubstep(parent, child);
        }
    }

    public void removeAllSubsteps(Step parent) {
        int subCount = parent.getSubstepCount();
        for (int i = 0; i < subCount; ++i) {
            this.removeSubstepAt(parent, i);
        }
    }

    @Override
    public void addChecklistModelListener(ChecklistModelListener l) {
        this._listenerList.add(ChecklistModelListener.class, l);
    }

    @Override
    public void removeChecklistModelListener(ChecklistModelListener l) {
        this._listenerList.remove(ChecklistModelListener.class, l);
    }

    public ChecklistModelListener[] getChecklistModelListeners() {
        return (ChecklistModelListener[])this._listenerList.getListeners(ChecklistModelListener.class);
    }

    protected void fireStepAdded(Step step, int index) {
        Object[] listeners = this._listenerList.getListenerList();
        ChecklistModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChecklistModelListener.class) continue;
            if (e == null) {
                e = new ChecklistModelEvent(this, step.getParent(), step, index, ChecklistModelEvent.Type.STEP_ADDED);
            }
            ((ChecklistModelListener)listeners[i + 1]).stepAdded(e);
        }
    }

    protected void fireStepRemoved(Step step, int index) {
        Object[] listeners = this._listenerList.getListenerList();
        ChecklistModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChecklistModelListener.class) continue;
            if (e == null) {
                e = new ChecklistModelEvent(this, step.getParent(), step, index, ChecklistModelEvent.Type.STEP_REMOVED);
            }
            ((ChecklistModelListener)listeners[i + 1]).stepRemoved(e);
        }
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pe) {
            String name = pe.getPropertyName();
            if ("substepAdded".equals(name)) {
                Step parent = (Step)pe.getSource();
                Step child = (Step)pe.getNewValue();
                DefaultChecklistModel.this.fireStepAdded(child, parent.getSubstepIndex(child));
            } else if ("substepRemoved".equals(name)) {
                Step child = (Step)pe.getNewValue();
                DefaultChecklistModel.this.fireStepRemoved(child, -1);
            }
        }
    }
}

