/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.builders;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.ui.ButtonMenu;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.SuperLabel;
import oracle.javatools.ui.builders.BuiltCombo;
import oracle.javatools.ui.builders.ComboBuilder;
import oracle.javatools.ui.combo.CheckComboModel;
import oracle.javatools.ui.combo.JCheckCombo;
import oracle.javatools.ui.combo.PromptedComboBoxEditor;
import oracle.javatools.ui.combo.SimpleComboModel;
import oracle.javatools.ui.list.ReflectiveListCellRenderer;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.util.CollectionEvent;
import oracle.javatools.util.CollectionListener;

final class BuiltComboImpl<T>
implements BuiltCombo<T> {
    private JComboBox combo;
    private JPanel content = new JPanel((LayoutManager)new MigLayout("ins 0, fill, gapy 4"));
    private ListSelectionModel selectionModel;

    protected BuiltComboImpl(final ComboBuilder.ComboInstructions instructions) {
        String text;
        this.content.setOpaque(false);
        if (instructions.checkedItems != null) {
            this.selectionModel = new DefaultListSelectionModel();
            final SimpleComboModel contentModel = new SimpleComboModel(instructions.items);
            final CheckComboModel model = new CheckComboModel(contentModel, this.selectionModel);
            block0: for (Object item : instructions.checkedItems) {
                for (int i = 0; i < contentModel.getSize(); ++i) {
                    if (contentModel.getElementAt(i) != item) continue;
                    this.selectionModel.addSelectionInterval(i, i);
                    continue block0;
                }
            }
            instructions.checkedItems.addListener(new CollectionListener(){

                public void collectionChanged(CollectionEvent event) {
                    int index = contentModel.indexOf(event.getItem());
                    if (event.getType() == CollectionEvent.Type.ADDITION) {
                        BuiltComboImpl.this.selectionModel.addSelectionInterval(index, index);
                    } else if (event.getType() == CollectionEvent.Type.REMOVAL && index > -1) {
                        BuiltComboImpl.this.selectionModel.removeSelectionInterval(index, index);
                    }
                }
            });
            this.selectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                        Object element = model.getElementAt(i);
                        if (BuiltComboImpl.this.selectionModel.isSelectedIndex(i)) {
                            if (!instructions.checkedItems.contains(element)) {
                                instructions.checkedItems.add(element);
                            }
                        } else if (instructions.checkedItems.contains(element)) {
                            instructions.checkedItems.remove(element);
                        }
                        BuiltComboImpl.this.combo.repaint();
                    }
                }
            });
            this.combo = new JCheckCombo(model, this.selectionModel);
            ((JCheckCombo)this.combo).setCheckComboText(instructions.checkComboText);
        } else {
            this.combo = new JComboBox();
            this.combo.setModel(new SimpleComboModel(instructions.items));
        }
        if (instructions.labelText != null) {
            text = StringUtils.stripMnemonic((String)instructions.labelText);
            int code = StringUtils.getMnemonicKeyCode((String)instructions.labelText);
            JLabel label = new JLabel(text);
            if (code != 0) {
                label.setDisplayedMnemonic(code);
            }
            label.setLabelFor(this.combo);
            this.content.add((Component)label, "gapright 4, grow 0");
        }
        if (instructions.visibleRows > -1) {
            this.combo.setMaximumRowCount(instructions.visibleRows);
        }
        if (instructions.renderUsingMethod != null) {
            this.combo.setRenderer(new ReflectiveListCellRenderer(instructions.renderUsingMethod));
        }
        if (instructions.renderer != null) {
            this.combo.setRenderer(instructions.renderer);
        }
        if (instructions.editable) {
            this.combo.setEditable(true);
            PromptedComboBoxEditor editor = new PromptedComboBoxEditor(instructions.promptText);
            this.combo.setEditor(editor);
        }
        if (instructions.selection != null) {
            this.combo.setSelectedItem(instructions.selection);
        } else if (instructions.editable) {
            this.combo.setSelectedIndex(-1);
        } else if (this.combo.getModel().getSize() > 0) {
            this.combo.setSelectedIndex(0);
        }
        this.content.add(this.combo);
        for (Action action : instructions.primaryActions) {
            JButton button = new JButton(action);
            if (button.getText() == null || button.getText().length() == 0) {
                IconicButtonUI.install(button);
            }
            this.content.add(button);
        }
        if (!instructions.secondaryActions.isEmpty()) {
            text = null;
            int mnemonic = 0;
            if (instructions.secondaryActionsText != null) {
                mnemonic = StringUtils.getMnemonicKeyCode((String)instructions.secondaryActionsText);
                text = mnemonic != 0 ? StringUtils.stripMnemonic((String)instructions.secondaryActionsText) : instructions.secondaryActionsText;
            }
            ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
            for (Action action : instructions.secondaryActions) {
                items.add(new JMenuItem(action));
            }
            JToggleButton buttonMenu = ButtonMenu.createButtonMenu(text, instructions.secondaryActionsIcon, items);
            if (mnemonic != 0) {
                buttonMenu.setMnemonic(mnemonic);
            }
            this.content.add((Component)buttonMenu, "growy");
        }
        if (instructions.hintText != null) {
            final SuperLabel hint = new SuperLabel(instructions.hintText);
            hint.setLabelOverride(true);
            hint.setForeground(Colors.HINT_TEXT);
            String constraint = instructions.labelText != null ? "newline, skip, span" : "newline, span";
            this.content.add((Component)hint, constraint);
            this.combo.addPropertyChangeListener("enabled", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    hint.setEnabled(BuiltComboImpl.this.combo.isEnabled());
                }
            });
        }
        for (ActionListener listener : instructions.actionListeners) {
            this.combo.addActionListener(listener);
        }
    }

    @Override
    public JComboBox getJComboBox() {
        return this.combo;
    }

    @Override
    public List<T> getListModel() {
        if (this.combo.getModel() instanceof SimpleComboModel) {
            return ((SimpleComboModel)this.combo.getModel()).asList();
        }
        return null;
    }

    @Override
    public JComponent getGUI() {
        return this.content;
    }

    @Override
    public T getSelectedValue() {
        return (T)this.combo.getSelectedItem();
    }
}

