/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.breadcrumbs;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboPopup;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsListener;
import oracle.javatools.ui.breadcrumbs.JBreadcrumbs;
import oracle.javatools.ui.breadcrumbs.PopupItem;
import oracle.javatools.ui.breadcrumbs.PopupProvider;
import oracle.javatools.ui.breadcrumbs.PopupRenderer;

public class PopupHandler {
    private JBreadcrumbs breadcrumbs;
    private BreadcrumbsL breadcrumbsL = new BreadcrumbsL();
    private ActionListener itemActionL = new ItemActionL();
    private PopupProvider provider;
    private FocusL focusL = new FocusL();
    private JComboBox popupCombo = new JComboBox();
    private BasicComboPopup popup = new BasicComboPopup(this.popupCombo){

        @Override
        public boolean isFocusTraversable() {
            return true;
        }

        @Override
        protected void installKeyboardActions() {
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (list.getModel().getSize() > 0) {
                        if (comboBox.getSelectedIndex() != list.getSelectedIndex()) {
                            comboBox.setSelectedIndex(list.getSelectedIndex());
                        } else {
                            comboBox.getEditor().setItem(list.getSelectedValue());
                        }
                    }
                }
            };
            String SELECT_ITEM = "select-item";
            this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "select-item");
            this.getActionMap().put("select-item", action);
        }
    };
    protected static final String KEY_POPUP_ITEM = "KEY_POPUP_ITEM";

    public PopupHandler() {
        this.popupCombo.setRenderer(new PopupRenderer());
        this.popupCombo.setMaximumRowCount(20);
    }

    public void attach(JBreadcrumbs breadcrumbs, PopupProvider provider) {
        this.breadcrumbs = breadcrumbs;
        this.provider = provider;
        this.breadcrumbs.addBreadcrumbsListener(this.breadcrumbsL);
        this.popupCombo.addActionListener(this.itemActionL);
    }

    public void detatch() {
        this.breadcrumbs.removeBreadcrumbsListener(this.breadcrumbsL);
        this.popupCombo.removeAllItems();
        this.popupCombo.removeActionListener(this.itemActionL);
        this.provider = null;
    }

    protected void separatorClicked(Breadcrumb crumb, Rectangle separatorBounds) {
        List<PopupItem> itemList = this.getPopupItems(crumb);
        if (itemList == null || itemList.isEmpty()) {
            return;
        }
        this.popupCombo.setModel(new DefaultComboBoxModel<Object>(itemList.toArray()));
        this.popup.getList().setVisibleRowCount(Math.min(50, itemList.size()));
        this.popup.getList().setFocusable(true);
        this.popup.setFocusable(true);
        this.popupCombo.setSelectedIndex(-1);
        this.popup.getList().setFixedCellHeight(-1);
        this.popup.show(this.breadcrumbs, separatorBounds.x, this.breadcrumbs.getHeight() - 1);
        this.popup.getList().setSelectedIndex(0);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PopupHandler.this.popup.getList().requestFocus();
            }
        });
        final Window w = SwingUtilities.getWindowAncestor(this.breadcrumbs);
        if (w != null) {
            w.addWindowFocusListener(this.focusL);
            this.popup.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    PopupHandler.this.popup.removePopupMenuListener(this);
                    w.removeWindowFocusListener(PopupHandler.this.focusL);
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
    }

    protected List<PopupItem> getPopupItems(Breadcrumb breadcrumb) {
        if (this.provider == null) {
            throw new IllegalStateException("PopupHandler has null PopupProvider");
        }
        return this.provider.getPopupItems(breadcrumb);
    }

    private class FocusL
    implements WindowFocusListener {
        private FocusL() {
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            PopupHandler.this.popup.getList().requestFocus();
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            Window w = e.getOppositeWindow();
            if (w == null | w != SwingUtilities.getWindowAncestor(PopupHandler.this.popup)) {
                PopupHandler.this.popup.hide();
            }
        }
    }

    private class ItemActionL
    implements ActionListener {
        private ItemActionL() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PopupHandler.this.popup.setVisible(false);
            PopupItem pItem = (PopupItem)PopupHandler.this.popupCombo.getSelectedItem();
            if (pItem == null) {
                return;
            }
            PopupHandler.this.provider.itemSelected(pItem);
        }
    }

    private class BreadcrumbsL
    implements BreadcrumbsListener {
        private BreadcrumbsL() {
        }

        public void breadcrumbClicked(Breadcrumb crumb) {
        }

        public void breadcrumbContextClicked(Breadcrumb crumb, Point p) {
        }

        public void showBreadcrumbPeek(Breadcrumb crumb, Rectangle peekLocation) {
        }

        @Override
        public void hideBreadcrumbPeek() {
        }

        public void separatorClicked(Breadcrumb crumb, Rectangle separatorBounds) {
            PopupHandler.this.separatorClicked(crumb, separatorBounds);
        }
    }
}

