/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.breadcrumbs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import oracle.javatools.ui.breadcrumbs.AttributedBreadcrumb;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsButton;
import oracle.javatools.ui.simplestyle.StyledTextRenderer;

public class BreadcrumbsButtonUI
extends ButtonUI {
    protected static final Stroke lineStroke = new BasicStroke(0.75f, 1, 1);
    protected static final Stroke focusStroke = new BasicStroke(3.0f, 1, 1);
    private BasicButtonListener listener;

    protected BreadcrumbsButtonUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return new BreadcrumbsButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        BreadcrumbsButton b = (BreadcrumbsButton)c;
        this.listener = new BasicButtonListener(b);
        b.addMouseListener(this.listener);
        b.addMouseMotionListener(this.listener);
        b.addFocusListener(this.listener);
        b.addPropertyChangeListener(this.listener);
        b.addChangeListener(this.listener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        BreadcrumbsButton b = (BreadcrumbsButton)c;
        b.removeMouseListener(this.listener);
        b.removeMouseMotionListener(this.listener);
        b.removeFocusListener(this.listener);
        b.removePropertyChangeListener(this.listener);
        b.removeChangeListener(this.listener);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        BreadcrumbsButton b = (BreadcrumbsButton)c;
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(lineStroke);
        Shape shape = this.createShape(b);
        this.paintBackground(b, g2, shape);
        if (b.getModel().isSelected()) {
            this.paintSelection(b, g2, shape);
        }
        if (b.getModel().isRollover()) {
            this.paintRollover(b, g2, shape);
        }
        if (b.getModel().isPressed()) {
            this.paintPressed(b, g2, shape);
        }
        if (b.hasFocus()) {
            this.paintFocus(b, g2, shape);
        }
        this.paintText(b, g2, shape);
        this.paintBorder(b, g2, shape);
        g2.dispose();
    }

    protected Shape createShape(BreadcrumbsButton b) {
        int h = (b.getHeight() - 1) / 2;
        int x = b.getIndex() == 0 ? 0 : 4;
        int w = b.getWidth() - 1;
        GeneralPath boundsPath = new GeneralPath();
        boundsPath.moveTo(x, 0.0f);
        boundsPath.lineTo(w - h, 0.0f);
        boundsPath.lineTo(w, h);
        boundsPath.lineTo(w - h, b.getHeight() - 1);
        boundsPath.lineTo(x, b.getHeight() - 1);
        if (b.getIndex() > 0) {
            boundsPath.lineTo(x + h, h);
        }
        boundsPath.lineTo(x, 0.0f);
        return boundsPath;
    }

    protected void paintFocus(BreadcrumbsButton b, Graphics2D g2, Shape shape) {
        g2.setColor(UIManager.getColor("Button.focus"));
        g2.setStroke(focusStroke);
        g2.draw(shape);
        g2.setStroke(lineStroke);
    }

    protected void paintBackground(BreadcrumbsButton b, Graphics2D g2, Shape shape) {
        Breadcrumb breadcrumb = b.getBreadcrumb();
        AttributedBreadcrumb attributedBreadcrumb = breadcrumb instanceof AttributedBreadcrumb ? (AttributedBreadcrumb)((Object)breadcrumb) : null;
        Color bgColor = b.getBackground();
        bgColor = attributedBreadcrumb != null && attributedBreadcrumb.hasAttribute(AttributedBreadcrumb.Attribute.BACKGROUND_COLOR) ? (Color)attributedBreadcrumb.getAttribute(AttributedBreadcrumb.Attribute.BACKGROUND_COLOR) : UIManager.getColor("List.background");
        g2.setColor(bgColor);
        g2.fill(shape);
    }

    protected void paintRollover(BreadcrumbsButton b, Graphics2D g2, Shape shape) {
        g2.setColor(UIManager.getColor("TextArea.selectionBackground"));
        g2.fill(shape);
    }

    protected void paintPressed(BreadcrumbsButton b, Graphics2D g2, Shape shape) {
    }

    protected void paintSelection(BreadcrumbsButton b, Graphics2D g2, Shape shape) {
        g2.setColor(UIManager.getColor("TextArea.selectionBackground"));
        g2.fill(shape);
    }

    protected void paintBorder(BreadcrumbsButton b, Graphics2D g2, Shape shape) {
        g2.setColor(UIManager.getColor("ScrollBar.thumbShadow"));
        g2.draw(shape);
    }

    protected void paintText(BreadcrumbsButton b, Graphics2D g2, Shape shape) {
        if (b.getModel().isRollover()) {
            g2.setColor(UIManager.getColor("TextField.selectionForeground"));
        } else {
            AttributedBreadcrumb attributedBreadcrumb;
            Breadcrumb breadcrumb = b.getBreadcrumb();
            AttributedBreadcrumb attributedBreadcrumb2 = attributedBreadcrumb = breadcrumb instanceof AttributedBreadcrumb ? (AttributedBreadcrumb)((Object)breadcrumb) : null;
            if (attributedBreadcrumb != null && attributedBreadcrumb.hasAttribute(AttributedBreadcrumb.Attribute.FOREGROUND_COLOR)) {
                g2.setColor((Color)attributedBreadcrumb.getAttribute(AttributedBreadcrumb.Attribute.FOREGROUND_COLOR));
            } else {
                g2.setColor(UIManager.getColor("TextField.foreground"));
            }
        }
        StyledTextRenderer.renderText(b, g2, b.getStyledText(), b.getInsets().left + 2, b.getInsets().top);
    }

    public Icon getPeersIcon() {
        return DownIcon.INSTANCE;
    }

    private static class DownIcon
    implements Icon {
        private static final DownIcon INSTANCE = new DownIcon();
        private static final GeneralPath shape = new GeneralPath();

        private DownIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            g2.translate(x, y + 1);
            g.setColor(UIManager.getColor("Label.foreground"));
            g2.fill(shape);
            g2.translate(-x, -y - 1);
        }

        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }

        static {
            shape.moveTo(0.0f, 2.0f);
            shape.lineTo(7.0f, 2.0f);
            shape.lineTo(3.0f, 6.0f);
        }
    }
}

