/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.UIManager;
import javax.swing.border.Border;

public final class SmallSquareButtonBorder
implements Border {
    private static final Insets INSETS = new Insets(2, 2, 2, 2);

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component comp, Graphics g, int x, int y, int w, int h) {
        AbstractButton ab;
        if (comp instanceof AbstractButton && (ab = (AbstractButton)comp).isRolloverEnabled() && !ab.getModel().isRollover()) {
            return;
        }
        g.translate(x, y);
        Color fg = comp.isEnabled() ? comp.getForeground() : UIManager.getColor("textInactiveText");
        g.setColor(fg);
        g.drawLine(2, 0, w - 3, 0);
        g.drawLine(0, 2, 0, h - 3);
        g.drawLine(2, h - 1, w - 3, h - 1);
        g.drawLine(w - 1, 2, w - 1, h - 3);
        Color c = new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), fg.getAlpha() * 4 / 7);
        g.setColor(c);
        g.drawLine(0, 1, 1, 1);
        g.drawLine(1, 0, 1, 1);
        g.drawLine(w - 1, 1, w - 2, 1);
        g.drawLine(w - 2, 0, w - 2, 1);
        g.drawLine(w - 1, h - 2, w - 2, h - 2);
        g.drawLine(w - 2, h - 1, w - 2, h - 2);
        g.drawLine(0, h - 2, 1, h - 2);
        g.drawLine(1, h - 1, 1, h - 2);
        g.translate(-x, -y);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return INSETS;
    }
}

