/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.border;

import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import oracle.javatools.ui.border.ShadowGradient;

final class ShadowGradientPaint
implements Paint {
    private int _shadeSize;
    private Color _color;
    private Rectangle2D _rect;
    private double _shadeIntensity;

    ShadowGradientPaint(Rectangle2D rect, int shadeSize, double shadeIntensity, Color color) {
        this._shadeSize = shadeSize;
        this._shadeIntensity = shadeIntensity;
        this._color = color;
        this._rect = new Rectangle2D.Double(rect.getX() + (double)shadeSize, rect.getY() + (double)shadeSize, rect.getWidth() - (double)(2 * shadeSize) + 1.0, rect.getHeight() - (double)(2 * shadeSize) + 1.0);
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        Point2D.Double topLeft = new Point2D.Double(this._rect.getX(), this._rect.getY());
        Point2D.Double bottomRight = new Point2D.Double(this._rect.getX() + this._rect.getWidth(), this._rect.getY() + this._rect.getHeight());
        Point2D xformedTopLeft = xform.transform(topLeft, null);
        Point2D xformedBottomRight = xform.transform(bottomRight, null);
        Rectangle xformedRect = new Rectangle((int)xformedTopLeft.getX(), (int)xformedTopLeft.getY(), (int)(xformedBottomRight.getX() - xformedTopLeft.getX()) - 1, (int)(xformedBottomRight.getY() - xformedTopLeft.getY()) - 1);
        return new ShadowGradient(xformedRect, this._color, this._shadeSize, this._shadeIntensity);
    }

    @Override
    public int getTransparency() {
        return 3;
    }
}

