/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.actiontip;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import net.miginfocom.swing.MigLayout;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.javatools.ui.actiontip.ActionTipManager;
import oracle.javatools.ui.actiontip.ActionTipTask;
import oracle.javatools.ui.actiontip.DefaultActionTipComponent;

final class Tester {
    private ActionTipTask tipTask;
    private JEditorPane editor;

    public Tester() {
        JFrame frame = new JFrame("TextCorrectUI");
        frame.setDefaultCloseOperation(3);
        frame.setSize(600, 400);
        frame.setLocationRelativeTo(null);
        frame.setLayout(new BorderLayout(10, 10));
        JPanel p = new JPanel(new BorderLayout(5, 5));
        p.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        frame.add(p);
        this.editor = new JEditorPane();
        InputStreamReader r = new InputStreamReader(Tester.class.getResourceAsStream("Tester.class"));
        BufferedReader br = new BufferedReader(r);
        StringBuffer sb = new StringBuffer();
        try {
            String s = br.readLine();
            while (s != null) {
                sb.append(s);
                sb.append('\n');
                s = br.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.editor.setText(sb.toString());
        JPanel controlPanel = new JPanel((LayoutManager)new MigLayout("gap 10px 5px, top, left"));
        JButton tipButton = new JButton("Show Tip");
        tipButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tester.this.tipTask = new TestTask();
                ActionTipManager.getActionTipManager().submitTipTask(Tester.this.tipTask);
            }
        });
        controlPanel.add((Component)tipButton, "span, wrap");
        JButton cancelButton = new JButton("API Cancel Latest Queued Tip");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionTipManager.getActionTipManager().cancelTipTask(Tester.this.tipTask);
            }
        });
        controlPanel.add((Component)cancelButton, "span, wrap");
        final JSpinner delay = new JSpinner(new SpinnerNumberModel(ActionTipManager.getTipDisplayDuration(), 500, 50000, 100));
        delay.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ActionTipManager.setTipDisplayDuration((Integer)delay.getValue());
            }
        });
        controlPanel.add(new JLabel("Tip Delay (ms): "));
        controlPanel.add((Component)delay, "wrap");
        p.add((Component)new JScrollPane(this.editor), "Center");
        p.add((Component)controlPanel, "East");
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new OracleLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        new Tester();
    }

    private class TestTask
    implements ActionTipTask {
        private Rectangle r;

        private TestTask() {
            try {
                Rectangle dotRect = Tester.this.editor.modelToView(Tester.this.editor.getCaret().getDot());
                Rectangle markRect = Tester.this.editor.modelToView(Tester.this.editor.getCaret().getMark());
                this.r = new Rectangle(dotRect);
                this.r.add(markRect);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        @Override
        public JComponent getActionTipContent() {
            DefaultActionTipComponent c = new DefaultActionTipComponent((ActionTipTask)this, "Title:", "oracle.java.Detail");
            c.setBackground(new Color(255, 255, 235));
            return c;
        }

        @Override
        public JComponent getParentComponent() {
            return Tester.this.editor;
        }

        @Override
        public Rectangle getLocation() {
            return this.r;
        }

        @Override
        public void actionTipResult(ActionTipManager.TaskResult result) {
            System.out.println(result.name());
        }

        @Override
        public boolean isCancelable() {
            return true;
        }
    }
}

