/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.actiontip;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.Icon;

class CancelIcon
implements Icon {
    static final CancelIcon INSTANCE = new CancelIcon(false, false);
    static final CancelIcon INSTANCE_ROLLOVER = new CancelIcon(true, false);
    static final CancelIcon INSTANCE_PRESSED = new CancelIcon(false, true);
    public static final Color COLOR = Color.RED;
    public static final Color COLOR_ROLLOVER = new Color(0, 0, 0, 50);
    public static final Color COLOR_PRESSED = new Color(0, 0, 0, 70);
    public static final int SIZE = 6;
    public static final Insets INSETS = new Insets(0, 4, 0, 5);
    public static final Stroke stroke = new BasicStroke(2.0f);
    private boolean isRollover;
    private boolean isPressed;

    private CancelIcon(boolean isRollover, boolean isPressed) {
        this.isRollover = isRollover;
        this.isPressed = isPressed;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.isRollover) {
            g2.setColor(COLOR_ROLLOVER);
            g2.fillRoundRect(2, 2, c.getWidth() - 3, c.getHeight() - 3, 5, 5);
        }
        if (this.isPressed) {
            g2.setColor(COLOR_PRESSED);
            g2.fillRoundRect(1, 1, c.getWidth() - 1, c.getHeight() - 1, 5, 5);
        }
        g2.setStroke(stroke);
        g2.setColor(Color.RED);
        g2.translate(x, y);
        g2.drawLine(CancelIcon.INSETS.left, CancelIcon.INSETS.top, 6 + CancelIcon.INSETS.left, 6 + CancelIcon.INSETS.top);
        g2.drawLine(6 + CancelIcon.INSETS.left, CancelIcon.INSETS.top, CancelIcon.INSETS.left, 6 + CancelIcon.INSETS.top);
    }

    @Override
    public int getIconWidth() {
        return 6 + CancelIcon.INSETS.left + CancelIcon.INSETS.right;
    }

    @Override
    public int getIconHeight() {
        return 6 + CancelIcon.INSETS.top + CancelIcon.INSETS.bottom;
    }
}

