/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.LabelUI;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.javatools.ui.AttributedStringBuilder;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.SuperTextAttribute;
import oracle.javatools.ui.plaf.SuperLabelUI;
import oracle.javatools.util.PlatformUtils;

public class SuperLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    private int preferredWrapWidth = 100000;
    private boolean useFontOverride = false;
    private static final AttributedString EMPTY_TEXT = new AttributedString("");
    private AttributedString aText = EMPTY_TEXT;
    private Set<ActionListener> actionListeners = new CopyOnWriteArraySet<ActionListener>();
    private Color hyperlinkForeground = Colors.HYPERLINK;
    private boolean requireModifierForHyperlink = false;
    private boolean paintHyperlink = true;
    public static final int ACTION_HYPERLINK = 100001;
    private List<HyperlinkRun> hyperlinkRuns;
    private static final String quote = "\nFacts are stubborn things; and whatever may be our wants wishes, our inclinations, or the dictates of our passion, they cannot alter the state of ";
    private static final String quote2 = "facts and evidence.\n";

    public SuperLabel() {
    }

    public SuperLabel(AttributedString attributedstring) {
        this.setAttributedText(attributedstring);
    }

    public SuperLabel(String text) {
        this.setText(text);
    }

    public void addActionListener(ActionListener al) {
        this.actionListeners.add(al);
    }

    public void removeActionListener(ActionListener al) {
        this.actionListeners.remove(al);
    }

    public void addHyperlink(int firstIndex, int lastIndex, String value) {
        int len = this.aText.getIterator().getEndIndex();
        if (firstIndex < 0 || lastIndex < 1 || lastIndex <= firstIndex || firstIndex >= len || lastIndex >= len) {
            throw new IllegalArgumentException("index out of bounds.");
        }
        this.hyperlinkRuns.add(new HyperlinkRun(firstIndex, lastIndex, value));
        Collections.sort(this.hyperlinkRuns);
    }

    public void fireActionEvent(int id, String command) {
        ActionEvent event = new ActionEvent(this, id, command);
        for (ActionListener al : this.actionListeners) {
            al.actionPerformed(event);
        }
    }

    public void setPreferredWrapWidth(int preferredWidth) {
        this.preferredWrapWidth = preferredWidth;
    }

    public int getPreferredWrapWidth() {
        return this.preferredWrapWidth;
    }

    @Override
    public void setUI(LabelUI labelUI) {
        super.setUI(SuperLabelUI.createUI(this));
    }

    public void setAttributedText(AttributedString aText) {
        this.aText = aText == null ? EMPTY_TEXT : aText;
        this.overrideFont();
        this.processHyperlinks();
    }

    public AttributedString getAttributedText() {
        return this.aText;
    }

    @Override
    public void setText(String string) {
        this.setAttributedText(string == null ? EMPTY_TEXT : new AttributedString(string));
    }

    @Override
    public String getText() {
        return this.aText == EMPTY_TEXT ? null : AttributedStringBuilder.toString(this.aText);
    }

    @Override
    public void setDisplayedMnemonicIndex(int index) throws IllegalArgumentException {
        if (index < 0) {
            return;
        }
        super.setDisplayedMnemonicIndex(index);
        this.markMnemonic('\uffff', index);
    }

    @Override
    public void setDisplayedMnemonic(int key) {
        super.setDisplayedMnemonic(key);
        String s = KeyEvent.getKeyText(key);
        if (s.length() == 1) {
            this.markMnemonic(s.charAt(0), -1);
        }
    }

    private char markMnemonic(char c, int index) {
        c = Character.toLowerCase(c);
        AttributedCharacterIterator it = this.aText.getIterator();
        int i = 0;
        char itC = Character.toLowerCase(it.first());
        while (itC != '\uffff') {
            if (itC == c || index == i) {
                this.aText.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL, i, i + 1);
                return itC;
            }
            itC = Character.toLowerCase(it.next());
            ++i;
        }
        return '\uffff';
    }

    @Override
    @Deprecated
    public void setDisabledIcon(Icon disabledIcon) {
        super.setDisabledIcon(disabledIcon);
    }

    @Override
    @Deprecated
    public void setIcon(Icon icon) {
        super.setIcon(icon);
    }

    private void overrideFont() {
        if (this.aText == null || !this.useFontOverride) {
            return;
        }
        Font f = this.getFont();
        if (f != null) {
            this.adjustTextForLabelDefaults(this.aText, TextAttribute.SIZE, f.getSize());
            if (!PlatformUtils.isWindows()) {
                this.adjustTextForLabelDefaults(this.aText, TextAttribute.FAMILY, f.getFamily());
            }
            this.adjustTextForLabelDefaults(this.aText, TextAttribute.WEIGHT, f.isBold() ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
            this.adjustTextForLabelDefaults(this.aText, TextAttribute.POSTURE, f.isItalic() ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
            this.adjustTextForLabelDefaults(this.aText, TextAttribute.UNDERLINE, f.getAttributes().get(TextAttribute.UNDERLINE));
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.overrideFont();
    }

    private void adjustTextForLabelDefaults(AttributedString as, AttributedCharacterIterator.Attribute attribute, Object value) {
        AttributedCharacterIterator it = as.getIterator();
        int s = 0;
        int e = 0;
        it.first();
        while (s < it.getEndIndex()) {
            e = it.getRunLimit(attribute);
            if (e > s) {
                as.addAttribute(attribute, value, s, e);
            }
            s = e;
            it.setIndex(s);
        }
    }

    public void setLabelOverride(boolean useFontOverride) {
        this.useFontOverride = useFontOverride;
        this.overrideFont();
    }

    public boolean isLabelOverride() {
        return this.useFontOverride;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new OracleLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.setLayout(new BorderLayout());
        f.getContentPane().setBackground(Color.WHITE);
        HashMap<TextAttribute, Number> map = new HashMap<TextAttribute, Number>();
        AttributedStringBuilder<TextAttribute, Float> asb = new AttributedStringBuilder<TextAttribute, Float>("Facts", TextAttribute.SIZE, Float.valueOf(20.0f));
        asb.append(quote);
        asb.append(quote2, TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        asb.append("\nThomas Jefferson", TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        map = new HashMap();
        map.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
        map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        asb.append("   July, 1806", map);
        asb.append("\nLink 1", (TextAttribute)((Object)SuperTextAttribute.HYPERLINK), (Float)((Object)"Link #1"));
        asb.append(" ");
        asb.append("Link 2", (TextAttribute)((Object)SuperTextAttribute.HYPERLINK), (Float)((Object)"Link #2"));
        asb.append("\nwikipedia link to Thomas Jefferson", (TextAttribute)((Object)SuperTextAttribute.HYPERLINK), (Float)((Object)"Link #3"));
        AttributedString as = asb.toAttributedString();
        map = new HashMap();
        as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON, 57, 62);
        as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL, 126, 132);
        SuperLabel label = new SuperLabel(as);
        label.addHyperlink(6, 6 + quote.length() - 1, "WoooOOOOoooo");
        label.setPreferredWrapWidth(250);
        label.addActionListener(e -> System.out.println("Link clicked: " + e.getActionCommand()));
        f.add(label);
        JButton button = new JButton("Press Me");
        label.setLabelFor(button);
        label.setDisplayedMnemonicIndex(3);
        JPanel p2 = new JPanel(new BorderLayout(4, 4));
        p2.add((Component)button, "North");
        p2.add((Component)new JButton("Not Me"), "South");
        f.add((Component)p2, "East");
        f.pack();
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }

    private void processHyperlinks() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.processHyperlinks());
            return;
        }
        if (this.hyperlinkRuns == null) {
            this.hyperlinkRuns = new ArrayList<HyperlinkRun>();
        }
        this.hyperlinkRuns.clear();
        if (this.aText == null) {
            return;
        }
        AttributedCharacterIterator it = this.aText.getIterator();
        if (it.getEndIndex() == 0) {
            return;
        }
        int start = it.getRunStart(SuperTextAttribute.HYPERLINK);
        while (start >= 0) {
            int end = it.getRunLimit(SuperTextAttribute.HYPERLINK);
            Object value = it.getAttribute(SuperTextAttribute.HYPERLINK);
            if (value != null) {
                if (!(value instanceof String)) {
                    throw new IllegalStateException("SuperTextAttribute.HYPERLINK given a non-String value");
                }
                HyperlinkRun run = new HyperlinkRun(start, end, (String)value);
                this.hyperlinkRuns.add(run);
            }
            if (end + 1 >= it.getEndIndex()) break;
            it.setIndex(end + 1);
            start = it.getRunStart(SuperTextAttribute.HYPERLINK);
        }
    }

    public void setHyperlinkForeground(Color hyperlinkForeground) {
        this.hyperlinkForeground = hyperlinkForeground;
    }

    public Color getHyperlinkForeground() {
        return this.hyperlinkForeground;
    }

    public List<HyperlinkRun> getHyperlinkRuns() {
        return Collections.unmodifiableList(this.hyperlinkRuns);
    }

    public void setRequireModifierForHyperlink(boolean requireModifierForHyperlink) {
        this.requireModifierForHyperlink = requireModifierForHyperlink;
    }

    public boolean isRequireModifierForHyperlink() {
        return this.requireModifierForHyperlink;
    }

    public void setPaintHyperlink(boolean paintHyperlink) {
        this.paintHyperlink = paintHyperlink;
    }

    public boolean isPaintHyperlink() {
        return this.paintHyperlink;
    }

    public static final class HyperlinkRun
    implements Comparable {
        public final int firstIndex;
        public final int lastIndex;
        public final String value;

        HyperlinkRun(int firstIndex, int lastIndex, String value) {
            this.firstIndex = firstIndex;
            this.lastIndex = lastIndex;
            this.value = value;
        }

        public String toString() {
            return this.value + " " + this.firstIndex + ":" + this.lastIndex;
        }

        public int compareTo(Object o) {
            if (o instanceof HyperlinkRun) {
                return Integer.compare(this.firstIndex, ((HyperlinkRun)o).firstIndex);
            }
            return -1;
        }
    }
}

