/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import oracle.javatools.ui.Colors;

public final class LinkTextField
extends JTextField {
    private Action _action;
    private Handler _handler;

    public LinkTextField() {
        this._init();
    }

    public LinkTextField(String text) {
        super(text);
        this._init();
    }

    public LinkTextField(int columns) {
        super(columns);
        this._init();
    }

    public LinkTextField(String text, int columns) {
        super(text, columns);
        this._init();
    }

    public LinkTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this._init();
    }

    public void setLinkAction(Action a) {
        this._action = a;
    }

    public Action getLinkAction() {
        return this._action;
    }

    private void _init() {
        this.setForeground(Colors.HYPERLINK);
        this._handler = new Handler();
        this.addMouseListener(this._handler);
        this.addKeyListener(this._handler);
    }

    private class Handler
    extends MouseAdapter
    implements KeyListener {
        private Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            Action a;
            int pos;
            if (LinkTextField.this.isEnabled() && me.isControlDown() && SwingUtilities.isLeftMouseButton(me) && (pos = LinkTextField.this.viewToModel(me.getPoint())) >= 0 && pos <= LinkTextField.this.getDocument().getLength() && (a = LinkTextField.this.getLinkAction()) != null) {
                a.actionPerformed(new ActionEvent(LinkTextField.this, 1001, LinkTextField.this.getText(), EventQueue.getMostRecentEventTime(), me.getModifiers()));
            }
        }

        @Override
        public void keyPressed(KeyEvent ke) {
            Action a;
            boolean hasText;
            boolean bl = hasText = LinkTextField.this.getText() != null && LinkTextField.this.getText().trim().length() > 0;
            if (LinkTextField.this.isEnabled() && hasText && (LinkTextField.this.getText() != null || !"".equals(LinkTextField.this.getText())) && ke.isControlDown() && ke.getKeyCode() == 32 && (a = LinkTextField.this.getLinkAction()) != null) {
                a.actionPerformed(new ActionEvent(LinkTextField.this, 1001, LinkTextField.this.getText(), EventQueue.getMostRecentEventTime(), ke.getModifiers()));
            }
        }

        @Override
        public void keyReleased(KeyEvent ke) {
        }

        @Override
        public void keyTyped(KeyEvent ke) {
        }
    }
}

