/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf2;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.metal.MetalCheckBoxUI;
import oracle.bali.ewt.olaf2.OracleButtonListener;

public class OracleCheckBoxUI
extends MetalCheckBoxUI {
    private static boolean _sJDK14 = false;
    private static final OracleCheckBoxUI _INSTANCE;

    public static ComponentUI createUI(JComponent component) {
        return _INSTANCE;
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new OracleButtonListener(b);
    }

    @Override
    public synchronized void paint(Graphics g, JComponent c) {
        AbstractButton b;
        super.paint(g, c);
        if (_sJDK14 && c.getClientProperty("html") != null && (b = (AbstractButton)c).hasFocus() && b.isFocusPainted()) {
            Dimension size = c.getSize();
            Rectangle viewRect = new Rectangle(size);
            Rectangle iconRect = new Rectangle();
            Rectangle textRect = new Rectangle();
            Insets i = c.getInsets();
            viewRect.x += i.left;
            viewRect.y += i.top;
            viewRect.width -= i.right + viewRect.x;
            viewRect.height -= i.bottom + viewRect.y;
            Icon altIcon = b.getIcon();
            SwingUtilities.layoutCompoundLabel(c, g.getFontMetrics(), b.getText(), altIcon != null ? altIcon : this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getIconTextGap());
            if (textRect.width > 0 && textRect.height > 0) {
                this.paintFocus(g, textRect, size);
            }
        }
    }

    static {
        String version = System.getProperty("java.version");
        _sJDK14 = version.startsWith("1.4");
        _INSTANCE = new OracleCheckBoxUI();
    }
}

