/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.spi;

import oracle.ide.model.Dependable;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.jdeveloper.deploy.DependableFactory;
import oracle.jdeveloper.deploy.spi.Cookie;
import oracle.jdeveloper.deploy.spi.DependableFactory;
import oracle.jdeveloper.deploy.spi.providers.AbstractDependableFactoryProvider;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;
import oracle.jdevimpl.deploy.common.DefaultNodeDependable;

public abstract class NodeDependableFactoryProvider
extends AbstractDependableFactoryProvider {
    @Override
    protected boolean canCreate(Element element, ToolkitContext tkContext, Cookie cookie) {
        if (!(element instanceof Node)) {
            return false;
        }
        DependableFactory.SpiData spi = new DependableFactory.SpiData(tkContext.getIdeContext());
        if (spi.getDepth() != DependableFactory.Parms.Depth.SELF) {
            return false;
        }
        if (!this.canCreateForNode((Node)element, tkContext, cookie)) {
            return false;
        }
        Element folder = spi.getParent();
        if (folder == null || folder instanceof Folder) {
            cookie.bind(Node.class, element);
            cookie.bind(Folder.class, folder);
            return true;
        }
        return false;
    }

    protected boolean canCreateForNode(Node node, ToolkitContext tkContext, Cookie cookie) {
        return this.getNodeClass().isAssignableFrom(node.getClass());
    }

    protected abstract Class<? extends Node> getNodeClass();

    @Override
    protected Dependable[] createDependables(Element element, Cookie cookie) {
        Node node = cookie.get(Node.class);
        Folder folder = cookie.get(Folder.class);
        return new Dependable[]{new DefaultNodeDependable(node, folder)};
    }

    @Override
    protected Class getTypeForNarrow() {
        return Node.class;
    }
}

