/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.hook;

import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.util.MetaClass;
import oracle.jdeveloper.deploy.spi.profilesupport.CommandFactory;
import oracle.jdeveloper.deploy.spi.profilesupport.ProfileFactory;
import oracle.jdeveloper.deploy.spi.profilesupport.ProfileHashIO;
import oracle.jdeveloper.deploy.spi.profilesupport.ProfileInfo;
import oracle.jdeveloper.deploy.spi.profilesupport.ProfileRecognizer;
import oracle.jdeveloper.deploy.spi.profilesupport.ProfileSupport;
import oracle.jdevimpl.deploy.hook.BaseElementVisitor;
import oracle.jdevimpl.deploy.hook.HookProfileSupport;
import oracle.jdevimpl.deploy.hook.ProfileInfoHandler;
import oracle.jdevimpl.deploy.hook.ProfileSupportBase;

public class ProfileSupportHandler
extends ProfileSupportBase
implements ElementVisitorFactory {
    static final ElementName EN_PROFILE_SUPPORT = ProfileSupportHandler.e("profile-support");
    private ProfileSupportElementsHandler pseHandler = new ProfileSupportElementsHandler();
    private ProfileInfoHandler psiHandler = new ProfileInfoHandler();
    private static final String PROFILE_SUPPORT_KEY = HookProfileSupport.class.getName();

    public void start(ElementStartContext context) {
        context.registerVisitorFactory((ElementVisitorFactory)this);
        context.getScopeData().put(PROFILE_SUPPORT_KEY, this.newProfileSupport());
    }

    public ElementVisitor getVisitor(ElementName name) {
        if (ProfileInfoHandler.EN_PROFILE_INFO.equals((Object)name)) {
            return this.psiHandler;
        }
        return this.pseHandler;
    }

    public void end(ElementEndContext context) {
        ProfileSupport ps = (ProfileSupport)context.getScopeData().get(PROFILE_SUPPORT_KEY);
        assert (ps != null);
        assert (ps.getProfileInfo() != null);
        assert (ps.getProfileInfo().getId() != null);
        ProfileSupportHandler.registerToolkits(new Class[]{ProfileSupport.class}, new Object[]{ps});
    }

    protected HookProfileSupport newProfileSupport() {
        return new HookProfileSupport();
    }

    static class ProfileSupportElementsHandler
    extends ElementVisitor {
        private static final ElementName EN_PROFILE_INFO_CLASS = BaseElementVisitor.e("profile-info-class");
        private static final ElementName EN_HASH_IO_CLASS = BaseElementVisitor.e("hash-io-class");
        private static final ElementName EN_COMMAND_FACTORY_CLASS = BaseElementVisitor.e("command-factory-class");
        private static final ElementName EN_FACTORY_CLASS = BaseElementVisitor.e("factory-class");
        private static final ElementName EN_RECOGNIZER_CLASS = BaseElementVisitor.e("recognizer-class");

        ProfileSupportElementsHandler() {
        }

        public void end(ElementEndContext context) {
            HookProfileSupport ps = (HookProfileSupport)context.getScopeData().get(HookProfileSupport.class.getName());
            assert (ps != null);
            ElementName en = context.getElementName();
            String text = context.getText().trim();
            if (EN_PROFILE_INFO_CLASS.equals((Object)en)) {
                ps.setProfileInfoClass((MetaClass<ProfileInfo>)BaseElementVisitor.makeMetaClass((ElementContext)context, text));
            }
            if (EN_COMMAND_FACTORY_CLASS.equals((Object)en)) {
                ps.setCommandFactoryClass((MetaClass<CommandFactory>)BaseElementVisitor.makeMetaClass((ElementContext)context, text));
            } else if (EN_HASH_IO_CLASS.equals((Object)en)) {
                ps.setHashIOClass((MetaClass<ProfileHashIO>)BaseElementVisitor.makeMetaClass((ElementContext)context, text));
            } else if (EN_FACTORY_CLASS.equals((Object)en)) {
                ps.setFactoryClass((MetaClass<ProfileFactory>)BaseElementVisitor.makeMetaClass((ElementContext)context, text));
            } else if (EN_RECOGNIZER_CLASS.equals((Object)en)) {
                ps.setRecognizerClass((MetaClass<ProfileRecognizer>)BaseElementVisitor.makeMetaClass((ElementContext)context, text));
            }
        }
    }
}

