/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.event;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.ide.util.Assert;
import oracle.jdeveloper.deploy.eventhub.Event;
import oracle.jdeveloper.deploy.eventhub.EventHandler;
import oracle.jdeveloper.deploy.eventhub.EventHub;
import oracle.jdeveloper.deploy.eventhub.Events;

public class EventHubImpl
extends EventHub {
    private final HashMap<Class, List<ListenerHandle>> listeners = new HashMap();

    @Override
    public <T> T getDispatcher(Class<T> intf) throws IllegalArgumentException {
        EventHubImpl.checkEventsInterface(intf);
        return (T)Proxy.newProxyInstance(intf.getClassLoader(), new Class[]{intf}, (InvocationHandler)new EventInvocationHandler(this, intf));
    }

    @Override
    public EventHub.Handle attach(Class intf, Object listener) {
        return this.attach(intf, listener, true);
    }

    @Override
    public EventHub.Handle attachHub(Class intf, EventHub hub) {
        return this.attachImpl(intf, hub, true);
    }

    @Override
    public EventHub.Handle attachDisabled(Class intf, Object listener) {
        return this.attach(intf, listener, false);
    }

    private ListenerHandle attach(Class intf, Object listener, boolean enabled) {
        EventHubImpl.checkEventsInterface(intf);
        Assert.check((boolean)EventHubImpl.checkListenerMethods(listener.getClass()));
        return this.attachImpl(intf, listener, enabled);
    }

    private ListenerHandle attachImpl(Class intf, Object listener, boolean enabled) {
        ListenerHandle handle = new ListenerHandle(this, intf, listener);
        if (enabled) {
            handle.enable();
        }
        this.register(handle);
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(ListenerHandle handle) {
        HashMap<Class, List<ListenerHandle>> hashMap = this.listeners;
        synchronized (hashMap) {
            for (Class cls : handle.categories) {
                List<ListenerHandle> list = this.listeners.get(cls);
                if (list == null) {
                    list = new CopyOnWriteArrayList<ListenerHandle>();
                    list.add(handle);
                    this.listeners.put(cls, list);
                    continue;
                }
                list.add(handle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(ListenerHandle handle) {
        HashMap<Class, List<ListenerHandle>> hashMap = this.listeners;
        synchronized (hashMap) {
            for (Class cls : handle.categories) {
                List<ListenerHandle> list = this.listeners.get(cls);
                list.remove(handle);
            }
        }
    }

    private static void checkEventsInterface(Class<?> intf) {
        if (!EventHubImpl.isInterface(intf)) {
            throw new IllegalArgumentException("Class " + intf.getName() + " should be an interface");
        }
        if (!EventHubImpl.isEventsInterface(intf)) {
            throw new IllegalArgumentException("Interface " + intf.getName() + " should have the @Events annotation");
        }
        Method[] methods = intf.getMethods();
        boolean found = false;
        for (Method method : methods) {
            Event event = method.getAnnotation(Event.class);
            if (event == null) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Interface " + intf.getName() + " does not have any public @Event annotations");
        }
    }

    private static boolean checkListenerMethods(Class<?> listenerClass) {
        if (listenerClass == Object.class) {
            return true;
        }
        Method[] methods = listenerClass.getDeclaredMethods();
        boolean found = false;
        for (Method method : methods) {
            EventHandler annotation = method.getAnnotation(EventHandler.class);
            if (annotation == null) continue;
            if (!Modifier.isPublic(method.getModifiers())) {
                Assert.println((String)String.format("WARNING: Method %s in %s is not public.", method.getName(), listenerClass.getName()));
                continue;
            }
            if (!method.getName().startsWith("on")) {
                Assert.println((String)String.format("WARNING: Method %s in %s does not follow naming convention. Should have prefix 'on'", method.getName(), listenerClass.getName()));
                continue;
            }
            found = true;
        }
        if (!found) {
            Assert.println((String)("WARNING: No public Event Handler methods found in " + listenerClass.getName()));
        }
        EventHubImpl.checkListenerMethods(listenerClass.getSuperclass());
        return true;
    }

    private static boolean isEventsInterface(Class<?> intf) {
        return intf.getAnnotation(Events.class) != null;
    }

    private static boolean isInterface(Class<?> intf) {
        return intf.isInterface();
    }

    private static class EventInvocationHandler
    implements InvocationHandler {
        final EventHubImpl hub;
        final Class category;

        private EventInvocationHandler(EventHubImpl hub, Class intf) {
            this.hub = hub;
            this.category = intf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
            List listenersList = null;
            HashMap hashMap = this.hub.listeners;
            synchronized (hashMap) {
                listenersList = (List)this.hub.listeners.get(this.category);
            }
            if (listenersList == null) {
                return Void.TYPE;
            }
            char[] chars = method.getName().toCharArray();
            char[] newChars = new char[chars.length + 2];
            newChars[0] = 111;
            newChars[1] = 110;
            newChars[2] = Character.toUpperCase(chars[0]);
            System.arraycopy(chars, 1, newChars, 3, chars.length - 1);
            String methodName = new String(newChars);
            for (ListenerHandle handle : listenersList) {
                if (!handle.isEnabled) continue;
                if (handle.listener instanceof EventHub) {
                    this.invokeOnEventHub(this.category, handle, method, args);
                    continue;
                }
                this.invokeOnListener(handle, methodName, method, args);
            }
            return Void.TYPE;
        }

        private void invokeOnEventHub(Class category, ListenerHandle handle, Method method, Object[] arguments) throws IllegalAccessException, InvocationTargetException {
            EventHub hub = (EventHub)handle.listener;
            Object dispatcher = hub.getDispatcher(category);
            method.invoke(dispatcher, arguments);
        }

        private void invokeOnListener(ListenerHandle handle, String methodName, Method intfMethod, Object[] arguments) throws IllegalAccessException, InvocationTargetException {
            Class<?> listenerClass = handle.listener.getClass();
            Method method = null;
            try {
                method = this.findMethod(listenerClass, methodName, intfMethod, arguments);
            }
            catch (NoSuchMethodException e) {
                Assert.println((String)("Skipped delivery of event " + methodName + "(...), since method is not defined in " + listenerClass.getName()));
                return;
            }
            EventHandler handler = method.getAnnotation(EventHandler.class);
            if (handler == null) {
                Assert.println((String)("Method " + methodName + " in " + listenerClass.getName() + " skipped. Missing @EventHandler annotation"));
                return;
            }
            method.setAccessible(true);
            method.invoke(handle.listener, arguments);
        }

        private Method findMethod(Class listenerClass, String methodName, Method intfMethod, Object[] arguments) throws NoSuchMethodException {
            return listenerClass.getMethod(methodName, intfMethod.getParameterTypes());
        }
    }

    private static class ListenerHandle
    implements EventHub.Handle {
        final EventHubImpl hub;
        final Class[] categories;
        final Object listener;
        boolean isEnabled = false;
        boolean isReleased = false;

        private ListenerHandle(EventHubImpl hub, Class intf, Object listener) {
            this.hub = hub;
            this.categories = ListenerHandle.getCategories(intf);
            this.listener = listener;
        }

        @Override
        public void enable() {
            this.isEnabled = true;
        }

        @Override
        public void disable() {
            this.isEnabled = false;
        }

        @Override
        public void release() {
            if (this.isReleased) {
                throw new IllegalStateException("Handle already released");
            }
            this.disable();
            this.isReleased = true;
            this.hub.unregister(this);
        }

        static Class[] getCategories(Class intf) {
            ArrayList<Class> categories = new ArrayList<Class>();
            ListenerHandle.getCategoriesImpl(intf, categories);
            return categories.toArray(new Class[categories.size()]);
        }

        private static void getCategoriesImpl(Class intf, ArrayList<Class> categories) {
            if (!EventHubImpl.isEventsInterface(intf)) {
                return;
            }
            categories.add(intf);
            for (Class<?> cls : intf.getInterfaces()) {
                ListenerHandle.getCategoriesImpl(cls, categories);
            }
        }
    }
}

