/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.common.AbstractHashDependable;
import oracle.jdeveloper.deploy.common.NodeDependable;

public class DefaultNodeDependable
extends AbstractHashDependable
implements NodeDependable {
    protected Node source_;
    protected Folder owner_;

    public DefaultNodeDependable(Node source, Folder owner) {
        this.source_ = source;
        this.owner_ = owner;
        this.setSourceURL(source.getURL());
        if (owner instanceof Locatable) {
            this.setOwnerURL(((Locatable)owner).getURL());
        }
        this.setReload(false);
    }

    public DefaultNodeDependable(HashStructure hash) {
        super(hash);
        this.setReload(true);
    }

    public URL getSourceURL() {
        return this._hash.getURL("sourceURL");
    }

    public void setSourceURL(URL url) {
        this._hash.putURL("sourceURL", url);
    }

    public URL getOwnerURL() {
        return this._hash.getURL("ownerURL");
    }

    public void setOwnerURL(URL url) {
        this._hash.putURL("ownerURL", url);
    }

    @Override
    public URL getNodeURL() {
        return this._hash.getURL("sourceURL");
    }

    @Override
    public Iterator getDependencies() {
        return Arrays.asList(new Object[0]).iterator();
    }

    @Override
    public Node getNode() {
        return (Node)this.getSource();
    }

    @Override
    public boolean doesExist() {
        if (this.source_ != null && NodeFactory.find((URL)this.source_.getURL()) != null) {
            return true;
        }
        return URLFileSystem.exists((URL)this.getNodeURL());
    }

    @Override
    public boolean cache() {
        this.cacheImpl();
        if (this.source_ == null || this.owner_ == null) {
            Assert.println((String)"DefaultNodeDependable():Source or Owner could not be loaded");
            return false;
        }
        return true;
    }

    @Override
    protected Element getSourceImpl() {
        return this.source_;
    }

    @Override
    protected Folder getSourceOwnerImpl() {
        return this.owner_;
    }

    protected void cacheImpl() {
        try {
            this.source_ = NodeFactory.findOrCreate((URL)this.getSourceURL());
            if (this.getOwnerURL() != null) {
                this.owner_ = (Folder)NodeFactory.findOrCreate((URL)this.getOwnerURL());
            }
        }
        catch (IllegalAccessException e) {
            Assert.printStackTrace((Throwable)e);
            this.source_ = null;
            this.owner_ = null;
        }
        catch (InstantiationException e) {
            Assert.printStackTrace((Throwable)e);
            this.source_ = null;
            this.owner_ = null;
        }
    }
}

