/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.cmd.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.deploy.ToolkitFactory;
import oracle.jdeveloper.deploy.cmd.DeployCommand;
import oracle.jdeveloper.deploy.cmd.spi.HashDeployCommandReader;
import oracle.jdeveloper.deploy.cmd.spi.HashDeployCommandWriter;
import oracle.jdeveloper.deploy.cmd.spi.providers.AbstractDeployCommandIOProvider;
import oracle.jdeveloper.deploy.spi.Cookie;
import oracle.jdeveloper.deploy.spi.DataElement;
import oracle.jdeveloper.deploy.tk.ToolkitBuilder;
import oracle.jdeveloper.deploy.tk.ToolkitRegistry;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;

public class LegacyDeployCommandIOProvider
extends AbstractDeployCommandIOProvider {
    static final String LEGACY_DATA_KEY = "oracle.jdeveloper.deploy.cmd.DeployCommandsConfiguration";
    static final String LEGACY_COMMAND_DEFINITIONS = "commandDefinitions";
    static final String LEGACY_COMMAND_LIST = "commandList";

    HashStructure getHashStructure(Element element) {
        HashStructure possibleHash = null;
        if (element instanceof PropertyStorage) {
            PropertyStorage ps = (PropertyStorage)element;
            possibleHash = ps.getProperties();
        } else if (element instanceof DataElement && element.getData() instanceof PropertyStorage) {
            possibleHash = ((PropertyStorage)element.getData()).getProperties();
        }
        return possibleHash;
    }

    @Override
    protected boolean canRead(Element element, ToolkitContext tkContext, Cookie cookie) {
        if (this.getHashStructure(element) != null) {
            cookie.bind(ToolkitContext.class, tkContext);
            return true;
        }
        return false;
    }

    @Override
    protected boolean canWrite(Element element, ToolkitContext tkContext, Cookie cookie) {
        if (this.getHashStructure(element) != null) {
            cookie.bind(ToolkitContext.class, tkContext);
            return true;
        }
        return false;
    }

    @Override
    protected Iterator<DeployCommand> iterator(Element element, Cookie cookie) {
        ListStructure list = this.getDeployCommandDefinitions(element, false);
        if (list == null) {
            return Collections.emptyList().iterator();
        }
        return new DeployCommandIterator(new HashDeployCommandReaderIterator(list, element, cookie));
    }

    synchronized HashStructure getDeployCommands(Element element, boolean create) {
        HashStructure hash = this.getHashStructure(element);
        if (create) {
            return hash.getOrCreateHashStructure(LEGACY_DATA_KEY);
        }
        return hash.getHashStructure(LEGACY_DATA_KEY);
    }

    synchronized ListStructure getDeployCommandDefinitions(Element element, boolean create) {
        HashStructure hash = this.getDeployCommands(element, create);
        if (hash == null) {
            return null;
        }
        if (create) {
            return hash.getOrCreateListStructure(LEGACY_COMMAND_DEFINITIONS);
        }
        return hash.getListStructure(LEGACY_COMMAND_DEFINITIONS);
    }

    synchronized ListStructure getDisplayableList(Element element, boolean create) {
        HashStructure hash = this.getDeployCommands(element, create);
        if (hash == null) {
            return null;
        }
        if (create) {
            return hash.getOrCreateListStructure(LEGACY_COMMAND_LIST);
        }
        return hash.getListStructure(LEGACY_COMMAND_LIST);
    }

    @Override
    protected List<DeployCommand> getAllCommands(Element element, Cookie cookie) {
        ArrayList<DeployCommand> list = new ArrayList<DeployCommand>();
        Iterator<DeployCommand> iter = this.iterator(element, cookie);
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    @Override
    protected List<Displayable> getDisplayables(Element element, Cookie cookie) {
        ArrayList<Displayable> displayables = new ArrayList<Displayable>();
        ListStructure displayableList = this.getDisplayableList(element, false);
        if (displayableList != null) {
            Iterator displayableIter = displayableList.iterator();
            while (displayableIter.hasNext()) {
                displayables.add(new HashDeployCommandWriter.HashDisplayable((HashStructure)displayableIter.next()));
            }
        }
        return displayables;
    }

    @Override
    protected DeployCommand getCommandAt(int index, Element element, Cookie cookie) {
        ListStructure list = this.getDeployCommandDefinitions(element, false);
        assert (index >= 0 && index < list.size());
        HashStructure hash = (HashStructure)list.get(index);
        HashDeployCommandReader reader = this.getReader(hash, element, cookie);
        return reader.read();
    }

    protected HashDeployCommandReader getReader(HashStructure hash, Element element, Cookie cookie) {
        Context context = cookie.get(ToolkitContext.class).getIdeContext();
        HashDeployCommandReader.SpiData spi = new HashDeployCommandReader.SpiData(context);
        spi.setHashStructure(hash.copyTo(null));
        HashDeployCommandReader reader = ToolkitFactory.Utils.narrowBuildFirst(element, context, HashDeployCommandReader.class);
        return reader;
    }

    @Override
    protected void removeAll(Element element, Cookie cookie) {
        ListStructure displayableList = this.getDisplayableList(element, false);
        if (displayableList != null) {
            displayableList.clear();
            ListStructure commandDefinitions = this.getDeployCommandDefinitions(element, false);
            assert (commandDefinitions != null);
            commandDefinitions.clear();
        }
    }

    @Override
    protected int count(Element element, Cookie cookie) {
        ListStructure list = this.getDisplayableList(element, false);
        return list == null ? 0 : list.size();
    }

    @Override
    protected void removeCommandAt(int index, Element element, Cookie cookie) {
        ListStructure displayableList = this.getDisplayableList(element, false);
        if (displayableList == null || displayableList.size() <= index) {
            throw new IndexOutOfBoundsException();
        }
        displayableList.remove(index);
        ListStructure commandDefinitions = this.getDeployCommandDefinitions(element, false);
        assert (commandDefinitions != null && index < commandDefinitions.size());
        commandDefinitions.remove(index);
    }

    @Override
    protected boolean write(DeployCommand command, Element element, Cookie cookie) {
        ToolkitContext tkContext = cookie.get(ToolkitContext.class);
        Context ideContext = tkContext.getIdeContext();
        HashDeployCommandWriter.SpiData spi = new HashDeployCommandWriter.SpiData(ideContext);
        spi.setCommand(command);
        ToolkitRegistry reg = tkContext.getMainToolkitRegistry();
        ToolkitBuilder builder = reg.getBuilder(element, ideContext, HashDeployCommandWriter.class);
        HashDeployCommandWriter writer = (HashDeployCommandWriter)builder.narrowBuildToolkits()[0];
        HashStructure hash = HashStructure.newInstance();
        writer.write(hash);
        ListStructure defnList = this.getDeployCommandDefinitions(element, true);
        defnList.add((Object)hash);
        HashDeployCommandWriter.HashDisplayable displayable = writer.getDisplayable();
        ListStructure dispList = this.getDisplayableList(element, true);
        dispList.add((Object)displayable.getHashStructure());
        return true;
    }

    final class HashDeployCommandReaderIterator
    implements ToolkitFactory,
    Iterator<HashDeployCommandReader> {
        final Iterator iter;
        final Element element;
        final Cookie cookie;
        HashStructure lastKey = null;

        HashDeployCommandReaderIterator(ListStructure deployCommandDefinitions, Element element, Cookie cookie) {
            assert (deployCommandDefinitions != null);
            this.iter = deployCommandDefinitions.iterator();
            this.element = element;
            this.cookie = cookie;
        }

        @Override
        public boolean hasNext() {
            boolean b = this.iter.hasNext();
            if (!b) {
                this.lastKey = null;
            }
            return b;
        }

        @Override
        public HashDeployCommandReader next() {
            this.lastKey = (HashStructure)this.iter.next();
            return LegacyDeployCommandIOProvider.this.getReader(this.lastKey, this.element, this.cookie);
        }

        @Override
        public void remove() {
            if (this.lastKey != null) {
                this.iter.remove();
                return;
            }
            throw new IllegalStateException("Nothing to remove");
        }
    }

    final class DeployCommandIterator
    implements Iterator<DeployCommand> {
        final HashDeployCommandReaderIterator readerIter;

        DeployCommandIterator(HashDeployCommandReaderIterator iterator) {
            this.readerIter = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.readerIter.hasNext();
        }

        @Override
        public DeployCommand next() {
            return this.readerIter.next().read();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove using iterator. Use removeCommandAt() instead.");
        }
    }
}

