/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.contrib.spi;

import oracle.ide.Context;
import oracle.jdeveloper.deploy.Stateful;
import oracle.jdeveloper.deploy.contrib.ContribException;
import oracle.jdeveloper.deploy.contrib.Listener;
import oracle.jdeveloper.deploy.contrib.Processor;
import oracle.jdeveloper.deploy.contrib.StatefulProcessor;
import oracle.jdeveloper.deploy.contrib.events.ContributedObjectChange;
import oracle.jdeveloper.deploy.contrib.events.ProcessorStateChange;
import oracle.jdeveloper.deploy.contrib.spi.DefaultProcessor;
import oracle.jdeveloper.deploy.contrib.spi.StatefulProcessor;
import oracle.jdeveloper.deploy.eventhub.EventHub;
import oracle.jdeveloper.deploy.spi.Cookie;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;

public abstract class DefaultStatefulProcessor<T>
extends DefaultProcessor<T>
implements StatefulProcessor<T> {
    public Stateful.State state = new Stateful.State(){

        @Override
        protected void fireInitialized() {
            DefaultStatefulProcessor.this.fireStateChanged();
        }

        @Override
        protected void fireInvalidated() {
            DefaultStatefulProcessor.this.fireStateInvalidated();
        }

        @Override
        protected void fireReleased() {
            DefaultStatefulProcessor.this.fireStateReleased();
        }
    };
    private boolean stateInitiaalized = false;
    private boolean stateInvalaidated = false;
    private int objectChangeListeners = 0;
    private int stateChangeListeners = 0;
    private EventHub privateHub = null;

    protected DefaultStatefulProcessor(ToolkitContext tkContext, Cookie cookie) {
        super(tkContext, cookie);
    }

    @Override
    public StatefulProcessor.Handle addObjectChangeListener(Listener<? extends ContributedObjectChange> listener) {
        if (!this.state.isInitialized()) {
            throw new IllegalStateException("Should call initialize() before listening for object change events");
        }
        return new ObjectChangeListenerHandle(listener);
    }

    @Override
    protected void processImpl(Processor.Visitor<T> visitor, Cookie cookie) throws ContribException {
    }

    @Override
    public StatefulProcessor.Handle addStateChangeListener(Listener<ProcessorStateChange> listener) {
        return new StateChangeListenerHandle(listener);
    }

    protected void fireStateChanged() {
        if (this.stateChangeListeners > 0) {
            this.privateHub().getDispatcher(ProcessorStateChange.class).stateChanged(this);
        }
    }

    protected void fireStateInvalidated() {
        if (this.stateChangeListeners > 0) {
            this.privateHub().getDispatcher(ProcessorStateChange.class).stateInvalidated(this);
        }
    }

    protected void fireStateReleased() {
        if (this.stateChangeListeners > 0) {
            this.privateHub().getDispatcher(ProcessorStateChange.class).stateReleased(this);
        }
    }

    protected void fireObjectAdded(T object, Context context) {
        if (this.state.isInitialized() && this.objectChangeListeners > 0) {
            this.dispatchObjectAddedEvent(this.privateHub(), object, this, context);
        }
    }

    protected void fireObjectModified(T object, Context context) {
        if (this.state.isInitialized() && this.objectChangeListeners > 0) {
            this.dispatchObjectModifiedEvent(this.privateHub(), object, this, context);
        }
    }

    protected void fireObjectRemoved(T object, Context context) {
        if (this.state.isInitialized() && this.objectChangeListeners > 0) {
            this.dispatchObjectRemovedEvent(this.privateHub(), object, this, context);
        }
    }

    protected abstract void dispatchObjectAddedEvent(EventHub var1, T var2, StatefulProcessor var3, Context var4);

    protected abstract void dispatchObjectModifiedEvent(EventHub var1, T var2, StatefulProcessor var3, Context var4);

    protected abstract void dispatchObjectRemovedEvent(EventHub var1, T var2, StatefulProcessor var3, Context var4);

    @Override
    public void process(Processor.Visitor<T> visitor) throws ContribException {
        if (!this.state.isInitialized()) {
            throw new IllegalStateException("State not initialized: " + this);
        }
        super.process(visitor);
    }

    protected Object stateLockObject() {
        return this;
    }

    private void incrementObjectChangeListener() {
        ++this.objectChangeListeners;
        if (this.objectChangeListeners == 1) {
            this.addObjectChangeListeners();
        }
    }

    private void decrementObjectChangeListener() {
        --this.objectChangeListeners;
        if (this.objectChangeListeners == 0) {
            this.removeObjectChangeListeners();
        }
    }

    private void incrementStateChangeListener() {
        ++this.stateChangeListeners;
        if (this.stateChangeListeners == 1) {
            this.addStateChangeListeners();
        }
    }

    private void decrementStateChangeListener() {
        --this.stateChangeListeners;
        if (this.stateChangeListeners == 0) {
            this.removeStateChangeListeners();
        }
    }

    @Override
    public void initializeState() {
        this.state.tran(0);
    }

    @Override
    public void invalidateState() {
        this.state.tran(1);
    }

    @Override
    public void releaseState() {
        this.state.tran(2);
    }

    protected synchronized EventHub privateHub() {
        if (this.privateHub == null) {
            this.privateHub = this.createPrivateHub();
        }
        return this.privateHub;
    }

    protected EventHub createPrivateHub() {
        this.privateHub = EventHub.createPrivateHub();
        return this.privateHub;
    }

    protected void addObjectChangeListeners() {
    }

    protected void removeObjectChangeListeners() {
    }

    protected void addStateChangeListeners() {
    }

    protected void removeStateChangeListeners() {
    }

    protected abstract Class<? extends ContributedObjectChange> objectChangeEventCategory();

    protected abstract class Dispatcher<R extends ContributedObjectChange> {
        protected Dispatcher() {
        }

        protected Context getContext() {
            return DefaultStatefulProcessor.this.getContext();
        }

        protected StatefulProcessor getProcessor() {
            return DefaultStatefulProcessor.this;
        }

        public final void dispatch() {
            if (DefaultStatefulProcessor.this.state.isInitialized() && DefaultStatefulProcessor.this.objectChangeListeners > 0) {
                this.sendEvent(DefaultStatefulProcessor.this.privateHub.getDispatcher(DefaultStatefulProcessor.this.objectChangeEventCategory()));
            }
        }

        protected abstract void sendEvent(R var1);
    }

    private class StateChangeListenerHandle
    implements StatefulProcessor.Handle {
        EventHub.Handle delegate;

        private StateChangeListenerHandle(Object listener) {
            this.delegate = DefaultStatefulProcessor.this.privateHub().attachDisabled(ProcessorStateChange.class, listener);
            DefaultStatefulProcessor.this.incrementStateChangeListener();
            this.delegate.enable();
        }

        @Override
        public void enable() {
            DefaultStatefulProcessor.this.incrementStateChangeListener();
            this.delegate.enable();
        }

        @Override
        public void disable() {
            DefaultStatefulProcessor.this.decrementStateChangeListener();
            this.delegate.disable();
        }

        @Override
        public void release() {
            DefaultStatefulProcessor.this.decrementStateChangeListener();
            this.delegate.release();
            this.delegate = null;
        }
    }

    private class ObjectChangeListenerHandle
    implements StatefulProcessor.Handle {
        EventHub.Handle delegate;

        ObjectChangeListenerHandle(Object listener) {
            this.delegate = DefaultStatefulProcessor.this.privateHub().attachDisabled(DefaultStatefulProcessor.this.objectChangeEventCategory(), listener);
            DefaultStatefulProcessor.this.incrementObjectChangeListener();
            this.delegate.enable();
        }

        @Override
        public void enable() {
            this.delegate.enable();
        }

        @Override
        public void disable() {
            this.delegate.disable();
        }

        @Override
        public void release() {
            DefaultStatefulProcessor.this.decrementObjectChangeListener();
            this.delegate.release();
            this.delegate = null;
        }
    }
}

