/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.contrib;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.jdeveloper.deploy.ToolkitFactory;
import oracle.jdeveloper.deploy.contrib.Contributor;
import oracle.jdeveloper.deploy.contrib.spi.HashContributorReader;
import oracle.jdeveloper.deploy.contrib.spi.HashContributorWriter;

public class Contributors {
    final ListStructure list;
    private static final String KEY_CONTRIBUTORS = "contributors";
    private final ArrayList<Contributor> cache;
    private final Context context;

    public Contributors(ListStructure list, Context context) {
        if (list == null) {
            throw new IllegalArgumentException("List argument cannot be null");
        }
        this.list = list;
        this.context = context;
        this.cache = this.getContributorList();
    }

    public Contributors(Context context) {
        this(ListStructure.newInstance(), context);
    }

    public Contributors() {
        this(new Context());
    }

    public Contributor[] getContributors() {
        return this.cache.toArray(new Contributor[this.cache.size()]);
    }

    private ArrayList<Contributor> getContributorList() {
        ArrayList<Contributor> contributors = new ArrayList<Contributor>();
        for (HashStructure hash : this.list) {
            contributors.add(this.readContributor(hash));
        }
        return contributors;
    }

    public void setContributors(Contributor[] newContributors) {
        this.clear();
        for (Contributor c : newContributors) {
            this.add(c);
        }
    }

    public void add(Contributor contributor) {
        if (this.cache.contains((Object)contributor)) {
            return;
        }
        HashStructure hash = HashStructure.newInstance();
        this.writeContributor(hash, contributor);
        this.list.add((Object)hash);
        this.cache.add(contributor);
    }

    public void remove(Contributor contributor) {
        if (this.cache.contains((Object)contributor)) {
            this.cache.remove((Object)contributor);
            Iterator iter = this.list.iterator();
            while (iter.hasNext()) {
                Contributor c = new Contributor((HashStructure)iter.next());
                if (!c.equals((Object)contributor)) continue;
                iter.remove();
                return;
            }
            throw new IllegalStateException("Contributor " + contributor.getContributorType() + " not found ");
        }
    }

    public boolean contains(Contributor contributor) {
        return this.cache.contains((Object)contributor);
    }

    public boolean contains(String type) {
        return this.cache.contains((Object)Contributor.create(type));
    }

    public void clear() {
        this.cache.clear();
        this.list.clear();
    }

    public static Contributors getOrCreateInstance(HashStructure hash, Context context) {
        return new Contributors(hash.getOrCreateListStructure(KEY_CONTRIBUTORS), context);
    }

    public static Contributors getOrCreateInstance(HashStructure hash) {
        return new Contributors(hash.getOrCreateListStructure(KEY_CONTRIBUTORS), new Context());
    }

    public static Contributors getInstance(HashStructure hash, Context context) {
        ListStructure list = hash.getListStructure(KEY_CONTRIBUTORS);
        if (list == null) {
            return null;
        }
        return new Contributors(list, context);
    }

    public static Contributors getInstance(HashStructure hash) {
        return Contributors.getInstance(hash, new Context());
    }

    public ListStructure getListStructure() {
        return this.list;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Contributors) {
            Contributor[] other;
            Contributor[] self = this.getContributors();
            if (self.length != (other = ((Contributors)obj).getContributors()).length) {
                return false;
            }
            for (int i = 0; i < self.length; ++i) {
                if (self[i].equals((Object)other[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Contributor readContributor(HashStructure hash) {
        Context ctx = new Context(this.context);
        HashContributorReader.SpiData spi = new HashContributorReader.SpiData(ctx);
        spi.setHashStructure(hash);
        HashContributorReader reader = ToolkitFactory.Utils.narrowBuildFirstOrNull(ctx, HashContributorReader.class);
        return reader.read();
    }

    private void writeContributor(HashStructure hash, Contributor contributor) {
        Context ctx = new Context(this.context);
        HashContributorWriter.SpiData spi = new HashContributorWriter.SpiData(ctx);
        spi.setContributor(contributor);
        HashContributorWriter writer = ToolkitFactory.Utils.narrowBuildFirstOrNull(ctx, HashContributorWriter.class);
        writer.write(hash);
    }
}

