/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.StateException;
import oracle.jdeveloper.deploy.StatefulDeployer;
import oracle.jdeveloper.deploy.common.AbstractDeployer;
import oracle.jdeveloper.deploy.eventhub.EventHub;
import oracle.jdeveloper.deploy.eventhub.spi.AbstractHandle;
import oracle.jdeveloper.deploy.events.DeployerStateChange;
import oracle.jdeveloper.deploy.shell.ShellAdapter;

public abstract class AbstractStatefulDeployer
extends AbstractDeployer
implements StatefulDeployer {
    final EventHub hub = EventHub.createPrivateHub();
    private boolean stateListenersEnabled = false;
    private boolean initialized = false;
    private boolean released = false;
    private boolean isStateful = true;
    private boolean prepared = false;
    private volatile boolean isInDeployerCodeBlock = false;

    public AbstractStatefulDeployer(int sequence) {
        super(sequence);
    }

    @Override
    public void prepare(int deploySequenceId, DeployShell shell) throws DeployException {
        this.isStateful = ShellAdapter.getInstance(shell).isStatefulDeployment();
        if (!this.isStateful && !this.initialized) {
            try {
                this.initializeState();
                this.initialized = true;
            }
            catch (StateException e) {
                throw new DeployException(e);
            }
        }
        this.isInDeployerCodeBlock = true;
        try {
            super.prepare(deploySequenceId, shell);
        }
        catch (RuntimeException e) {
            DeployerStateException dse = DeployerStateException.getIfRecognizedException(e);
            if (dse != null) {
                throw new DeployException("Could not complete prepare operation", dse);
            }
            throw e;
        }
        finally {
            this.isInDeployerCodeBlock = true;
            this.prepared = true;
        }
    }

    @Override
    public void finish(int deploySequenceId, DeployShell shell) {
        if (!this.isStateful && this.initialized && !this.released) {
            this.releaseState();
        }
        if (this.prepared) {
            super.finish(deploySequenceId, shell);
        }
    }

    @Override
    public StatefulDeployer.Handle attachStateChangeListener(Object listener) {
        StatefulDeployer.Handle handle = this.attachDisabledStateChangeListener(listener);
        handle.enable();
        return handle;
    }

    @Override
    public void deploy(int deploySequenceId, DeployShell shell) throws DeployException {
        this.isInDeployerCodeBlock = true;
        try {
            super.deploy(deploySequenceId, shell);
        }
        catch (RuntimeException e) {
            DeployerStateException dse = DeployerStateException.getIfRecognizedException(e);
            if (dse != null) {
                throw new DeployException("Could not complete prepare operation", dse);
            }
            throw e;
        }
        finally {
            this.isInDeployerCodeBlock = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatefulDeployer.Handle attachDisabledStateChangeListener(Object listener) {
        Object object = this.stateLockObject();
        synchronized (object) {
            EventHub.Handle handle = this.hub.attachDisabled(DeployerStateChange.class, listener);
            return new Handle(handle, false);
        }
    }

    protected Object stateLockObject() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeState() {
        Object object = this.stateLockObject();
        synchronized (object) {
            this.initialized = true;
            this.fireStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateState() {
        Object object = this.stateLockObject();
        synchronized (object) {
            this.fireStateInvalidated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseState() {
        Object object = this.stateLockObject();
        synchronized (object) {
            this.released = true;
            this.fireStateReleased();
        }
    }

    protected void fireStateChanged() {
        if (!this.stateListenersEnabled) {
            return;
        }
        DeployerStateChange dispatcher = this.hub.getDispatcher(DeployerStateChange.class);
        dispatcher.stateChanged(this);
    }

    protected void fireStateInvalidated() {
        if (!this.stateListenersEnabled) {
            return;
        }
        DeployerStateChange dispatcher = this.hub.getDispatcher(DeployerStateChange.class);
        dispatcher.stateInvalidated(this);
        if (this.isInDeployerCodeBlock) {
            throw new DeployerStateException("State invalidated during deployment");
        }
    }

    protected void fireStateReleased() {
        if (!this.stateListenersEnabled) {
            return;
        }
        DeployerStateChange dispatcher = this.hub.getDispatcher(DeployerStateChange.class);
        dispatcher.stateReleased(this);
    }

    protected void addStateChangeListeners() {
    }

    protected void removeStateChangeListeners() {
    }

    private static class DeployerStateException
    extends StateException {
        private static final long serialVersionUID = 2177241535823789526L;

        private DeployerStateException(String msg) {
            super(msg);
        }

        private static DeployerStateException getIfRecognizedException(Throwable e) {
            if (e == null) {
                return null;
            }
            Throwable next = e;
            do {
                if (next.getClass() != DeployerStateException.class) continue;
                return (DeployerStateException)next;
            } while ((next = (e = next).getCause()) != null && next != e);
            return null;
        }
    }

    private class Handle
    extends AbstractHandle
    implements StatefulDeployer.Handle {
        Handle(EventHub.Handle delegate, boolean isEnabled) {
            super(delegate, isEnabled);
        }

        @Override
        protected void handleDisabled() {
            AbstractStatefulDeployer.this.stateListenersEnabled = false;
            AbstractStatefulDeployer.this.removeStateChangeListeners();
        }

        @Override
        protected void handleEnabled() {
            AbstractStatefulDeployer.this.stateListenersEnabled = true;
            AbstractStatefulDeployer.this.addStateChangeListeners();
        }
    }
}

